<?php
/**
 * File Test Koneksi Database
 * Buka di browser: http://localhost/marketplace1/admin/test_database.php
 */

echo "<h2>🔍 Test Database Marketplace</h2>";
echo "<hr>";

// Koneksi database
$host = 'localhost';
$user = 'root';
$pass = '';
$db = 'marketplace';

$conn = new mysqli($host, $user, $pass, $db);

// Cek koneksi
echo "<h3>1. Test Koneksi Database:</h3>";
if ($conn->connect_error) {
    echo "❌ <strong style='color:red'>GAGAL KONEKSI!</strong><br>";
    echo "Error: " . $conn->connect_error . "<br>";
    echo "<br><strong>Solusi:</strong><br>";
    echo "- Pastikan MySQL sudah running di XAMPP<br>";
    echo "- Pastikan database 'marketplace' sudah dibuat<br>";
    echo "- Import file database_admin.sql dulu!<br>";
    die();
} else {
    echo "✅ <strong style='color:green'>Koneksi Berhasil!</strong><br>";
}

// Cek apakah database ada
echo "<br><h3>2. Test Database 'marketplace':</h3>";
$db_check = $conn->select_db($db);
if(!$db_check) {
    echo "❌ <strong style='color:red'>Database 'marketplace' TIDAK DITEMUKAN!</strong><br>";
    echo "<br><strong>Solusi:</strong><br>";
    echo "- Buka phpMyAdmin: <a href='http://localhost/phpmyadmin/' target='_blank'>http://localhost/phpmyadmin/</a><br>";
    echo "- Import file: database_admin.sql<br>";
    die();
} else {
    echo "✅ <strong style='color:green'>Database 'marketplace' ditemukan!</strong><br>";
}

// Cek apakah tabel admin ada
echo "<br><h3>3. Test Tabel 'admin':</h3>";
$table_check = $conn->query("SHOW TABLES LIKE 'admin'");
if($table_check->num_rows == 0) {
    echo "❌ <strong style='color:red'>Tabel 'admin' TIDAK DITEMUKAN!</strong><br>";
    echo "<br><strong>Solusi:</strong><br>";
    echo "- Buka phpMyAdmin: <a href='http://localhost/phpmyadmin/' target='_blank'>http://localhost/phpmyadmin/</a><br>";
    echo "- Pilih database 'marketplace'<br>";
    echo "- Import file: database_admin.sql<br>";
    die();
} else {
    echo "✅ <strong style='color:green'>Tabel 'admin' ditemukan!</strong><br>";
}

// Cek data admin
echo "<br><h3>4. Test Data Admin:</h3>";
$result = $conn->query("SELECT * FROM admin");

if($result->num_rows == 0) {
    echo "❌ <strong style='color:red'>TIDAK ADA DATA ADMIN!</strong><br>";
    echo "<br><strong>Solusi:</strong><br>";
    echo "- Import ulang file: database_admin.sql<br>";
    echo "- Atau insert manual di phpMyAdmin<br>";
} else {
    echo "✅ <strong style='color:green'>Data admin ditemukan: " . $result->num_rows . " user</strong><br><br>";
    
    echo "<table border='1' cellpadding='10' style='border-collapse:collapse;'>";
    echo "<tr style='background:#667eea;color:white;'>";
    echo "<th>ID</th><th>Nama Admin</th><th>Username</th><th>Password (MD5)</th><th>Email</th><th>Level</th><th>Status</th>";
    echo "</tr>";
    
    while($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id_admin'] . "</td>";
        echo "<td>" . $row['nama_admin'] . "</td>";
        echo "<td><strong>" . $row['username'] . "</strong></td>";
        echo "<td style='font-size:10px;'>" . $row['password'] . "</td>";
        echo "<td>" . $row['email'] . "</td>";
        echo "<td>" . $row['level'] . "</td>";
        echo "<td>" . $row['status'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Test login manual
echo "<br><h3>5. Test Login dengan admin/admin123:</h3>";

$test_username = 'admin';
$test_password = 'admin123';
$test_password_md5 = md5($test_password);

echo "Username: <strong>$test_username</strong><br>";
echo "Password: <strong>$test_password</strong><br>";
echo "Password MD5: <strong>$test_password_md5</strong><br><br>";

$stmt = $conn->prepare("SELECT * FROM admin WHERE username = ? AND password = ?");
$stmt->bind_param("ss", $test_username, $test_password_md5);
$stmt->execute();
$login_result = $stmt->get_result();

if($login_result->num_rows > 0) {
    $admin = $login_result->fetch_assoc();
    echo "✅ <strong style='color:green;font-size:18px;'>LOGIN BERHASIL!</strong><br><br>";
    echo "Data yang akan disimpan ke session:<br>";
    echo "- id_admin: " . $admin['id_admin'] . "<br>";
    echo "- nama_admin: " . $admin['nama_admin'] . "<br>";
    echo "- username: " . $admin['username'] . "<br>";
    echo "- level: " . $admin['level'] . "<br>";
    
    echo "<br><div style='background:#d4edda;padding:15px;border-radius:10px;border:2px solid #28a745;'>";
    echo "<strong>🎉 DATABASE SUDAH BENAR!</strong><br>";
    echo "Anda bisa login dengan kredensial:<br>";
    echo "Username: <strong>admin</strong><br>";
    echo "Password: <strong>admin123</strong><br><br>";
    echo "<a href='index.php' style='background:#667eea;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>🔐 Coba Login Sekarang</a>";
    echo "</div>";
    
} else {
    echo "❌ <strong style='color:red;font-size:18px;'>LOGIN GAGAL!</strong><br>";
    echo "Username atau password tidak ditemukan di database!<br>";
    echo "<br><strong>Solusi:</strong><br>";
    echo "- Import ulang file database_admin.sql<br>";
    echo "- Atau cek password sudah di-encrypt MD5 dengan benar<br>";
}

$conn->close();

echo "<br><br><hr>";
echo "<p style='text-align:center;color:#666;'>File Test: test_database.php | Marketplace Admin Panel</p>";
?>

<style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        padding: 20px;
        background: #f5f5f5;
    }
    h2 { color: #667eea; }
    h3 { color: #333; margin-top: 20px; }
</style>

