<?php
/**
 * File Debug Login
 * Untuk test kenapa login tidak bisa
 * Akses: http://localhost/marketplace1/admin/test_login_debug.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>🔧 Debug Login System</h2>";
echo "<hr>";

// Test 1: Cek apakah form bisa submit
echo "<h3>Test Form Login:</h3>";
?>

<form method="POST" action="">
    <label>Username:</label><br>
    <input type="text" name="username" value="admin" required><br><br>
    
    <label>Password:</label><br>
    <input type="password" name="password" value="admin123" required><br><br>
    
    <button type="submit" name="submit" style="background:#667eea;color:white;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;">
        🔐 Test Login
    </button>
</form>

<hr>

<?php
if(isset($_POST['submit'])) {
    
    echo "<h3>📝 Data Form yang Diterima:</h3>";
    echo "Username: <strong>" . htmlspecialchars($_POST['username']) . "</strong><br>";
    echo "Password: <strong>" . htmlspecialchars($_POST['password']) . "</strong><br>";
    echo "Password MD5: <strong>" . md5($_POST['password']) . "</strong><br><br>";
    
    // Test koneksi database
    echo "<h3>🗄️ Test Koneksi Database:</h3>";
    $conn = new mysqli('localhost', 'root', '', 'marketplace');
    
    if ($conn->connect_error) {
        echo "❌ <span style='color:red;'>Koneksi database GAGAL: " . $conn->connect_error . "</span><br>";
        echo "<br><strong>SOLUSI:</strong><br>";
        echo "1. Pastikan MySQL running di XAMPP<br>";
        echo "2. Import database_admin.sql dulu!<br>";
    } else {
        echo "✅ <span style='color:green;'>Koneksi database BERHASIL!</span><br><br>";
        
        // Test query login
        echo "<h3>🔍 Test Query Login:</h3>";
        
        $username = $_POST['username'];
        $password = md5($_POST['password']);
        
        $sql = "SELECT * FROM admin WHERE username = '$username' AND password = '$password'";
        echo "Query: <code style='background:#f4f4f4;padding:5px;'>$sql</code><br><br>";
        
        $result = $conn->query($sql);
        
        if(!$result) {
            echo "❌ <span style='color:red;'>Query ERROR: " . $conn->error . "</span><br>";
            echo "<br><strong>SOLUSI:</strong><br>";
            echo "1. Pastikan tabel 'admin' sudah ada<br>";
            echo "2. Import database_admin.sql<br>";
        } else {
            echo "✅ Query berhasil dijalankan!<br>";
            echo "Jumlah data ditemukan: <strong>" . $result->num_rows . "</strong><br><br>";
            
            if($result->num_rows > 0) {
                $data = $result->fetch_assoc();
                
                echo "<div style='background:#d4edda;padding:20px;border-radius:10px;border:2px solid #28a745;'>";
                echo "<h3 style='color:#155724;margin-top:0;'>🎉 LOGIN BERHASIL!</h3>";
                echo "<strong>Data Admin:</strong><br>";
                echo "ID: " . $data['id_admin'] . "<br>";
                echo "Nama: " . $data['nama_admin'] . "<br>";
                echo "Username: " . $data['username'] . "<br>";
                echo "Email: " . $data['email'] . "<br>";
                echo "Level: " . $data['level'] . "<br>";
                echo "Status: " . $data['status'] . "<br>";
                echo "</div>";
                
                // Test session
                echo "<br><h3>💾 Test Session:</h3>";
                session_start();
                
                $_SESSION['test_id_admin'] = $data['id_admin'];
                $_SESSION['test_nama_admin'] = $data['nama_admin'];
                $_SESSION['test_username'] = $data['username'];
                
                if(isset($_SESSION['test_id_admin'])) {
                    echo "✅ <span style='color:green;'>Session BISA disimpan!</span><br>";
                    echo "Session ID Admin: " . $_SESSION['test_id_admin'] . "<br>";
                    echo "Session Nama: " . $_SESSION['test_nama_admin'] . "<br>";
                } else {
                    echo "❌ <span style='color:red;'>Session TIDAK bisa disimpan!</span><br>";
                    echo "<br><strong>SOLUSI:</strong><br>";
                    echo "1. Pastikan folder application/cache/session/ ada<br>";
                    echo "2. Pastikan folder writable (chmod 777 di Linux)<br>";
                }
                
                echo "<br><div style='background:#fff3cd;padding:15px;border-radius:10px;border:2px solid #ffc107;'>";
                echo "<strong>⚠️ JIKA MASIH TIDAK BISA LOGIN DI HALAMAN UTAMA:</strong><br>";
                echo "Kemungkinan masalah:<br>";
                echo "1. <strong>Autoload library belum load</strong> - Cek application/config/autoload.php<br>";
                echo "2. <strong>Session path salah</strong> - Cek application/config/config.php<br>";
                echo "3. <strong>Base URL salah</strong> - Cek application/config/config.php<br>";
                echo "4. <strong>Form action salah</strong> - Cek di login.php<br>";
                echo "5. <strong>Cache browser</strong> - Clear cache browser (Ctrl+Shift+Delete)<br>";
                echo "</div>";
                
                echo "<br><a href='index.php' style='background:#667eea;color:white;padding:15px 30px;text-decoration:none;border-radius:10px;font-weight:600;display:inline-block;'>🚀 Coba Login di Halaman Utama</a>";
                
            } else {
                echo "<div style='background:#f8d7da;padding:20px;border-radius:10px;border:2px solid #dc3545;'>";
                echo "<h3 style='color:#721c24;margin-top:0;'>❌ LOGIN GAGAL!</h3>";
                echo "Username atau password tidak ditemukan di database!<br><br>";
                echo "<strong>SOLUSI:</strong><br>";
                echo "1. Pastikan sudah import database_admin.sql<br>";
                echo "2. Buka phpMyAdmin dan cek tabel 'admin'<br>";
                echo "3. Pastikan ada data dengan username: <strong>admin</strong><br>";
                echo "4. Password di database harus: <strong>0192023a7bbd73250516f069df18b500</strong> (MD5 dari 'admin123')<br>";
                echo "</div>";
            }
        }
        
        $conn->close();
    }
}
?>

<style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        padding: 20px;
        background: #f5f5f5;
        max-width: 900px;
        margin: 0 auto;
    }
    h2 { color: #667eea; }
    h3 { color: #333; margin-top: 20px; }
    input[type="text"], input[type="password"] {
        padding: 10px;
        width: 300px;
        border: 2px solid #e0e0e0;
        border-radius: 5px;
        font-size: 14px;
    }
    label {
        font-weight: 600;
        color: #333;
    }
    code {
        background: #f4f4f4;
        padding: 2px 6px;
        border-radius: 3px;
        font-family: monospace;
    }
</style>

