<?php
$host = 'localhost';
$db   = 'gerabah';
$user = 'root';
$pass = '';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
    
    // Check columns
    echo "Columns in transaksi table:\n";
    $stmt = $pdo->query("SHOW COLUMNS FROM transaksi");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    print_r($columns);
    
    // Check distinct status
    $status_col = null;
    if(in_array('status_transaksi', $columns)) {
        $status_col = 'status_transaksi';
        echo "\nUsing column: status_transaksi\n";
    } elseif(in_array('status', $columns)) {
        $status_col = 'status';
        echo "\nUsing column: status\n";
    }
    
    if($status_col) {
        echo "\nDistinct status values:\n";
        $stmt = $pdo->query("SELECT DISTINCT $status_col, COUNT(*) as count FROM transaksi GROUP BY $status_col");
        while ($row = $stmt->fetch()) {
            echo $row[$status_col] . ": " . $row['count'] . "\n";
        }
    } else {
        echo "\nNo status column found!\n";
    }

} catch (\PDOException $e) {
    throw new \PDOException($e->getMessage(), (int)$e->getCode());
}
?>
