<?php
$mysqli = new mysqli("localhost", "root", "", "gerabah");

if ($mysqli->connect_errno) {
    echo "Failed to connect to MySQL: " . $mysqli->connect_error;
    exit();
}

echo "=== Checking Refund Synchronization ===\n";

// Get all transactions that have refunds in retur table
$sql = "SELECT id_transaksi, SUM(nominal_refund) as calculated_refund 
        FROM retur 
        WHERE status_retur = 'selesai' AND jenis_retur = 'refund_dana'
        GROUP BY id_transaksi";

$result = $mysqli->query($sql);

if ($result) {
    $discrepancies = 0;
    while ($row = $result->fetch_assoc()) {
        $id_transaksi = $row['id_transaksi'];
        $calculated_refund = $row['calculated_refund'];
        
        // Get current total_refund in transaksi table
        $trans_result = $mysqli->query("SELECT total_refund FROM transaksi WHERE id_transaksi = $id_transaksi");
        if ($trans_result && $trans_row = $trans_result->fetch_assoc()) {
            $current_refund = $trans_row['total_refund'];
            
            if (abs($calculated_refund - $current_refund) > 0.01) { // Float comparison
                echo "Discrepancy found for Transaction ID $id_transaksi:\n";
                echo "  Calculated from Retur: $calculated_refund\n";
                echo "  Stored in Transaksi: $current_refund\n";
                $discrepancies++;
            }
        }
    }
    
    if ($discrepancies == 0) {
        echo "All refunds are synchronized correctly.\n";
    } else {
        echo "Found $discrepancies discrepancies.\n";
    }
} else {
    echo "Error querying retur table: " . $mysqli->error . "\n";
}

$mysqli->close();
?>
