# 🔐 Panduan Setup Midtrans Payment Gateway

## 📋 Langkah-langkah Setup

### 1. Daftar Akun Midtrans

1. Kunjungi: https://dashboard.midtrans.com/register
2. Isi formulir pendaftaran
3. Verifikasi email Anda
4. Login ke dashboard Midtrans

### 2. Dapatkan API Keys

#### Untuk Testing (Sandbox):
1. Login ke dashboard: https://dashboard.sandbox.midtrans.com/
2. Klik menu **Settings** > **Access Keys**
3. Salin **Server Key** dan **Client Key** dengan prefix `SB-Mid-`

#### Untuk Production (Live):
1. Login ke dashboard: https://dashboard.midtrans.com/
2. Klik menu **Settings** > **Access Keys**  
3. Salin **Server Key** dan **Client Key** dengan prefix `Mid-`

### 3. Konfigurasi API Keys

Buka file: `customer/application/config/midtrans.php`

```php
// SANDBOX - Untuk Testing
$config['midtrans_server_key_sandbox'] = 'SB-Mid-server-YOUR-KEY-HERE';
$config['midtrans_client_key_sandbox'] = 'SB-Mid-client-YOUR-KEY-HERE';

// PRODUCTION - Untuk Live
$config['midtrans_server_key_production'] = 'Mid-server-YOUR-KEY-HERE';
$config['midtrans_client_key_production'] = 'Mid-client-YOUR-KEY-HERE';

// Set FALSE untuk testing, TRUE untuk production
$config['midtrans_is_production'] = FALSE;
```

### 4. Setup Notification URL (Webhook)

Agar status pembayaran otomatis terupdate, setup notification URL di dashboard Midtrans:

1. Login ke dashboard Midtrans
2. Klik **Settings** > **Configuration**
3. Isi **Payment Notification URL**:
   ```
   https://yourdomain.com/gerabah/customer/checkout/notification
   ```
   Ganti `yourdomain.com` dengan domain Anda

4. Isi **Finish Redirect URL**:
   ```
   https://yourdomain.com/gerabah/customer/checkout/finish
   ```

5. Isi **Unfinish Redirect URL**:
   ```
   https://yourdomain.com/gerabah/customer/checkout/unfinish
   ```

6. Isi **Error Redirect URL**:
   ```
   https://yourdomain.com/gerabah/customer/checkout/error
   ```

7. Klik **Save** / **Update**

### 5. Testing Pembayaran

#### Kartu Kredit Test (Sandbox):
- **Card Number**: `4811 1111 1111 1114`
- **CVV**: `123`
- **Exp Date**: `01/25` (atau bulan/tahun di masa depan)
- **3DS Password**: `112233`

#### E-Wallet Test:
- Pilih metode e-wallet (GoPay, ShopeePay, dll)
- Ikuti instruksi simulasi pembayaran

#### Bank Transfer Test:
- Pilih bank yang tersedia
- Gunakan nomor VA yang diberikan
- Sistem akan simulasi pembayaran berhasil

### 6. Go Live (Production)

Setelah testing berhasil:

1. Lengkapi verifikasi akun di dashboard Midtrans
2. Update konfigurasi:
   ```php
   $config['midtrans_is_production'] = TRUE;
   ```
3. Pastikan API Keys production sudah terisi
4. Test sekali lagi dengan transaksi kecil

## 🔄 Flow Pembayaran

1. **Customer Checkout** → Form checkout di website
2. **Buat Pesanan** → Sistem generate order & snap token
3. **Redirect ke Midtrans** → Popup/redirect Midtrans Snap
4. **Pilih Metode** → Customer pilih metode pembayaran
5. **Bayar** → Customer menyelesaikan pembayaran
6. **Notifikasi** → Midtrans kirim webhook ke sistem
7. **Update Status** → Sistem update status otomatis
8. **Selesai** → Customer melihat konfirmasi pembayaran

## 📊 Status Transaksi

| Status Midtrans | Status Sistem | Keterangan |
|----------------|---------------|------------|
| `pending` | Menunggu Pembayaran | Customer belum bayar |
| `settlement` | Dibayar | Pembayaran berhasil |
| `capture` | Dibayar | Kartu kredit approved |
| `deny` | Dibatalkan | Pembayaran ditolak |
| `cancel` | Dibatalkan | Dibatalkan customer/sistem |
| `expire` | Dibatalkan | Waktu pembayaran habis |

## 🛠️ Troubleshooting

### Error: "Snap token not found"
- Pastikan API keys sudah benar
- Cek koneksi internet server
- Lihat log error di `application/logs/`

### Pembayaran sukses tapi status tidak update
- Pastikan notification URL sudah di-setup
- Cek apakah webhook bisa diakses dari luar
- Pastikan tidak ada firewall yang block

### 3D Secure gagal
- Pastikan menggunakan password test: `112233`
- Gunakan kartu test yang benar

## 📞 Support

- **Dokumentasi**: https://docs.midtrans.com/
- **Dashboard**: https://dashboard.midtrans.com/
- **Support**: support@midtrans.com

## ✅ Checklist Setup

- [ ] Daftar akun Midtrans
- [ ] Dapatkan Server Key & Client Key (Sandbox)
- [ ] Update file `config/midtrans.php`
- [ ] Setup Notification URL di dashboard
- [ ] Test pembayaran dengan kartu test
- [ ] Verifikasi status order terupdate
- [ ] (Optional) Setup Production keys untuk go live

---

**Selamat! Sistem pembayaran Midtrans sudah siap digunakan.** 🎉

