# Setup Retur Customer

## Langkah-langkah Setup

### 1. Database
Tabel `retur` dan `retur_item` sudah dibuat melalui file `admin/setup_retur.sql`. Jika belum, jalankan SQL berikut:

```sql
-- Tabel retur
CREATE TABLE IF NOT EXISTS `retur` (
  `id_retur` int(11) NOT NULL AUTO_INCREMENT,
  `id_transaksi` int(11) NOT NULL,
  `id_customer` int(11) NOT NULL,
  `alasan_retur` text NOT NULL,
  `foto_bukti` varchar(255) DEFAULT NULL,
  `status_retur` enum('pending','diterima','ditolak','diproses','selesai') DEFAULT 'pending',
  `catatan_admin` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_retur`),
  KEY `id_transaksi` (`id_transaksi`),
  KEY `id_customer` (`id_customer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabel retur_item
CREATE TABLE IF NOT EXISTS `retur_item` (
  `id_retur_item` int(11) NOT NULL AUTO_INCREMENT,
  `id_retur` int(11) NOT NULL,
  `id_produk` int(11) NOT NULL,
  `qty` int(11) NOT NULL,
  PRIMARY KEY (`id_retur_item`),
  KEY `id_retur` (`id_retur`),
  KEY `id_produk` (`id_produk`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
```

### 2. Folder Upload
Buat folder untuk menyimpan foto bukti retur:

```
customer/
└── uploads/
    └── retur/
```

Pastikan folder memiliki permission yang sesuai (777 untuk development).

### 3. Routes CodeIgniter
Pastikan routes berikut tersedia di `customer/application/config/routes.php`:

```php
$route['retur'] = 'retur/index';
$route['retur/ajukan/(:num)'] = 'retur/ajukan/$1';
$route['retur/proses'] = 'retur/proses';
$route['retur/detail/(:num)'] = 'retur/detail/$1';
```

### 4. File yang Dibuat/Diubah

#### Model
- `customer/application/models/Mretur.php` - Model untuk mengelola data retur

#### Controller
- `customer/application/controllers/Retur.php` - Controller untuk fitur retur customer

#### Views
- `customer/application/views/retur_list.php` - Halaman daftar retur
- `customer/application/views/retur_form.php` - Form pengajuan retur
- `customer/application/views/retur_detail.php` - Detail retur

#### Update Existing Files
- `customer/application/views/header.php` - Menambah menu "Retur" (hanya untuk user yang login)
- `customer/application/views/transaksi_detail.php` - Menambah tombol "Ajukan Retur"

## Fitur Retur Customer

### 1. List Retur (`/retur`)
- Menampilkan semua retur yang pernah diajukan customer
- Menampilkan Order ID, tanggal ajukan, alasan, dan status
- Button untuk melihat detail setiap retur

### 2. Form Pengajuan Retur (`/retur/ajukan/{id_transaksi}`)
- Customer dapat memilih produk yang ingin diretur (opsional)
- Input alasan retur (required)
- Upload foto bukti (opsional)
- Validasi: tidak bisa ajukan retur 2x untuk transaksi yang sama

### 3. Detail Retur (`/retur/detail/{id_retur}`)
- Menampilkan informasi lengkap retur
- Status retur
- Alasan customer
- Catatan admin (jika ada)
- Foto bukti (jika ada)
- List produk yang diretur (jika ada)

### 4. Tombol Ajukan Retur
- Muncul di halaman detail transaksi
- Hanya muncul jika status transaksi "selesai" atau "dikirim"
- Customer dapat langsung ajukan retur dari halaman transaksi

### 5. Menu Retur
- Menu "Retur" di header
- Hanya tampil untuk customer yang sudah login
- Akses cepat ke daftar retur

## Status Retur

| Status | Deskripsi |
|--------|-----------|
| **Pending** | Retur baru diajukan, menunggu review admin |
| **Diterima** | Admin menerima permintaan retur |
| **Ditolak** | Admin menolak permintaan retur |
| **Diproses** | Retur sedang diproses (pengembalian dana/barang) |
| **Selesai** | Retur selesai diproses |

## Validasi

1. **Login Required**: Customer harus login untuk mengakses fitur retur
2. **Ownership Check**: Customer hanya bisa melihat/ajukan retur untuk transaksi mereka sendiri
3. **Duplicate Check**: Tidak bisa ajukan retur 2x untuk transaksi yang sama
4. **Status Check**: Tombol ajukan retur hanya muncul untuk transaksi dengan status selesai/dikirim
5. **File Upload**: Max 2MB, format JPG/PNG/GIF

## Integrasi dengan Admin

- Admin dapat melihat semua retur di menu "Retur" admin panel
- Admin dapat update status retur dan menambahkan catatan
- Notifikasi otomatis ke customer melalui email (jika sudah diimplementasi)

## Testing

1. **Test Ajukan Retur**
   - Login sebagai customer
   - Buka detail transaksi dengan status "selesai"
   - Klik tombol "Ajukan Retur"
   - Isi form dan submit

2. **Test List Retur**
   - Buka `/retur`
   - Cek apakah semua retur customer tampil

3. **Test Detail Retur**
   - Klik button "Detail" di list retur
   - Cek apakah semua informasi tampil dengan benar

4. **Test Validasi**
   - Coba ajukan retur 2x untuk transaksi yang sama (harus error)
   - Coba akses retur orang lain (harus redirect)

## Troubleshooting

### Error: "Transaksi tidak ditemukan"
- Pastikan customer mengakses transaksi milik mereka sendiri
- Cek apakah id_transaksi valid

### Error: "Sudah mengajukan retur"
- Customer sudah pernah ajukan retur untuk transaksi ini
- Cek tabel `retur` untuk memastikan

### Foto tidak terupload
- Cek permission folder `customer/uploads/retur/`
- Pastikan size file tidak lebih dari 2MB
- Format harus JPG/PNG/GIF

### Menu Retur tidak muncul
- Pastikan customer sudah login
- Cek variabel `$logged_in` di view

## Security

1. **Authentication**: Semua route retur memerlukan login
2. **Authorization**: Customer hanya bisa akses retur mereka sendiri
3. **File Upload**: Validasi type dan size file
4. **SQL Injection**: Menggunakan Query Builder CodeIgniter
5. **XSS Prevention**: Menggunakan `htmlspecialchars()` di view

## Future Enhancements

- Email notification saat status retur berubah
- Upload multiple foto bukti
- Retur partial (pilih qty per produk)
- Chat/komunikasi real-time dengan admin
- Timeline status retur
- Export retur ke PDF

