<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Konfigurasi RajaOngkir / Komerce
 * 
 * PENTING UNTUK API KEY:
 * 1. Jika Anda menggunakan RajaOngkir.com (Official):
 *    - Format Key: 32 karakter (contoh: fb27a057f97a9228e93297a5f6396f47)
 *    - Masukkan key di bawah ini.
 * 
 * 2. Jika Anda menggunakan KOMERCE / KOMSHIP (RajaOngkir V2):
 *    - Format Key: Biasanya diawali 'v1...' atau lebih panjang dari 32 karakter.
 *    - Masukkan key tersebut di bawah ini. Sistem akan otomatis mendeteksi dan menggunakan endpoint Komerce.
 */

// API KEY 'Shipping Cost' dari Komerce
$config['rajaongkir_api_key'] = 'v1H0XuWX315aa941296cc75dpKNKTPhp'; 

/**
 * Tipe akun (Hanya berpengaruh jika menggunakan RajaOngkir Official)
 * - 'starter' (gratis)
 * - 'basic'
 * - 'pro'
 */
$config['rajaongkir_account_type'] = 'starter'; 

// Konfigurasi URL (Otomatis ditangani oleh Mongkir.php jika menggunakan Key Komerce)
switch ($config['rajaongkir_account_type']) {
    case 'basic':
        $config['rajaongkir_base_url'] = 'https://api.rajaongkir.com/basic';
        break;
    case 'pro':
        $config['rajaongkir_base_url'] = 'https://api.rajaongkir.com/pro';
        break;
    case 'starter':
    default:
        $config['rajaongkir_base_url'] = 'https://api.rajaongkir.com/starter';
        break;
}
?>
