<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'register';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

// Retur Routes
$route['retur'] = 'retur/index';
$route['retur/ajukan/(:num)'] = 'retur/ajukan/$1';
$route['retur/proses'] = 'retur/proses';
$route['retur/detail/(:num)'] = 'retur/detail/$1';

// Checkout Routes
$route['checkout'] = 'checkout/index';
$route['checkout/proses'] = 'checkout/proses';
$route['checkout/payment'] = 'checkout/payment';
$route['checkout/finish'] = 'checkout/finish';
$route['checkout/unfinish'] = 'checkout/unfinish';
$route['checkout/error'] = 'checkout/error';
$route['checkout/get_kota'] = 'checkout/get_kota';
$route['checkout/hitung_ongkir'] = 'checkout/hitung_ongkir';
$route['checkout/check_rajaongkir'] = 'checkout/check_rajaongkir';
$route['checkout/notification'] = 'checkout/notification';

// Produk Routes
$route['produk/detail/(:any)'] = 'produk/detail/$1';
$route['produk/(:num)'] = 'produk/index/$1';
$route['produk'] = 'produk/index';
