<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Akun extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Mmember');
		$this->load->helper('url');
		$this->load->library('form_validation');
	}

	public function index()
	{
		// Jika sudah login, redirect ke home
		if($this->session->userdata('logged_in')) {
			redirect('home');
		}

		$data['title'] = 'Login - Marketplace';
		
		$this->load->view('header', $data);
		$this->load->view('akun', $data);
		$this->load->view('footer');
	}

	public function login()
	{
		// Jika sudah login, redirect ke home
		if($this->session->userdata('logged_in')) {
			redirect('home');
		}

		// Validasi form
		$this->form_validation->set_rules('email', 'Email', 'required|valid_email|trim');
		$this->form_validation->set_rules('password', 'Password', 'required');

		if($this->form_validation->run() == FALSE) {
			$data['title'] = 'Login - Marketplace';
			$this->load->view('header', $data);
			$this->load->view('akun', $data);
			$this->load->view('footer');
		} else {
			$email = $this->input->post('email');
			$password = $this->input->post('password');

			// Cek login
			$result = $this->Mmember->login($email, $password);

			if($result) {
				// Bersihkan session lama dulu untuk menghindari konflik
				$this->session->unset_userdata('id_customer');
				$this->session->unset_userdata('nama_customer');
				$this->session->unset_userdata('email_customer');
				$this->session->unset_userdata('logged_in');
				
				// Set session baru
				$session_data = array(
					'id_customer' => $result->id_customer,
					'nama_customer' => $result->nama_customer,
					'email_customer' => $result->email_customer,
					'logged_in' => TRUE
				);
				$this->session->set_userdata($session_data);

				// Redirect ke halaman sebelumnya atau home
				$redirect_url = $this->session->userdata('redirect_url');
				if($redirect_url) {
					$this->session->unset_userdata('redirect_url');
					redirect($redirect_url);
				} else {
					redirect('home');
				}
			} else {
				$this->session->set_flashdata('error', 'Email atau password salah!');
				redirect('akun');
			}
		}
	}

	public function logout()
	{
		// Hapus session
		$this->session->unset_userdata('id_customer');
		$this->session->unset_userdata('nama_customer');
		$this->session->unset_userdata('email_customer');
		$this->session->unset_userdata('logged_in');
		$this->session->sess_destroy();

		$this->session->set_flashdata('success', 'Anda berhasil logout!');
		redirect('akun');
	}

	public function profil()
	{
		// Cek apakah user sudah login
		if(!$this->session->userdata('logged_in')) {
			$this->session->set_userdata('redirect_url', 'akun/profil');
			$this->session->set_flashdata('error', 'Silakan login terlebih dahulu!');
			redirect('akun');
		}

		$data['title'] = 'Profil Saya - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		// Ambil data customer
		$id_customer = $this->session->userdata('id_customer');
		$customer_query = $this->Mmember->get_by_id($id_customer);
		$data['customer'] = $customer_query->num_rows() > 0 ? $customer_query->row() : null;

		$this->load->view('header', $data);
		$this->load->view('profil', $data);
		$this->load->view('footer');
	}
}

