<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Fix_Promo_Data extends CI_Controller {

	public function index()
	{
		$this->load->database();
		
		echo "<h1>Fixing Promo Data</h1>";
		
		// 1. Identify expired promos linked in promo_produk
		$now = date('Y-m-d H:i:s');
		$sql_select = "SELECT pp.id_promo_produk, pp.id_produk, p.id_promo, p.waktu_berakhir 
		               FROM promo_produk pp 
		               JOIN promo p ON p.id_promo = pp.id_promo 
		               WHERE p.waktu_berakhir < ?";
		
		$query = $this->db->query($sql_select, array($now));
		$expired_links = $query->result();
		
		echo "Found " . count($expired_links) . " expired promo links.<br>";
		echo "<table border='1'><tr><th>ID Link</th><th>Product</th><th>Promo</th><th>Ends</th></tr>";
		foreach ($expired_links as $row) {
			echo "<tr>";
			echo "<td>{$row->id_promo_produk}</td>";
			echo "<td>{$row->id_produk}</td>";
			echo "<td>{$row->id_promo}</td>";
			echo "<td>{$row->waktu_berakhir}</td>";
			echo "</tr>";
		}
		echo "</table>";
		
		if (count($expired_links) > 0) {
			// 2. Delete them
			$ids_to_delete = array();
			foreach ($expired_links as $row) {
				$ids_to_delete[] = $row->id_promo_produk;
			}
			
			$this->db->where_in('id_promo_produk', $ids_to_delete);
			$this->db->delete('promo_produk');
			
			echo "<br><strong>Deleted " . $this->db->affected_rows() . " rows.</strong>";
		} else {
			echo "<br><strong>No rows to delete.</strong>";
		}
	}
}
