<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Mproduk');
		$this->load->model('Mkategori');
		$this->load->model('Mslider');
		$this->load->helper('url');
	}

	public function index()
	{
		$data['title'] = 'Beranda - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		// Ambil slider
		$data['sliders'] = $this->Mslider->get_active_sliders();
		
		// Ambil produk terbaru
		$produk_query = $this->Mproduk->get_terbaru(8);
		$data['produk_terbaru'] = $produk_query->num_rows() > 0 ? $produk_query->result() : array();
		
		// Ambil kategori
		$kategori_query = $this->Mkategori->get_all();
		$data['kategori'] = $kategori_query->num_rows() > 0 ? $kategori_query->result() : array();
		
		// Load promo helper
		$this->load->helper('promo');
		
		$this->load->view('header', $data);
		$this->load->view('home', $data);
		$this->load->view('footer');
	}
}

