<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kategori extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Mkategori');
		$this->load->model('Mproduk');
		$this->load->helper('url');
	}

	public function index()
	{
		$data['title'] = 'Kategori - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		// Ambil semua kategori
		$kategori_query = $this->Mkategori->get_all();
		$data['kategori'] = $kategori_query->num_rows() > 0 ? $kategori_query->result() : array();
		
		$this->load->view('header', $data);
		$this->load->view('kategori_tampil', $data);
		$this->load->view('footer');
	}

	public function produk($id_kategori = null)
	{
		if($id_kategori == null) {
			$this->session->set_flashdata('error', 'Kategori tidak ditemukan!');
			redirect('kategori');
		}

		$data['title'] = 'Produk Kategori - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		// Ambil detail kategori
		$kategori_query = $this->Mkategori->get_by_id($id_kategori);
		if($kategori_query->num_rows() > 0) {
			$data['kategori'] = $kategori_query->row();
			
			// Ambil produk berdasarkan kategori
			$produk_query = $this->Mproduk->get_by_kategori($id_kategori);
			$data['produk'] = $produk_query->num_rows() > 0 ? $produk_query->result() : array();
		} else {
			$this->session->set_flashdata('error', 'Kategori tidak ditemukan!');
			redirect('kategori');
		}
		
		// Ambil semua kategori untuk navigasi
		$all_kategori_query = $this->Mkategori->get_all();
		$data['all_kategori'] = $all_kategori_query->num_rows() > 0 ? $all_kategori_query->result() : array();
		
		$this->load->view('header', $data);
		$this->load->view('kategori_produk', $data);
		$this->load->view('footer');
	}
}

