<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Keranjang extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Mkeranjang');
		$this->load->model('Mproduk');
		$this->load->helper('url');
		$this->load->helper('promo'); // Load promo helper
	}

	public function index()
	{
		// Cek apakah user sudah login
		if(!$this->session->userdata('logged_in')) {
			$this->session->set_flashdata('error', 'Silakan login terlebih dahulu untuk melihat keranjang!');
			redirect('akun');
		}

		$data['title'] = 'Keranjang Belanja - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		// Ambil data keranjang berdasarkan id_customer
		$id_customer = $this->session->userdata('id_customer');
		$keranjang_query = $this->Mkeranjang->get_by_customer($id_customer);
		$data['keranjang'] = $keranjang_query->num_rows() > 0 ? $keranjang_query->result() : array();
		
		// Hitung total
		$data['total'] = 0;
		foreach($data['keranjang'] as $item) {
			// Ambil harga dari keranjang, jika 0 atau tidak ada, ambil dari produk
			$harga_awal = 0;
			
			// Prioritas: Harga Ukuran > Harga Produk
			if(isset($item->harga_ukuran) && $item->harga_ukuran > 0) {
				$harga_awal = $item->harga_ukuran;
			} else if(isset($item->harga_produk) && $item->harga_produk > 0) {
				$harga_awal = $item->harga_produk;
			} else if(isset($item->harga) && $item->harga > 0) {
				$harga_awal = $item->harga;
			} else if(isset($item->harga_produk_alt) && $item->harga_produk_alt > 0) {
				$harga_awal = $item->harga_produk_alt;
			}
			
			// Hitung diskon promo
			$promo_info = get_harga_diskon($item->id_produk, $harga_awal);
			
			// Update data item untuk view
			$item->harga_asli = $harga_awal;
			$item->harga = $promo_info['harga_diskon']; // Harga yang dipakai untuk perhitungan total
			$item->diskon_persen = $promo_info['persen_diskon'];
			
			// Update harga di keranjang agar konsisten (opsional, tapi bagus untuk data integrity)
			if($item->harga != $harga_awal) {
				// Kita tidak update ke database agar harga asli tetap tersimpan, 
				// tapi kita pakai harga diskon untuk perhitungan total saat ini
			}
			
			$qty = isset($item->qty) ? $item->qty : 1;
			$data['total'] += $item->harga * $qty;
		}
		
		$this->load->view('header', $data);
		$this->load->view('keranjang', $data);
		$this->load->view('footer');
	}

	public function tambah()
	{
		// Cek apakah user sudah login
		if(!$this->session->userdata('logged_in')) {
			// Simpan URL untuk redirect setelah login
			$this->session->set_userdata('redirect_url', 'keranjang');
			$this->session->set_flashdata('error', 'Silakan login terlebih dahulu!');
			redirect('akun');
		}

		$id_produk = $this->input->post('id_produk');
		$id_ukuran = $this->input->post('id_ukuran') ? $this->input->post('id_ukuran') : 0;
		$qty = $this->input->post('qty') ? $this->input->post('qty') : 1;
		$id_customer = $this->session->userdata('id_customer');

		// Cek apakah id_customer valid
		if(empty($id_customer)) {
			$this->session->set_flashdata('error', 'Session tidak valid. Silakan login ulang!');
			redirect('akun');
		}

		if(empty($id_produk)) {
			$this->session->set_flashdata('error', 'Produk tidak valid!');
			redirect('produk');
		}

		// Ambil data produk untuk cek stok
		$produk = $this->Mproduk->get_by_id($id_produk);
		if($produk->num_rows() == 0) {
			$this->session->set_flashdata('error', 'Produk tidak ditemukan!');
			redirect('produk');
		}
		
		$produk_data = $produk->row();
		
		// Cek stok produk
		$stok_tersedia = 0;
		if($id_ukuran > 0) {
			$ukuran_data = $this->db->get_where('produk_ukuran', ['id_ukuran' => $id_ukuran])->row();
			if($ukuran_data) {
				$stok_tersedia = (int)$ukuran_data->stok;
			}
		} else {
			$stok_tersedia = isset($produk_data->stok_produk) ? (int)$produk_data->stok_produk : 0;
		}

		if($stok_tersedia <= 0) {
			$this->session->set_flashdata('error', 'Maaf, produk/ukuran ini sedang kehabisan stok!');
			redirect('produk');
		}

		// Cek apakah produk sudah ada di keranjang
		$cek = $this->Mkeranjang->cek_produk($id_customer, $id_produk, $id_ukuran);
		
		if($cek->num_rows() > 0) {
			// Update qty jika sudah ada
			$item = $cek->row();
			$new_qty = $item->qty + $qty;
			
			// Cek apakah stok cukup untuk qty baru
			if($new_qty > $stok_tersedia) {
				$this->session->set_flashdata('error', 'Stok tidak mencukupi! Stok tersedia: ' . $stok_tersedia);
				redirect('keranjang');
			}
			
			$this->Mkeranjang->update_qty($item->id_keranjang, $new_qty);
			$this->session->set_flashdata('success', 'Produk berhasil ditambahkan ke keranjang!');
		} else {
			// Cek apakah stok cukup
			if($qty > $stok_tersedia) {
				$this->session->set_flashdata('error', 'Stok tidak mencukupi! Stok tersedia: ' . $stok_tersedia);
				redirect('produk');
			}
			
			// Ambil harga dari harga_produk atau harga
			$harga = 0;
			
			// Jika ada ukuran, ambil harga ukuran
			if($id_ukuran > 0) {
				$ukuran_data = $this->db->get_where('produk_ukuran', ['id_ukuran' => $id_ukuran])->row();
				if($ukuran_data) {
					$harga = $ukuran_data->harga;
				}
			}
			
			// Jika harga masih 0 (tidak ada ukuran atau ukuran tidak valid), ambil harga produk
			if($harga == 0) {
				if(isset($produk_data->harga_produk) && $produk_data->harga_produk > 0) {
					$harga = $produk_data->harga_produk;
				} else if(isset($produk_data->harga) && $produk_data->harga > 0) {
					$harga = $produk_data->harga;
				}
			}
			
			$data = array(
				'id_customer' => $id_customer,
				'id_produk' => $id_produk,
				'id_ukuran' => $id_ukuran,
				'qty' => $qty,
				'harga' => $harga
			);
			
			if($this->Mkeranjang->insert($data)) {
				$this->session->set_flashdata('success', 'Produk berhasil ditambahkan ke keranjang!');
			} else {
				$this->session->set_flashdata('error', 'Gagal menambahkan produk ke keranjang!');
			}
		}

		redirect('keranjang');
	}

	public function update()
	{
		if(!$this->session->userdata('logged_in')) {
			redirect('akun');
		}

		$id_keranjang = $this->input->post('id_keranjang');
		$qty = $this->input->post('qty');

		if($qty <= 0) {
			$this->hapus($id_keranjang);
		} else {
			// Ambil data keranjang untuk cek stok produk
			$keranjang = $this->Mkeranjang->get_by_id($id_keranjang);
			if($keranjang->num_rows() > 0) {
				$item = $keranjang->row();
				$produk = $this->Mproduk->get_by_id($item->id_produk);
				if($produk->num_rows() > 0) {
					$produk_data = $produk->row();
					
					// Cek stok berdasarkan ukuran jika ada
					$stok_tersedia = 0;
					if($item->id_ukuran > 0) {
						$ukuran_data = $this->db->get_where('produk_ukuran', ['id_ukuran' => $item->id_ukuran])->row();
						if($ukuran_data) {
							$stok_tersedia = (int)$ukuran_data->stok;
						}
					} else {
						$stok_tersedia = isset($produk_data->stok_produk) ? (int)$produk_data->stok_produk : 0;
					}
					
					if($stok_tersedia <= 0) {
						$this->session->set_flashdata('error', 'Produk sedang kehabisan stok!');
					} else if($qty > $stok_tersedia) {
						$this->session->set_flashdata('error', 'Stok tidak mencukupi! Stok tersedia: ' . $stok_tersedia);
					} else {
						$this->Mkeranjang->update_qty($id_keranjang, $qty);
						$this->session->set_flashdata('success', 'Keranjang berhasil diperbarui!');
					}
				} else {
					$this->session->set_flashdata('error', 'Produk tidak ditemukan!');
				}
			} else {
				$this->Mkeranjang->update_qty($id_keranjang, $qty);
				$this->session->set_flashdata('success', 'Keranjang berhasil diperbarui!');
			}
		}

		redirect('keranjang');
	}

	public function hapus($id_keranjang = null)
	{
		if(!$this->session->userdata('logged_in')) {
			redirect('akun');
		}

		if($id_keranjang == null) {
			$id_keranjang = $this->input->post('id_keranjang');
		}

		if($this->Mkeranjang->delete($id_keranjang)) {
			$this->session->set_flashdata('success', 'Produk berhasil dihapus dari keranjang!');
		} else {
			$this->session->set_flashdata('error', 'Gagal menghapus produk dari keranjang!');
		}

		redirect('keranjang');
	}

	public function buy_now()
	{
		// Cek apakah user sudah login
		if(!$this->session->userdata('logged_in')) {
			// Simpan URL untuk redirect setelah login
			$this->session->set_userdata('redirect_url', 'keranjang/buy_now?' . http_build_query($_GET));
			$this->session->set_flashdata('error', 'Silakan login terlebih dahulu!');
			redirect('akun');
		}

		$id_produk = $this->input->get('id_produk');
		$id_ukuran = $this->input->get('id_ukuran') ? $this->input->get('id_ukuran') : 0;
		$qty = $this->input->get('qty') ? (int)$this->input->get('qty') : 1;
		$id_customer = $this->session->userdata('id_customer');

		// Cek apakah id_customer valid
		if(empty($id_customer)) {
			$this->session->set_flashdata('error', 'Session tidak valid. Silakan login ulang!');
			redirect('akun');
		}

		if(empty($id_produk)) {
			$this->session->set_flashdata('error', 'Produk tidak valid!');
			redirect('produk');
		}

		// Ambil data produk untuk cek stok
		$produk = $this->Mproduk->get_by_id($id_produk);
		if($produk->num_rows() == 0) {
			$this->session->set_flashdata('error', 'Produk tidak ditemukan!');
			redirect('produk');
		}
		
		$produk_data = $produk->row();
		
		// Cek stok produk
		$stok_tersedia = 0;
		if($id_ukuran > 0) {
			$ukuran_data = $this->db->get_where('produk_ukuran', ['id_ukuran' => $id_ukuran])->row();
			if($ukuran_data) {
				$stok_tersedia = (int)$ukuran_data->stok;
			}
		} else {
			$stok_tersedia = isset($produk_data->stok_produk) ? (int)$produk_data->stok_produk : 0;
		}

		if($stok_tersedia <= 0) {
			$this->session->set_flashdata('error', 'Maaf, produk/ukuran ini sedang kehabisan stok!');
			redirect('produk/detail/' . $id_produk);
		}

		// Cek apakah stok cukup
		if($qty > $stok_tersedia) {
			$this->session->set_flashdata('error', 'Stok tidak mencukupi! Stok tersedia: ' . $stok_tersedia);
			redirect('produk/detail/' . $id_produk);
		}

		// Ambil harga
		$harga = 0;
		
		// Jika ada ukuran, ambil harga ukuran
		if($id_ukuran > 0) {
			$ukuran_data = $this->db->get_where('produk_ukuran', ['id_ukuran' => $id_ukuran])->row();
			if($ukuran_data) {
				$harga = $ukuran_data->harga;
			}
		}
		
		// Jika harga masih 0 (tidak ada ukuran atau ukuran tidak valid), ambil harga produk
		if($harga == 0) {
			if(isset($produk_data->harga_produk) && $produk_data->harga_produk > 0) {
				$harga = $produk_data->harga_produk;
			} else if(isset($produk_data->harga) && $produk_data->harga > 0) {
				$harga = $produk_data->harga;
			}
		}

		// Cek apakah produk sudah ada di keranjang
		$cek = $this->Mkeranjang->cek_produk($id_customer, $id_produk, $id_ukuran);
		$id_keranjang_baru = null;
		
		if($cek->num_rows() > 0) {
			// Update qty jika sudah ada (untuk buy now, kita set qty sesuai yang diminta)
			$item = $cek->row();
			$this->Mkeranjang->update_qty($item->id_keranjang, $qty);
			$id_keranjang_baru = $item->id_keranjang;
		} else {
			// Tambahkan ke keranjang
			$data = array(
				'id_customer' => $id_customer,
				'id_produk' => $id_produk,
				'id_ukuran' => $id_ukuran,
				'qty' => $qty,
				'harga' => $harga
			);
			
			if($this->Mkeranjang->insert($data)) {
				$id_keranjang_baru = $this->db->insert_id();
			} else {
				$this->session->set_flashdata('error', 'Gagal menambahkan produk ke keranjang!');
				redirect('produk/detail/' . $id_produk);
			}
		}

		// Redirect ke checkout dengan item yang baru ditambahkan
		if($id_keranjang_baru) {
			// Simpan ID keranjang yang dipilih di session untuk checkout
			$this->session->set_userdata('buy_now_item', $id_keranjang_baru);
			redirect('checkout?buy_now=1');
		} else {
			$this->session->set_flashdata('error', 'Gagal memproses pembelian!');
			redirect('produk/detail/' . $id_produk);
		}
	}
}

