<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Produk extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Mproduk');
		$this->load->model('Mkategori');
		$this->load->model('Mslider');
		$this->load->helper('url');
	}

	public function index($page = 1)
	{
		$this->load->library('pagination');
		
		$data['title'] = 'Produk - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		// Ambil slider
		$data['sliders'] = $this->Mslider->get_active_sliders();
		
		// Ambil parameter search dan filter
		$keyword = $this->input->get('q');
		$id_kategori = $this->input->get('kategori');
		
		// Config pagination
		$query_string = '';
		if($keyword) $query_string .= 'q='.urlencode($keyword);
		if($id_kategori) $query_string .= ($query_string ? '&' : '') . 'kategori='.$id_kategori;
		
		$config['base_url'] = base_url('produk/') . ($query_string ? '?' . $query_string . '&' : '');
		$config['total_rows'] = $this->Mproduk->count_search($keyword, $id_kategori);
		$config['per_page'] = 12;
		$config['uri_segment'] = 2;
		$config['use_page_numbers'] = TRUE;
		$config['reuse_query_string'] = FALSE;
		$config['page_query_string'] = FALSE;
		$config['suffix'] = $query_string ? '?' . $query_string : '';
		
		// Styling pagination
		$config['full_tag_open'] = '<div class="pagination-wrapper"><ul class="pagination">';
		$config['full_tag_close'] = '</ul></div>';
		$config['first_link'] = '&laquo; Pertama';
		$config['first_tag_open'] = '<li>';
		$config['first_tag_close'] = '</li>';
		$config['last_link'] = 'Terakhir &raquo;';
		$config['last_tag_open'] = '<li>';
		$config['last_tag_close'] = '</li>';
		$config['next_link'] = '&raquo;';
		$config['next_tag_open'] = '<li>';
		$config['next_tag_close'] = '</li>';
		$config['prev_link'] = '&laquo;';
		$config['prev_tag_open'] = '<li>';
		$config['prev_tag_close'] = '</li>';
		$config['cur_tag_open'] = '<li class="active"><a href="#">';
		$config['cur_tag_close'] = '</a></li>';
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		
		// Hitung offset
		// $page diambil dari parameter fungsi
		$offset = ($page - 1) * $config['per_page'];
		
		// Ambil kategori untuk filter
		$kategori_query = $this->Mkategori->get_all();
		$data['kategori'] = $kategori_query->num_rows() > 0 ? $kategori_query->result() : array();
		
		// Ambil produk dengan search dan pagination
		$produk_query = $this->Mproduk->search($keyword, $id_kategori, $config['per_page'], $offset);
		$data['produk'] = $produk_query->num_rows() > 0 ? $produk_query->result() : array();
		
		// Simpan filter untuk view
		$data['keyword'] = $keyword;
		$data['selected_kategori'] = $id_kategori;
		
		// Load promo helper
		$this->load->helper('promo');
		
		$this->load->view('header', $data);
		$this->load->view('produk_tampil', $data);
		$this->load->view('footer');
	}

	public function detail($id_produk = null)
	{
		if($id_produk == null) {
			$this->session->set_flashdata('error', 'Produk tidak ditemukan!');
			redirect('produk');
		}

		$data['title'] = 'Detail Produk - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		// Ambil detail produk
		$produk_query = $this->Mproduk->get_by_id($id_produk);
		if($produk_query->num_rows() > 0) {
			$data['produk'] = $produk_query->row();
			$data['ukuran'] = $this->Mproduk->get_ukuran($id_produk);
			
			// Ambil kategori produk
			if(isset($data['produk']->id_kategori)) {
				$kategori_query = $this->Mkategori->get_by_id($data['produk']->id_kategori);
				$data['kategori'] = $kategori_query->num_rows() > 0 ? $kategori_query->row() : null;
			}
		} else {
			$this->session->set_flashdata('error', 'Produk tidak ditemukan!');
			redirect('produk');
		}
		
		// Load promo helper
		$this->load->helper('promo');
		
		$this->load->view('header', $data);
		$this->load->view('produk_detail', $data);
		$this->load->view('footer');
	}
}

