<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Register extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Mmember');
		$this->load->library(array('session', 'form_validation'));
		$this->load->helper(array('form', 'url'));
	}

	public function index()
	{
		// Jika sudah login, redirect ke home
		if($this->session->userdata('id_customer'))
		{
			redirect('home');
		}
		
		$this->load->view('register');
	}

	public function proses()
	{
		// Validasi input
		$this->form_validation->set_rules('nama_customer', 'Nama Lengkap', 'required|trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('email_customer', 'Email', 'required|trim|valid_email|is_unique[customer.email_customer]');
		$this->form_validation->set_rules('password_customer', 'Password', 'required|min_length[6]');
		$this->form_validation->set_rules('password_confirm', 'Konfirmasi Password', 'required|matches[password_customer]');
		$this->form_validation->set_rules('telp_customer', 'Telepon', 'trim|numeric|min_length[10]|max_length[20]');
		$this->form_validation->set_rules('alamat_customer', 'Alamat', 'trim');

		// Set pesan error
		$this->form_validation->set_message('required', '{field} harus diisi!');
		$this->form_validation->set_message('min_length', '{field} minimal {param} karakter!');
		$this->form_validation->set_message('max_length', '{field} maksimal {param} karakter!');
		$this->form_validation->set_message('valid_email', 'Format {field} tidak valid!');
		$this->form_validation->set_message('is_unique', '{field} sudah terdaftar!');
		$this->form_validation->set_message('matches', '{field} tidak cocok dengan password!');
		$this->form_validation->set_message('numeric', '{field} harus berupa angka!');

		if($this->form_validation->run() == FALSE)
		{
			// Jika validasi gagal, kembali ke halaman register
			$this->load->view('register');
		}
		else
		{
			// Cek email sudah terdaftar atau belum
			if($this->Mmember->cek_email($this->input->post('email_customer')) > 0)
			{
				$this->session->set_flashdata('error', 'Email sudah terdaftar!');
				redirect('register');
			}

			// Siapkan data untuk disimpan
			$data = array(
				'nama_customer' => $this->input->post('nama_customer'),
				'email_customer' => $this->input->post('email_customer'),
				'password_customer' => $this->input->post('password_customer'),
				'telp_customer' => $this->input->post('telp_customer') ? $this->input->post('telp_customer') : NULL,
				'alamat_customer' => $this->input->post('alamat_customer') ? $this->input->post('alamat_customer') : NULL
			);

			// Simpan data ke database
			if($this->Mmember->register($data))
			{
				// Ambil data customer yang baru saja didaftarkan
				$customer = $this->Mmember->get_by_email($data['email_customer'])->row();
				
				// Set session
				$session_data = array(
					'id_customer' => $customer->id_customer,
					'nama_customer' => $customer->nama_customer,
					'email_customer' => $customer->email_customer,
					'logged_in' => TRUE
				);
				
				$this->session->set_userdata($session_data);
				
				$this->session->set_flashdata('success', 'Registrasi berhasil! Selamat datang di marketplace kami.');
				redirect('home');
			}
			else
			{
				$this->session->set_flashdata('error', 'Registrasi gagal! Silakan coba lagi.');
				redirect('register');
			}
		}
	}
}

