<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Retur extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		
		// Cek apakah sudah login
		if(!$this->session->userdata('logged_in'))
		{
			$this->session->set_flashdata('error', 'Silakan login terlebih dahulu!');
			redirect('akun');
		}
		
		$this->load->model('Mretur');
		$this->load->model('Mtransaksi');
		$this->load->library('upload');
	}

	/**
	 * Index - List retur customer
	 */
	public function index()
	{
		$data['title'] = 'Pengembalian Barang Saya - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		$id_customer = $this->session->userdata('id_customer');
		
		// Ambil semua retur customer
		$data['retur'] = $this->Mretur->get_by_customer($id_customer)->result();
		
		$this->load->view('header', $data);
		$this->load->view('retur_list', $data);
		$this->load->view('footer');
	}

	/**
	 * Form pengajuan retur
	 */
	public function ajukan($id_transaksi)
	{
		$data['title'] = 'Ajukan Pengembalian Barang - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		$id_customer = $this->session->userdata('id_customer');
		
		// Cek apakah transaksi milik customer ini
		$transaksi = $this->Mtransaksi->get_by_id($id_transaksi)->row();
		
		if(!$transaksi || $transaksi->id_customer != $id_customer)
		{
			$this->session->set_flashdata('error', 'Transaksi tidak ditemukan!');
			redirect('transaksi');
		}
		
		// Cek apakah sudah pernah ajukan retur untuk transaksi ini
		if($this->Mretur->check_retur_exists($id_transaksi))
		{
			$this->session->set_flashdata('error', 'Anda sudah mengajukan pengembalian barang untuk transaksi ini!');
			redirect('transaksi/detail/' . $id_transaksi);
		}
		
		$data['transaksi'] = $transaksi;
		
		// Ambil detail transaksi (items)
		$detail_query = $this->Mtransaksi->get_detail_by_transaksi($id_transaksi);
		
		// Handle return value - bisa berupa CI query result atau stdClass object
		if($detail_query) {
			// Cek apakah ini CI query result object (punya method result())
			if(method_exists($detail_query, 'result') && method_exists($detail_query, 'num_rows')) {
				// Ini adalah CI_DB_result object
				$data['transaksi_detail'] = $detail_query->num_rows() > 0 ? $detail_query->result() : array();
			}
			// Atau stdClass object dengan property result (dari JSON fallback)
			else if(isset($detail_query->num_rows) && isset($detail_query->result)) {
				// Ini adalah stdClass object dari JSON fallback
				$data['transaksi_detail'] = $detail_query->num_rows > 0 ? $detail_query->result : array();
			}
			// Atau langsung array
			else if(is_array($detail_query)) {
				$data['transaksi_detail'] = $detail_query;
			}
			else {
				$data['transaksi_detail'] = array();
			}
		} else {
			$data['transaksi_detail'] = array();
		}
		
		$this->load->view('header', $data);
		$this->load->view('retur_form', $data);
		$this->load->view('footer');
	}

	/**
	 * Proses pengajuan retur
	 */
	public function proses()
	{
		$id_customer = $this->session->userdata('id_customer');
		$id_transaksi = $this->input->post('id_transaksi');
		$alasan_retur = $this->input->post('alasan_retur');
		$jenis_retur = $this->input->post('jenis_retur');
		$bank_customer = $this->input->post('bank_customer');
		$rekening_customer = $this->input->post('rekening_customer');
		$an_customer = $this->input->post('an_customer');
		$nominal_refund = $this->input->post('nominal_refund');
		$produk_retur_id = $this->input->post('produk_retur_id'); // Array ID produk yang diretur
		$produk_retur_qty = $this->input->post('produk_retur_qty'); // Array Qty produk yang diretur
		
		// Validasi
		if(empty($id_transaksi) || empty($alasan_retur) || empty($jenis_retur))
		{
			$this->session->set_flashdata('error', 'Semua field wajib harus diisi!');
			redirect('retur/ajukan/' . $id_transaksi);
		}
		
		if($jenis_retur == 'refund_dana' && (empty($bank_customer) || empty($rekening_customer) || empty($an_customer))) {
			$this->session->set_flashdata('error', 'Data rekening wajib diisi untuk pengembalian dana!');
			redirect('retur/ajukan/' . $id_transaksi);
		}
		
		// Cek apakah sudah pernah ajukan retur
		if($this->Mretur->check_retur_exists($id_transaksi))
		{
			$this->session->set_flashdata('error', 'Anda sudah mengajukan retur untuk transaksi ini!');
			redirect('transaksi/detail/' . $id_transaksi);
		}
		
		// Upload foto bukti jika ada
		$foto_bukti = null;
		if(!empty($_FILES['foto_bukti']['name']))
		{
			$config['upload_path'] = './uploads/retur/';
			$config['allowed_types'] = 'jpg|jpeg|png|gif';
			$config['max_size'] = 2048; // 2MB
			$config['encrypt_name'] = TRUE;
			
			// Buat folder jika belum ada
			if(!is_dir('./uploads/retur/'))
			{
				mkdir('./uploads/retur/', 0777, TRUE);
			}
			
			$this->upload->initialize($config);
			
			if($this->upload->do_upload('foto_bukti'))
			{
				$upload_data = $this->upload->data();
				$foto_bukti = $upload_data['file_name'];
			}
		}
		
		// Insert retur
		$data_retur = array(
			'id_transaksi' => $id_transaksi,
			'id_customer' => $id_customer,
			'alasan_retur' => $alasan_retur,
			'foto_bukti' => $foto_bukti,
			'status_retur' => 'pending',
			'jenis_retur' => $jenis_retur
		);
		
		if($jenis_retur == 'refund_dana') {
			$data_retur['bank_customer'] = $bank_customer;
			$data_retur['rekening_customer'] = $rekening_customer;
			$data_retur['an_customer'] = $an_customer;
			$data_retur['nominal_refund'] = !empty($nominal_refund) ? $nominal_refund : 0;
		}
		
		$this->db->trans_start();
		
		$this->Mretur->insert($data_retur);
		$id_retur = $this->db->insert_id();
		
		// Insert retur items jika ada produk yang dipilih
		if(!empty($produk_retur_id) && is_array($produk_retur_id))
		{
			foreach($produk_retur_id as $id_produk)
			{
				$qty = isset($produk_retur_qty[$id_produk]) ? (int)$produk_retur_qty[$id_produk] : 1;
				
				$data_item = array(
					'id_retur' => $id_retur,
					'id_produk' => $id_produk,
					'qty' => $qty > 0 ? $qty : 1
				);
				$this->Mretur->insert_item($data_item);
			}
		}
		// Jika kosong, cek apakah user ingin retur semua (sesuai instruksi di form)
		// Namun logic sebelumnya tidak handle ini, jadi kita biarkan (opsional: implementasi auto-insert all items)
		// Untuk keamanan, kita asumsikan user harus pilih produk.
		
		$this->db->trans_complete();
		
		if($this->db->trans_status() === FALSE)
		{
			$this->session->set_flashdata('error', 'Gagal mengajukan pengembalian barang! Silakan coba lagi.');
			redirect('retur/ajukan/' . $id_transaksi);
		}
		else
		{
			// Insert Notifikasi untuk Admin
			$notif_nama_customer = $this->session->userdata('nama_customer');
			
			// Ambil order_id untuk pesan notifikasi yang lebih jelas
			$transaksi_data = $this->db->get_where('transaksi', array('id_transaksi' => $id_transaksi))->row();
			$order_id_text = $transaksi_data ? (isset($transaksi_data->order_id) ? $transaksi_data->order_id : $transaksi_data->id_transaksi) : $id_transaksi;

			$this->db->insert('notifikasi', array(
				'judul' => 'Pengajuan Retur Baru',
				'pesan' => 'Customer ' . $notif_nama_customer . ' mengajukan retur untuk pesanan #' . $order_id_text,
				'link' => 'retur/detail/' . $id_retur,
				'jenis' => 'retur',
				'is_read' => 0,
				'created_at' => date('Y-m-d H:i:s')
			));

			$this->session->set_flashdata('success', 'Pengembalian barang berhasil diajukan! Kami akan segera memproses permintaan Anda.');
			redirect('retur');
		}
	}

	/**
	 * Detail retur
	 */
	public function detail($id_retur)
	{
		$data['title'] = 'Detail Pengembalian Barang - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		$id_customer = $this->session->userdata('id_customer');
		
		// Ambil data retur (pastikan milik customer ini)
		$data['retur'] = $this->Mretur->get_by_id($id_retur, $id_customer)->row();
		
		if(!$data['retur'])
		{
			$this->session->set_flashdata('error', 'Data pengembalian barang tidak ditemukan!');
			redirect('retur');
		}
		
		// Ambil items retur
		$data['retur_items'] = $this->Mretur->get_retur_items($id_retur)->result();
		
		$this->load->view('header', $data);
		$this->load->view('retur_detail', $data);
		$this->load->view('footer');
	}
}

