<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Setup_Transaction_Size extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->dbforge();
    }

    public function index()
    {
        echo "<h1>Setup Transaction Size</h1>";

        // 1. Add columns to transaksi_detail if they don't exist
        $table = 'transaksi_detail';
        if ($this->db->table_exists($table)) {
            $fields = array();
            
            if (!$this->db->field_exists('id_ukuran', $table)) {
                $fields['id_ukuran'] = array(
                    'type' => 'INT',
                    'constraint' => 11,
                    'null' => TRUE,
                    'default' => 0
                );
            }

            if (!$this->db->field_exists('ukuran', $table)) {
                $fields['ukuran'] = array(
                    'type' => 'VARCHAR',
                    'constraint' => 50,
                    'null' => TRUE,
                    'default' => ''
                );
            }

            if (!empty($fields)) {
                $this->dbforge->add_column($table, $fields);
                echo "Added columns to $table: " . implode(', ', array_keys($fields)) . "<br>";
            } else {
                echo "Columns already exist in $table.<br>";
            }
        } else {
            echo "Table $table does not exist.<br>";
        }

        echo "Setup completed.";
    }
}
