<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transaksi extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('Mtransaksi');
		$this->load->library('Midtrans');
		$this->load->helper('url');
	}

	public function index()
	{
		// Cek apakah user sudah login
		if(!$this->session->userdata('logged_in')) {
			$this->session->set_flashdata('error', 'Silakan login terlebih dahulu!');
			redirect('akun');
		}

		$data['title'] = 'Riwayat Transaksi - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		// Ambil data transaksi berdasarkan id_customer dari session
		$id_customer = $this->session->userdata('id_customer');
		
		// Validasi id_customer
		if(empty($id_customer)) {
			$this->session->set_flashdata('error', 'Session tidak valid. Silakan login kembali!');
			$this->session->sess_destroy();
			redirect('akun');
		}
		
		$transaksi_query = $this->Mtransaksi->get_by_customer($id_customer);
		$data['transaksi'] = $transaksi_query->num_rows() > 0 ? $transaksi_query->result() : array();
		
		$this->load->view('header', $data);
		$this->load->view('transaksi_tampil', $data);
		$this->load->view('footer');
	}

	public function detail($id_transaksi)
	{
		// Cek apakah user sudah login
		if(!$this->session->userdata('logged_in')) {
			$this->session->set_flashdata('error', 'Silakan login terlebih dahulu!');
			redirect('akun');
		}

		$data['title'] = 'Detail Transaksi - Marketplace';
		$data['nama_customer'] = $this->session->userdata('nama_customer');
		$data['logged_in'] = $this->session->userdata('logged_in');
		
		// Ambil data transaksi
		$transaksi_query = $this->Mtransaksi->get_by_id($id_transaksi);
		$data['transaksi'] = $transaksi_query->num_rows() > 0 ? $transaksi_query->row() : null;
		
		if(!$data['transaksi']) {
			$this->session->set_flashdata('error', 'Data transaksi tidak ditemukan!');
			redirect('transaksi');
		}
		
		// Cek apakah transaksi milik customer yang login
		$id_customer = $this->session->userdata('id_customer');
		if(isset($data['transaksi']->id_customer) && $data['transaksi']->id_customer != $id_customer) {
			$this->session->set_flashdata('error', 'Anda tidak memiliki akses ke transaksi ini!');
			redirect('transaksi');
		}
		
		// Ambil detail transaksi (items)
		$detail_query = $this->Mtransaksi->get_detail_by_transaksi($id_transaksi);
		
		// Cek retur info
		$this->load->model('Mretur');
		$retur_info = $this->db->get_where('retur', ['id_transaksi' => $id_transaksi])->row();
		$data['retur_info'] = $retur_info;
		$data['retur_items'] = array();
		
		if($retur_info) {
			$data['retur_items'] = $this->Mretur->get_retur_items($retur_info->id_retur)->result();
		}

		// Handle return value - bisa berupa CI query result atau stdClass object
		if($detail_query) {
			// Cek apakah ini CI query result object (punya method result())
			if(method_exists($detail_query, 'result') && method_exists($detail_query, 'num_rows')) {
				// Ini adalah CI_DB_result object
				$data['transaksi_detail'] = $detail_query->num_rows() > 0 ? $detail_query->result() : array();
			}
			// Atau stdClass object dengan property result (dari JSON fallback)
			else if(isset($detail_query->num_rows) && isset($detail_query->result)) {
				// Ini adalah stdClass object dari JSON fallback
				log_message('debug', 'Transaksi detail found: ' . $detail_query->num_rows . ' items for transaksi ID: ' . $id_transaksi);
				$data['transaksi_detail'] = $detail_query->num_rows > 0 ? $detail_query->result : array();
			}
			// Atau langsung array
			else if(is_array($detail_query)) {
				$data['transaksi_detail'] = $detail_query;
			}
			else {
				log_message('debug', 'Transaksi detail query returned unexpected format for transaksi ID: ' . $id_transaksi);
				$data['transaksi_detail'] = array();
			}
		} else {
			log_message('debug', 'Transaksi detail query failed or returned null for transaksi ID: ' . $id_transaksi);
			$data['transaksi_detail'] = array();
		}
		
		// Pass Midtrans client key
		$data['midtrans_client_key'] = $this->midtrans->get_client_key();
		$data['midtrans_is_production'] = $this->midtrans->is_production();
		
		$this->load->view('header', $data);
		$this->load->view('transaksi_detail', $data);
		$this->load->view('footer');
	}
	
	// Duplicate batalkan function removed

	public function refresh_status($id_transaksi)
	{
		// Cek apakah user sudah login
		if(!$this->session->userdata('logged_in')) {
			$this->session->set_flashdata('error', 'Silakan login terlebih dahulu!');
			redirect('akun');
		}
		
		// Ambil data transaksi
		$transaksi_query = $this->Mtransaksi->get_by_id($id_transaksi);
		$transaksi = $transaksi_query->num_rows() > 0 ? $transaksi_query->row() : null;
		
		if(!$transaksi) {
			$this->session->set_flashdata('error', 'Data transaksi tidak ditemukan!');
			redirect('transaksi');
		}
		
		// Cek apakah transaksi milik customer yang login
		$id_customer = $this->session->userdata('id_customer');
		if(isset($transaksi->id_customer) && $transaksi->id_customer != $id_customer) {
			$this->session->set_flashdata('error', 'Anda tidak memiliki akses ke transaksi ini!');
			redirect('transaksi');
		}
		
		// Cek apakah transaksi menggunakan Midtrans
		if(isset($transaksi->metode_pembayaran) && strtolower($transaksi->metode_pembayaran) == 'midtrans' && isset($transaksi->kode_transaksi)) {
			$order_id = $transaksi->kode_transaksi;
			
			try {
				// Cek status dari Midtrans API
				$midtrans_status = $this->midtrans->get_status($order_id);
				
				if($midtrans_status && isset($midtrans_status['transaction_status'])) {
					$transaction_status = $midtrans_status['transaction_status'];
					$fraud_status = isset($midtrans_status['fraud_status']) ? $midtrans_status['fraud_status'] : '';
					
					// Update status berdasarkan status dari Midtrans
					$status = 'pending';
					if($transaction_status == 'capture') {
						if ($fraud_status == 'challenge') {
							$status = 'pending';
						} else {
							$status = 'dibayar';
						}
					} else if ($transaction_status == 'settlement') {
						$status = 'dibayar';
					} else if ($transaction_status == 'pending') {
						$status = 'pending';
					} else if ($transaction_status == 'deny') {
						$status = 'dibatalkan';
					} else if ($transaction_status == 'expire') {
						$status = 'dibatalkan';
					} else if ($transaction_status == 'cancel') {
						$status = 'dibatalkan';
					}
					
					// Update status transaksi
					$this->db->where('id_transaksi', $transaksi->id_transaksi);
					$update_result = $this->db->update('transaksi', array('status_transaksi' => $status));
					
					if($update_result) {
						$this->session->set_flashdata('success', 'Status transaksi berhasil diperbarui!');
						log_message('info', 'Status refreshed: Order ID ' . $order_id . ' - Status: ' . $transaction_status . ' - Updated to: ' . $status);
					} else {
						$this->session->set_flashdata('error', 'Gagal memperbarui status transaksi!');
					}
				} else {
					$this->session->set_flashdata('warning', 'Tidak dapat mengambil status dari Midtrans. Transaksi mungkin belum diproses.');
				}
			} catch (Exception $e) {
				log_message('error', 'Failed to refresh status from Midtrans: ' . $e->getMessage());
				$this->session->set_flashdata('error', 'Gagal mengambil status dari Midtrans: ' . $e->getMessage());
			}
		} else {
			$this->session->set_flashdata('warning', 'Transaksi ini tidak menggunakan Midtrans atau tidak memiliki kode transaksi.');
		}
		
		redirect('transaksi/detail/'.$id_transaksi);
	}

	public function get_payment_token($id_transaksi)
	{
		// Mulai buffering output untuk menangkap error/warning yang mungkin muncul
		ob_start();
		
		// Matikan display error agar tidak merusak format JSON
		// Error tetap akan dicatat di log file jika log_threshold diatur
		error_reporting(0);
		ini_set('display_errors', 0);

		try {
			// Cek apakah user sudah login
			if(!$this->session->userdata('logged_in')) {
				throw new Exception('Silakan login terlebih dahulu!');
			}
			
			// Ambil data transaksi
			$transaksi_query = $this->Mtransaksi->get_by_id($id_transaksi);
			$transaksi = $transaksi_query->num_rows() > 0 ? $transaksi_query->row() : null;
			
			if(!$transaksi) {
				throw new Exception('Transaksi tidak ditemukan');
			}
			
			// Cek akses
			$id_customer = $this->session->userdata('id_customer');
			if($transaksi->id_customer != $id_customer) {
				throw new Exception('Akses ditolak');
			}

			// Cek status
			$status = isset($transaksi->status_transaksi) ? $transaksi->status_transaksi : $transaksi->status;
			if($status != 'pending' && $status != 'menunggu_pembayaran') {
				throw new Exception('Transaksi bukan dalam status pending (Status: ' . $status . ')');
			}

			// Siapkan parameter Midtrans
			$order_id = $transaksi->kode_transaksi;
			
			// Ambil detail customer
			$this->load->model('Mmember');
			$customer_query = $this->Mmember->get_by_id($id_customer);
			$customer = $customer_query->num_rows() > 0 ? $customer_query->row() : null;
			
			// Siapkan item details (sederhana saja untuk regenerasi token)
			$item_details = array();
			$item_details[] = array(
				'id' => 'TRX-' . $id_transaksi,
				'price' => (int)$transaksi->total_harga,
				'quantity' => 1,
				'name' => 'Pembayaran Transaksi #' . $transaksi->kode_transaksi
			);
			
			$midtrans_params = array(
				'transaction_details' => array(
					'order_id' => $order_id,
					'gross_amount' => (int)$transaksi->total_harga
				),
				'item_details' => $item_details,
				'customer_details' => array(
					'first_name' => isset($customer->nama_customer) ? $customer->nama_customer : 'Customer',
					'email' => isset($customer->email_customer) ? $customer->email_customer : 'customer@example.com',
					'phone' => isset($customer->telepon_customer) ? $customer->telepon_customer : '',
				)
			);
			
			// Log request
			log_message('debug', 'Get Payment Token Request: ' . print_r($midtrans_params, true));

			// Get Snap Token
			$snap_token = $this->midtrans->get_snap_token($midtrans_params);
			
			if($snap_token) {
				$response = ['status' => 'success', 'token' => $snap_token];
			} else {
				log_message('error', 'Failed to get snap token for Order ID: ' . $order_id);
				throw new Exception('Gagal generate token. Silakan hubungi admin.');
			}
			
		} catch (Exception $e) {
			log_message('error', 'Exception in get_payment_token: ' . $e->getMessage());
			
			// Handle error "Order ID used"
			// Error message biasanya format: "Gagal membuat transaksi Midtrans. HTTP 400: ... transaction_details.order_id sudah digunakan ..."
			$error_msg = $e->getMessage();
			if ((strpos($error_msg, 'Order ID') !== false || strpos($error_msg, 'order_id') !== false) && 
			    (strpos($error_msg, 'used') !== false || strpos($error_msg, 'sudah digunakan') !== false)) {
				
				log_message('info', 'Order ID used detected, attempting to cancel previous transaction for Order ID: ' . $order_id);
				
				try {
					// Coba cancel transaksi sebelumnya di Midtrans
					$cancel_result = $this->midtrans->cancel($order_id);
					
					// Cek hasil cancel
					// 200: Success, 409: Already cancelled/expired
					$status_code = isset($cancel_result['status_code']) ? $cancel_result['status_code'] : '';
					
					if ($status_code == '200' || $status_code == '409') {
						log_message('info', 'Previous transaction cancelled (Code: ' . $status_code . '). Retrying get_snap_token...');
						
						// Retry get_snap_token
						$snap_token = $this->midtrans->get_snap_token($midtrans_params);
						
						if($snap_token) {
							$response = ['status' => 'success', 'token' => $snap_token];
							// Langsung ke output
							goto send_response;
						}
					} else {
						// Cancel gagal, mungkin karena sudah settlement (dibayar)
						log_message('warning', 'Cancel failed. Checking status...');
						
						$status_check = $this->midtrans->get_status($order_id);
						if ($status_check && isset($status_check['transaction_status'])) {
							$trx_status = $status_check['transaction_status'];
							
							if ($trx_status == 'settlement' || $trx_status == 'capture') {
								// Sudah dibayar
								$this->db->where('id_transaksi', $transaksi->id_transaksi);
								$this->db->update('transaksi', array('status_transaksi' => 'dibayar'));
								
								$response = ['status' => 'error', 'message' => 'Transaksi sudah dibayar. Silakan refresh halaman.'];
								goto send_response;
							} else if ($trx_status == 'expire' || $trx_status == 'cancel') {
                                // Seharusnya bisa di-recreate jika expire/cancel, tapi jika masih gagal, mungkin ada masalah lain
                                // Coba sekali lagi get_snap_token siapa tahu tadi delay
                                try {
                                    $snap_token = $this->midtrans->get_snap_token($midtrans_params);
                                    if($snap_token) {
                                        $response = ['status' => 'success', 'token' => $snap_token];
                                        goto send_response;
                                    }
                                } catch(Exception $retry_e) {
                                    // Ignore
                                }
                            }
						}
					}
				} catch (Exception $ex) {
					log_message('error', 'Error during cancel/retry: ' . $ex->getMessage());
					// Lanjut return error awal
				}
			}
			
			$response = ['status' => 'error', 'message' => $e->getMessage()];
		}

		send_response:
		// Bersihkan buffer output (membuang warning/notice PHP jika ada)
		ob_end_clean();
		
		// Set header JSON
		header('Content-Type: application/json');
		echo json_encode($response);
	}

	public function batalkan($id_transaksi)
	{
		// Cek apakah user sudah login
		if(!$this->session->userdata('logged_in')) {
			$this->session->set_flashdata('error', 'Silakan login terlebih dahulu!');
			redirect('akun');
		}
		
		// Ambil data transaksi
		$transaksi_query = $this->Mtransaksi->get_by_id($id_transaksi);
		$transaksi = $transaksi_query->num_rows() > 0 ? $transaksi_query->row() : null;
		
		if(!$transaksi) {
			$this->session->set_flashdata('error', 'Transaksi tidak ditemukan!');
			redirect('transaksi');
		}
		
		// Cek akses (hanya pemilik transaksi yang bisa membatalkan)
		$id_customer = $this->session->userdata('id_customer');
		if($transaksi->id_customer != $id_customer) {
			$this->session->set_flashdata('error', 'Anda tidak memiliki akses untuk membatalkan transaksi ini!');
			redirect('transaksi');
		}
		
		// Cek status (hanya pending yang bisa dibatalkan)
		$status = isset($transaksi->status_transaksi) ? $transaksi->status_transaksi : $transaksi->status;
		if($status != 'pending' && $status != 'menunggu_pembayaran') {
			$this->session->set_flashdata('error', 'Transaksi tidak dapat dibatalkan karena status sudah: ' . $status);
			redirect('transaksi/detail/'.$id_transaksi);
		}
		
		// Proses pembatalan
		$this->db->trans_start();
		
		try {
			// 1. Jika Midtrans, coba cancel di Midtrans dulu
			if(isset($transaksi->metode_pembayaran) && strtolower($transaksi->metode_pembayaran) == 'midtrans' && isset($transaksi->kode_transaksi)) {
				try {
					// Cek status dulu sebelum cancel
					$status_check = $this->midtrans->get_status($transaksi->kode_transaksi);
					if ($status_check && isset($status_check['transaction_status'])) {
						$trx_status = $status_check['transaction_status'];
						// Jika sudah settlement/capture, tidak bisa cancel
						if ($trx_status == 'settlement' || $trx_status == 'capture') {
							throw new Exception('Transaksi sudah dibayar, tidak dapat dibatalkan.');
						}
						// Jika belum cancel/expire, lakukan cancel
						if ($trx_status != 'cancel' && $trx_status != 'expire') {
							$this->midtrans->cancel($transaksi->kode_transaksi);
						}
					}
				} catch (Exception $e) {
					// Jika error karena transaksi tidak ditemukan di Midtrans (404), abaikan dan lanjut cancel lokal
					// Jika error lain, log tapi tetap lanjut cancel lokal (asumsi user ingin cancel)
					log_message('error', 'Gagal cancel di Midtrans: ' . $e->getMessage());
					
					// Jika exception dari throw di atas, rethrow
					if ($e->getMessage() == 'Transaksi sudah dibayar, tidak dapat dibatalkan.') {
						throw $e;
					}
				}
			}
			
			// 2. Kembalikan Stok
			// Ambil detail transaksi
			$details = $this->db->get_where('transaksi_detail', ['id_transaksi' => $id_transaksi])->result();
			
			foreach($details as $item) {
				$qty = $item->qty;
				$id_produk = $item->id_produk;
				$id_ukuran = isset($item->id_ukuran) ? $item->id_ukuran : 0;
				
				if($id_ukuran > 0) {
					// Kembalikan stok ukuran
					$this->db->set('stok', 'stok + ' . (int)$qty, FALSE);
					$this->db->where('id_ukuran', $id_ukuran);
					$this->db->update('produk_ukuran');
				} else {
					// Kembalikan stok produk utama
					$this->db->set('stok_produk', 'stok_produk + ' . (int)$qty, FALSE);
					$this->db->where('id_produk', $id_produk);
					$this->db->update('produk');
				}
			}
			
			// 3. Update status di database lokal
			$this->db->where('id_transaksi', $id_transaksi);
			$this->db->update('transaksi', array('status_transaksi' => 'dibatalkan'));
			
			$this->db->trans_complete();
			
			if ($this->db->trans_status() === FALSE) {
				throw new Exception('Gagal update database.');
			}
			
			$this->session->set_flashdata('success', 'Pesanan berhasil dibatalkan.');
			
		} catch (Exception $e) {
			$this->db->trans_rollback();
			$this->session->set_flashdata('error', 'Gagal membatalkan pesanan: ' . $e->getMessage());
		}
		
		redirect('transaksi/detail/'.$id_transaksi);
	}
}


