<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Helper untuk data statis provinsi dan kota Indonesia
 * Digunakan sebagai fallback jika API Raja Ongkir tidak tersedia
 */

if (!function_exists('get_provinsi_static')) {
	/**
	 * Mendapatkan daftar provinsi Indonesia (statis)
	 */
	function get_provinsi_static() {
		return array(
			array('province_id' => '1', 'province' => 'Bali'),
			array('province_id' => '2', 'province' => 'Bangka Belitung'),
			array('province_id' => '3', 'province' => 'Banten'),
			array('province_id' => '4', 'province' => 'Bengkulu'),
			array('province_id' => '5', 'province' => 'DI Yogyakarta'),
			array('province_id' => '6', 'province' => 'DKI Jakarta'),
			array('province_id' => '7', 'province' => 'Gorontalo'),
			array('province_id' => '8', 'province' => 'Jambi'),
			array('province_id' => '9', 'province' => 'Jawa Barat'),
			array('province_id' => '10', 'province' => 'Jawa Tengah'),
			array('province_id' => '11', 'province' => 'Jawa Timur'),
			array('province_id' => '12', 'province' => 'Kalimantan Barat'),
			array('province_id' => '13', 'province' => 'Kalimantan Selatan'),
			array('province_id' => '14', 'province' => 'Kalimantan Tengah'),
			array('province_id' => '15', 'province' => 'Kalimantan Timur'),
			array('province_id' => '16', 'province' => 'Kalimantan Utara'),
			array('province_id' => '17', 'province' => 'Kepulauan Riau'),
			array('province_id' => '18', 'province' => 'Lampung'),
			array('province_id' => '19', 'province' => 'Maluku'),
			array('province_id' => '20', 'province' => 'Maluku Utara'),
			array('province_id' => '21', 'province' => 'Nanggroe Aceh Darussalam'),
			array('province_id' => '22', 'province' => 'Nusa Tenggara Barat'),
			array('province_id' => '23', 'province' => 'Nusa Tenggara Timur'),
			array('province_id' => '24', 'province' => 'Papua'),
			array('province_id' => '25', 'province' => 'Papua Barat'),
			array('province_id' => '26', 'province' => 'Riau'),
			array('province_id' => '27', 'province' => 'Sulawesi Barat'),
			array('province_id' => '28', 'province' => 'Sulawesi Selatan'),
			array('province_id' => '29', 'province' => 'Sulawesi Tengah'),
			array('province_id' => '30', 'province' => 'Sulawesi Tenggara'),
			array('province_id' => '31', 'province' => 'Sulawesi Utara'),
			array('province_id' => '32', 'province' => 'Sumatera Barat'),
			array('province_id' => '33', 'province' => 'Sumatera Selatan'),
			array('province_id' => '34', 'province' => 'Sumatera Utara')
		);
	}
}

if (!function_exists('get_kota_by_provinsi_static')) {
	/**
	 * Mendapatkan daftar kota berdasarkan provinsi (statis)
	 * Data lengkap untuk provinsi populer
	 */
	function get_kota_by_provinsi_static($province_id) {
		$kota_data = array(
			'6' => array( // DKI Jakarta
				array('city_id' => '151', 'type' => 'Kota', 'city_name' => 'Jakarta Barat'),
				array('city_id' => '152', 'type' => 'Kota', 'city_name' => 'Jakarta Pusat'),
				array('city_id' => '153', 'type' => 'Kota', 'city_name' => 'Jakarta Selatan'),
				array('city_id' => '154', 'type' => 'Kota', 'city_name' => 'Jakarta Timur'),
				array('city_id' => '155', 'type' => 'Kota', 'city_name' => 'Jakarta Utara'),
				array('city_id' => '151', 'type' => 'Kabupaten', 'city_name' => 'Kepulauan Seribu')
			),
			'9' => array( // Jawa Barat
				array('city_id' => '22', 'type' => 'Kota', 'city_name' => 'Bandung'),
				array('city_id' => '23', 'type' => 'Kota', 'city_name' => 'Banjar'),
				array('city_id' => '24', 'type' => 'Kota', 'city_name' => 'Bekasi'),
				array('city_id' => '25', 'type' => 'Kota', 'city_name' => 'Bogor'),
				array('city_id' => '26', 'type' => 'Kota', 'city_name' => 'Cimahi'),
				array('city_id' => '27', 'type' => 'Kota', 'city_name' => 'Cirebon'),
				array('city_id' => '28', 'type' => 'Kota', 'city_name' => 'Depok'),
				array('city_id' => '29', 'type' => 'Kota', 'city_name' => 'Sukabumi'),
				array('city_id' => '30', 'type' => 'Kota', 'city_name' => 'Tasikmalaya')
			),
			'10' => array( // Jawa Tengah
				array('city_id' => '399', 'type' => 'Kota', 'city_name' => 'Magelang'),
				array('city_id' => '400', 'type' => 'Kota', 'city_name' => 'Pekalongan'),
				array('city_id' => '401', 'type' => 'Kota', 'city_name' => 'Salatiga'),
				array('city_id' => '402', 'type' => 'Kota', 'city_name' => 'Semarang'),
				array('city_id' => '403', 'type' => 'Kota', 'city_name' => 'Surakarta'),
				array('city_id' => '404', 'type' => 'Kota', 'city_name' => 'Tegal')
			),
			'11' => array( // Jawa Timur
				array('city_id' => '444', 'type' => 'Kota', 'city_name' => 'Surabaya'),
				array('city_id' => '445', 'type' => 'Kota', 'city_name' => 'Malang'),
				array('city_id' => '446', 'type' => 'Kota', 'city_name' => 'Kediri'),
				array('city_id' => '447', 'type' => 'Kota', 'city_name' => 'Blitar'),
				array('city_id' => '448', 'type' => 'Kota', 'city_name' => 'Probolinggo')
			),
			'5' => array( // DI Yogyakarta
				array('city_id' => '501', 'type' => 'Kota', 'city_name' => 'Yogyakarta')
			)
		);

		if (isset($kota_data[$province_id])) {
			return $kota_data[$province_id];
		}

		// Jika provinsi tidak ada di data statis, kembalikan array kosong
		// atau bisa ditambahkan data lengkap untuk semua provinsi
		return array();
	}
}

