<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('get_harga_diskon')) {
    /**
     * Mendapatkan harga diskon produk jika ada promo aktif
     * Bisa menerima data promo dari object produk (hasil join) atau query manual
     * @param int|object $produk_or_id - Bisa object produk (dari join) atau id_produk
     * @param float $harga_awal
     * @return array ['harga_awal' => float, 'harga_diskon' => float, 'persen_diskon' => int]
     */
    function get_harga_diskon($produk_or_id, $harga_awal) {
        // Jika parameter pertama adalah object (produk hasil join)
        if(is_object($produk_or_id)) {
            $produk = $produk_or_id;
            $now = date('Y-m-d H:i:s');
            
            // DEBUG MODE - Uncomment untuk troubleshooting
            $debug = false; // Set true untuk melihat debug info
            if($debug && isset($produk->id_produk)) {
                echo "<!-- DEBUG PROMO - Produk ID: {$produk->id_produk} -->\n";
                echo "<!-- harga_diskon: " . (isset($produk->harga_diskon) ? $produk->harga_diskon : 'NOT SET') . " -->\n";
                echo "<!-- status_promo: " . (isset($produk->status_promo) ? $produk->status_promo : 'NOT SET') . " -->\n";
                echo "<!-- waktu_mulai: " . (isset($produk->waktu_mulai) ? $produk->waktu_mulai : 'NOT SET') . " -->\n";
                echo "<!-- waktu_berakhir: " . (isset($produk->waktu_berakhir) ? $produk->waktu_berakhir : 'NOT SET') . " -->\n";
                echo "<!-- waktu_sekarang: {$now} -->\n";
            }
            
            // Cek apakah produk punya data promo dari join
            if(isset($produk->harga_diskon) && $produk->harga_diskon !== null && $produk->harga_diskon > 0) {
                // Cek apakah promo aktif berdasarkan status dan waktu
                $promo_aktif = false;
                
                if(isset($produk->status_promo) && $produk->status_promo == 'aktif') {
                    // Cek waktu promo
                    if(isset($produk->waktu_mulai) && isset($produk->waktu_berakhir)) {
                        $waktu_mulai = strtotime($produk->waktu_mulai);
                        $waktu_berakhir = strtotime($produk->waktu_berakhir);
                        $waktu_sekarang = strtotime($now);
                        
                        if($debug && isset($produk->id_produk)) {
                            echo "<!-- waktu_mulai_ts: {$waktu_mulai} (" . date('Y-m-d H:i:s', $waktu_mulai) . ") -->\n";
                            echo "<!-- waktu_sekarang_ts: {$waktu_sekarang} (" . date('Y-m-d H:i:s', $waktu_sekarang) . ") -->\n";
                            echo "<!-- waktu_berakhir_ts: {$waktu_berakhir} (" . date('Y-m-d H:i:s', $waktu_berakhir) . ") -->\n";
                            echo "<!-- Mulai <= Sekarang? " . ($waktu_mulai <= $waktu_sekarang ? 'YES' : 'NO') . " -->\n";
                            echo "<!-- Berakhir >= Sekarang? " . ($waktu_berakhir >= $waktu_sekarang ? 'YES' : 'NO') . " -->\n";
                        }
                        
                        // Promo aktif jika waktu sekarang berada di antara waktu mulai dan berakhir
                        if($waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang) {
                            $promo_aktif = true;
                        }
                    }
                }
                
                // Jika promo aktif, return harga diskon
                if($promo_aktif) {
                    $harga_diskon = $produk->harga_diskon;
                    $persen_diskon = $harga_awal > 0 ? round((($harga_awal - $harga_diskon) / $harga_awal) * 100, 0) : 0;
                    
                    if($debug && isset($produk->id_produk)) {
                        echo "<!-- PROMO AKTIF! Harga: {$harga_awal} -> {$harga_diskon} ({$persen_diskon}%) -->\n";
                    }
                    
                    return array(
                        'harga_awal' => $harga_awal,
                        'harga_diskon' => $harga_diskon,
                        'persen_diskon' => $persen_diskon
                    );
                }
            }
            
            // Jika tidak ada promo aktif
            return array(
                'harga_awal' => $harga_awal,
                'harga_diskon' => $harga_awal,
                'persen_diskon' => 0
            );
        }
        
        // Jika parameter pertama adalah id_produk (fallback untuk query manual)
        $id_produk = $produk_or_id;
        $CI =& get_instance();
        
        // Cek apakah tabel promo ada
        if(!$CI->db->table_exists('promo') || !$CI->db->table_exists('promo_produk')) {
            return array(
                'harga_awal' => $harga_awal,
                'harga_diskon' => $harga_awal,
                'persen_diskon' => 0
            );
        }
        
        $now = date('Y-m-d H:i:s');
        
        // Cari promo aktif untuk produk ini
        $CI->db->select('promo.*, promo_produk.harga_awal as harga_awal_promo, promo_produk.harga_diskon');
        $CI->db->from('promo');
        $CI->db->join('promo_produk', 'promo_produk.id_promo = promo.id_promo', 'inner');
        $CI->db->where('promo_produk.id_produk', $id_produk);
        $CI->db->where('promo.status_promo', 'aktif');
        $CI->db->where('promo.waktu_mulai <=', $now);
        $CI->db->where('promo.waktu_berakhir >=', $now);
        $CI->db->order_by('promo.id_promo', 'DESC');
        $CI->db->limit(1);
        
        $promo = $CI->db->get()->row();
        
        if($promo && isset($promo->harga_diskon) && $promo->harga_diskon > 0) {
            $harga_diskon = $promo->harga_diskon;
            $persen_diskon = $harga_awal > 0 ? round((($harga_awal - $harga_diskon) / $harga_awal) * 100, 0) : 0;
            
            return array(
                'harga_awal' => $harga_awal,
                'harga_diskon' => $harga_diskon,
                'persen_diskon' => $persen_diskon
            );
        }
        
        return array(
            'harga_awal' => $harga_awal,
            'harga_diskon' => $harga_awal,
            'persen_diskon' => 0
        );
    }
}

