<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rajaongkir {
	
	private $api_key;
	private $account_type; // 'starter', 'basic', 'pro'
	private $base_url;
	
	public function __construct() {
		// Konfigurasi Raja Ongkir
		// Dapatkan API Key di: https://rajaongkir.com/akun/daftar
		// PASTIKAN UNTUK MENGISI API KEY ANDA DI BAWAH INI!
		$this->api_key = 'ZmPbJk1ef9e97f00a760f2a5fxnjJkDu'; // GANTI dengan API Key Anda dari Raja Ongkir Dashboard
		$this->account_type = 'starter'; // starter, basic, atau pro
		
		// Validasi API Key - hanya cek jika masih placeholder default
		// PENTING: JANGAN ubah validasi ini untuk mengecek API Key yang sudah diisi!
		// Validasi ini hanya untuk mendeteksi jika masih menggunakan placeholder default
		if(empty($this->api_key) || $this->api_key == 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx') {
			log_message('error', 'Raja Ongkir API Key belum dikonfigurasi! Silakan isi API Key di application/libraries/Rajaongkir.php');
		}
		
		// Set base URL berdasarkan account type
		if($this->account_type == 'starter') {
			$this->base_url = 'https://api.rajaongkir.com/starter';
		} else if($this->account_type == 'basic') {
			$this->base_url = 'https://api.rajaongkir.com/basic';
		} else {
			$this->base_url = 'https://api.rajaongkir.com/pro';
		}
	}
	
	/**
	 * Mendapatkan daftar provinsi
	 */
	public function get_provinsi() {
		// Cek jika API Key belum dikonfigurasi (hanya cek placeholder default)
		// PENTING: JANGAN ubah validasi ini untuk mengecek API Key yang sudah diisi!
		if(empty($this->api_key) || $this->api_key == 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx') {
			log_message('error', 'Raja Ongkir: API Key belum dikonfigurasi');
			return false;
		}
		
		// Pastikan API Key tidak kosong
		if(empty($this->api_key)) {
			log_message('error', 'Raja Ongkir: API Key kosong');
			return false;
		}
		
		$curl = curl_init();
		
		curl_setopt_array($curl, array(
			CURLOPT_URL => $this->base_url . '/province',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'key: ' . $this->api_key
			),
		));
		
		$response = curl_exec($curl);
		$curl_error = curl_error($curl);
		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);
		
		// Log untuk debugging
		$url = $this->base_url . '/province';
		log_message('debug', 'Raja Ongkir Request URL: ' . $url);
		log_message('debug', 'Raja Ongkir API Key: ' . substr($this->api_key, 0, 10) . '...');
		log_message('debug', 'Raja Ongkir HTTP Code: ' . $http_code);
		log_message('debug', 'Raja Ongkir Response: ' . substr($response, 0, 500));
		
		// Cek error curl
		if($curl_error) {
			log_message('error', 'Raja Ongkir CURL Error: ' . $curl_error);
			return false;
		}
		
		if ($http_code == 200) {
			$result = json_decode($response, true);
			
			if(isset($result['rajaongkir']['results']) && is_array($result['rajaongkir']['results']) && count($result['rajaongkir']['results']) > 0) {
				log_message('info', 'Raja Ongkir: Berhasil mengambil ' . count($result['rajaongkir']['results']) . ' provinsi');
				return $result['rajaongkir']['results'];
			} else if(isset($result['rajaongkir']['status']['code']) && $result['rajaongkir']['status']['code'] != 200) {
				$error_msg = isset($result['rajaongkir']['status']['description']) ? $result['rajaongkir']['status']['description'] : 'Unknown error';
				log_message('error', 'Raja Ongkir Provinsi API Error: ' . $error_msg . ' | Full response: ' . $response);
				return false;
			} else {
				log_message('error', 'Raja Ongkir: Response tidak valid atau kosong. Full response: ' . $response);
				return false;
			}
		} else if ($http_code == 401) {
			log_message('error', 'Raja Ongkir: API Key tidak valid atau tidak terdaftar (HTTP 401). Response: ' . substr($response, 0, 500));
			return false;
		} else if ($http_code == 403) {
			log_message('error', 'Raja Ongkir: Akses ditolak. Pastikan API Key sudah benar dan akun masih aktif (HTTP 403). Response: ' . substr($response, 0, 500));
			return false;
		} else if ($http_code == 0) {
			log_message('error', 'Raja Ongkir: Tidak dapat terhubung ke server. Cek koneksi internet atau firewall.');
			return false;
		}
		
		log_message('error', 'Raja Ongkir Provinsi HTTP Error ' . $http_code . ': ' . substr($response, 0, 500));
		return false;
	}
	
	/**
	 * Mendapatkan daftar kota berdasarkan provinsi
	 */
	public function get_kota($id_provinsi = null) {
		$url = $this->base_url . '/city';
		if($id_provinsi) {
			$url .= '?province=' . $id_provinsi;
		}
		
		$curl = curl_init();
		
		curl_setopt_array($curl, array(
			CURLOPT_URL => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'key: ' . $this->api_key
			),
		));
		
		$response = curl_exec($curl);
		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);
		
		if ($http_code == 200) {
			$result = json_decode($response, true);
			if(isset($result['rajaongkir']['results']) && is_array($result['rajaongkir']['results'])) {
				return $result['rajaongkir']['results'];
			} else if(isset($result['rajaongkir']['status']['code']) && $result['rajaongkir']['status']['code'] != 200) {
				$error_msg = isset($result['rajaongkir']['status']['description']) ? $result['rajaongkir']['status']['description'] : 'Unknown error';
				log_message('error', 'Raja Ongkir Kota API Error: ' . $error_msg);
				return false;
			}
		}
		
		log_message('error', 'Raja Ongkir Kota HTTP Error ' . $http_code . ': ' . $response);
		return false;
	}
	
	/**
	 * Menghitung ongkir
	 */
	public function get_ongkir($origin, $destination, $weight, $courier) {
		$curl = curl_init();
		
		$post_data = array(
			'origin' => $origin,
			'destination' => $destination,
			'weight' => $weight,
			'courier' => $courier
		);
		
		curl_setopt_array($curl, array(
			CURLOPT_URL => $this->base_url . '/cost',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => http_build_query($post_data),
			CURLOPT_HTTPHEADER => array(
				'key: ' . $this->api_key,
				'content-type: application/x-www-form-urlencoded'
			),
		));
		
		$response = curl_exec($curl);
		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);
		
		if ($http_code == 200) {
			$result = json_decode($response, true);
			if(isset($result['rajaongkir']['results']) && is_array($result['rajaongkir']['results'])) {
				return $result['rajaongkir']['results'];
			} else if(isset($result['rajaongkir']['status']['code']) && $result['rajaongkir']['status']['code'] != 200) {
				$error_msg = isset($result['rajaongkir']['status']['description']) ? $result['rajaongkir']['status']['description'] : 'Unknown error';
				log_message('error', 'Raja Ongkir Cost API Error: ' . $error_msg);
				return false;
			}
		}
		
		log_message('error', 'Raja Ongkir Cost HTTP Error ' . $http_code . ': ' . $response);
		return false;
	}
}

