<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mkeranjang extends CI_Model {

	public function get_by_customer($id_customer)
	{
		// Cek kolom yang ada di tabel produk
		$fields = array('keranjang.*', 'produk.nama_produk', 'kategori.nama_kategori');
		
		// Tambahkan kolom gambar jika ada (prioritas: gambar_produk > foto_produk > gambar)
		if($this->db->field_exists('gambar_produk', 'produk')) {
			$fields[] = 'produk.gambar_produk';
		}
		if($this->db->field_exists('foto_produk', 'produk')) {
			$fields[] = 'produk.foto_produk';
		}
		if($this->db->field_exists('gambar', 'produk')) {
			$fields[] = 'produk.gambar';
		}
		
		// Tambahkan kolom harga dari produk sebagai fallback
		if($this->db->field_exists('harga_produk', 'produk')) {
			$fields[] = 'produk.harga_produk';
		}
		if($this->db->field_exists('harga', 'produk')) {
			$fields[] = 'produk.harga as harga_produk_alt';
		}

		// Tambahkan kolom ukuran
		$fields[] = 'produk_ukuran.ukuran';
		$fields[] = 'produk_ukuran.harga as harga_ukuran';
		
		$this->db->select(implode(', ', $fields));
		$this->db->from('keranjang');
		$this->db->join('produk', 'produk.id_produk = keranjang.id_produk', 'left');
		$this->db->join('kategori', 'kategori.id_kategori = produk.id_kategori', 'left');
		$this->db->join('produk_ukuran', 'produk_ukuran.id_ukuran = keranjang.id_ukuran', 'left');
		$this->db->where('keranjang.id_customer', $id_customer);
		$this->db->order_by('keranjang.id_keranjang', 'DESC');
		return $this->db->get();
	}

	public function cek_produk($id_customer, $id_produk, $id_ukuran = 0)
	{
		$this->db->where('id_customer', $id_customer);
		$this->db->where('id_produk', $id_produk);
		if($id_ukuran > 0) {
			$this->db->where('id_ukuran', $id_ukuran);
		} else {
			// Handle jika id_ukuran 0 atau NULL
			$this->db->group_start();
			$this->db->where('id_ukuran', 0);
			$this->db->or_where('id_ukuran', NULL);
			$this->db->group_end();
		}
		return $this->db->get('keranjang');
	}

	public function insert($data)
	{
		return $this->db->insert('keranjang', $data);
	}

	public function update_qty($id_keranjang, $qty)
	{
		$this->db->where('id_keranjang', $id_keranjang);
		$this->db->update('keranjang', array('qty' => $qty));
		return $this->db->affected_rows() > 0;
	}

	public function delete($id_keranjang)
	{
		$this->db->where('id_keranjang', $id_keranjang);
		return $this->db->delete('keranjang');
	}

	public function clear($id_customer)
	{
		$this->db->where('id_customer', $id_customer);
		return $this->db->delete('keranjang');
	}

	public function clear_selected($selected_items)
	{
		if(!empty($selected_items)) {
			$this->db->where_in('id_keranjang', $selected_items);
			return $this->db->delete('keranjang');
		}
		return false;
	}

	public function get_by_id($id_keranjang)
	{
		$this->db->where('id_keranjang', $id_keranjang);
		return $this->db->get('keranjang');
	}
}

