<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mmember extends CI_Model {

	public function register($data)
	{
		// Hash password dengan bcrypt sebelum disimpan
		if(isset($data['password_customer']) && !empty($data['password_customer']))
		{
			$data['password_customer'] = password_hash($data['password_customer'], PASSWORD_BCRYPT);
		}
		
		// Set timezone ke Jakarta dan created_at jika belum ada
		if(!isset($data['created_at']))
		{
			date_default_timezone_set('Asia/Jakarta');
			$data['created_at'] = date('Y-m-d H:i:s');
		}
		
		return $this->db->insert('customer', $data);
	}

	public function cek_email($email)
	{
		$this->db->where('email_customer', $email);
		return $this->db->get('customer')->num_rows();
	}

	public function login($email, $password)
	{
		// Cari customer berdasarkan email
		$this->db->where('email_customer', $email);
		$query = $this->db->get('customer');
		
		if($query->num_rows() > 0) {
			$customer = $query->row();
			
			// Check password dengan backward compatibility (MD5 → bcrypt)
			if(strlen($customer->password_customer) == 32) {
				// Password lama (MD5), verifikasi dan update ke bcrypt
				if(md5($password) === $customer->password_customer) {
					// Auto-migrate ke bcrypt
					$this->db->where('id_customer', $customer->id_customer);
					$this->db->update('customer', array('password_customer' => password_hash($password, PASSWORD_BCRYPT)));
					return $customer; // Return success
				}
			} else {
				// Password baru (bcrypt)
				if(password_verify($password, $customer->password_customer)) {
					return $customer; // Return success
				}
			}
		}
		
		return false;
	}

	public function get_by_id($id_customer)
	{
		$this->db->where('id_customer', $id_customer);
		return $this->db->get('customer');
	}

	public function get_by_email($email)
	{
		$this->db->where('email_customer', $email);
		return $this->db->get('customer');
	}
}

