<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mnotifikasi extends CI_Model {

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function get_by_customer($id_customer, $limit = 10)
    {
        $this->db->where('id_customer', $id_customer);
        $this->db->order_by('created_at', 'DESC');
        $this->db->limit($limit);
        return $this->db->get('notifikasi_customer');
    }

    public function get_unread_count($id_customer)
    {
        $this->db->where('id_customer', $id_customer);
        $this->db->where('is_read', 0);
        return $this->db->count_all_results('notifikasi_customer');
    }

    public function mark_as_read($id_notifikasi)
    {
        $this->db->where('id_notifikasi', $id_notifikasi);
        return $this->db->update('notifikasi_customer', array('is_read' => 1));
    }
    
    public function mark_all_as_read($id_customer)
    {
        $this->db->where('id_customer', $id_customer);
        $this->db->where('is_read', 0);
        return $this->db->update('notifikasi_customer', array('is_read' => 1));
    }
}
