<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mproduk extends CI_Model {

	public function get_terbaru($limit = 8)
	{
		$now = date('Y-m-d H:i:s');
		$active_promo_subquery = "(SELECT promo_produk.id_produk, promo_produk.harga_diskon, promo.status_promo, promo.waktu_mulai, promo.waktu_berakhir, promo.tipe_diskon, promo.nilai_diskon 
		    FROM promo_produk 
		    JOIN promo ON promo.id_promo = promo_produk.id_promo 
		    WHERE promo.status_promo = 'aktif' 
		    AND promo.waktu_mulai <= '$now' 
		    AND promo.waktu_berakhir >= '$now'
		    GROUP BY promo_produk.id_produk
		) as active_promo";

		// Select semua kolom produk, kategori, dan data promo (akan difilter di helper)
		$this->db->select('produk.*, kategori.nama_kategori, active_promo.harga_diskon, active_promo.status_promo, active_promo.waktu_mulai, active_promo.waktu_berakhir, active_promo.tipe_diskon, active_promo.nilai_diskon');
		$this->db->from('produk');
		$this->db->join('kategori', 'kategori.id_kategori = produk.id_kategori', 'left');
		$this->db->join($active_promo_subquery, 'active_promo.id_produk = produk.id_produk', 'left');
		
		// Filter status_produk hanya jika kolom ada
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('produk.status_produk', 'aktif');
		}
		$this->db->group_by('produk.id_produk');
		$this->db->order_by('active_promo.status_promo', 'DESC'); 
		$this->db->order_by('active_promo.waktu_berakhir', 'DESC'); 
		$this->db->order_by('produk.id_produk', 'DESC');
		$this->db->limit($limit);
		return $this->db->get();
	}

	public function get_all()
	{
		$now = date('Y-m-d H:i:s');
		$active_promo_subquery = "(SELECT promo_produk.id_produk, promo_produk.harga_diskon, promo.status_promo, promo.waktu_mulai, promo.waktu_berakhir, promo.tipe_diskon, promo.nilai_diskon 
		    FROM promo_produk 
		    JOIN promo ON promo.id_promo = promo_produk.id_promo 
		    WHERE promo.status_promo = 'aktif' 
		    AND promo.waktu_mulai <= '$now' 
		    AND promo.waktu_berakhir >= '$now'
		    GROUP BY promo_produk.id_produk
		) as active_promo";

		// Select semua kolom produk, kategori, dan data promo (akan difilter di helper)
		$this->db->select('produk.*, kategori.nama_kategori, active_promo.harga_diskon, active_promo.status_promo, active_promo.waktu_mulai, active_promo.waktu_berakhir, active_promo.tipe_diskon, active_promo.nilai_diskon');
		$this->db->from('produk');
		$this->db->join('kategori', 'kategori.id_kategori = produk.id_kategori', 'left');
		$this->db->join($active_promo_subquery, 'active_promo.id_produk = produk.id_produk', 'left');
		
		// Filter status_produk hanya jika kolom ada
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('produk.status_produk', 'aktif');
		}
		$this->db->group_by('produk.id_produk');
		$this->db->order_by('active_promo.status_promo', 'DESC');
		$this->db->order_by('active_promo.waktu_berakhir', 'DESC');
		$this->db->order_by('produk.id_produk', 'DESC');
		return $this->db->get();
	}

	public function get_by_id($id_produk)
	{
		$now = date('Y-m-d H:i:s');
		$active_promo_subquery = "(SELECT promo_produk.id_produk, promo_produk.harga_diskon, promo.status_promo, promo.waktu_mulai, promo.waktu_berakhir, promo.tipe_diskon, promo.nilai_diskon 
		    FROM promo_produk 
		    JOIN promo ON promo.id_promo = promo_produk.id_promo 
		    WHERE promo.status_promo = 'aktif' 
		    AND promo.waktu_mulai <= '$now' 
		    AND promo.waktu_berakhir >= '$now'
		    GROUP BY promo_produk.id_produk
		) as active_promo";

		// Select semua kolom produk, kategori, dan data promo (akan difilter di helper)
		$this->db->select('produk.*, kategori.nama_kategori, active_promo.harga_diskon, active_promo.status_promo, active_promo.waktu_mulai, active_promo.waktu_berakhir, active_promo.tipe_diskon, active_promo.nilai_diskon');
		$this->db->from('produk');
		$this->db->join('kategori', 'kategori.id_kategori = produk.id_kategori', 'left');
		$this->db->join($active_promo_subquery, 'active_promo.id_produk = produk.id_produk', 'left');
		$this->db->where('produk.id_produk', $id_produk);
		
		return $this->db->get();
	}

	public function get_ukuran($id_produk)
	{
		$this->db->where('id_produk', $id_produk);
		return $this->db->get('produk_ukuran')->result();
	}

	public function get_by_kategori($id_kategori)
	{
		$now = date('Y-m-d H:i:s');
		$active_promo_subquery = "(SELECT promo_produk.id_produk, promo_produk.harga_diskon, promo.status_promo, promo.waktu_mulai, promo.waktu_berakhir, promo.tipe_diskon, promo.nilai_diskon 
		    FROM promo_produk 
		    JOIN promo ON promo.id_promo = promo_produk.id_promo 
		    WHERE promo.status_promo = 'aktif' 
		    AND promo.waktu_mulai <= '$now' 
		    AND promo.waktu_berakhir >= '$now'
		    GROUP BY promo_produk.id_produk
		) as active_promo";

		// Select semua kolom produk, kategori, dan data promo (akan difilter di helper)
		$this->db->select('produk.*, kategori.nama_kategori, active_promo.harga_diskon, active_promo.status_promo, active_promo.waktu_mulai, active_promo.waktu_berakhir, active_promo.tipe_diskon, active_promo.nilai_diskon');
		$this->db->from('produk');
		$this->db->join('kategori', 'kategori.id_kategori = produk.id_kategori', 'left');
		$this->db->join($active_promo_subquery, 'active_promo.id_produk = produk.id_produk', 'left');
		$this->db->where('produk.id_kategori', $id_kategori);
		
		// Filter status_produk hanya jika kolom ada
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('produk.status_produk', 'aktif');
		}
		$this->db->group_by('produk.id_produk');
		$this->db->order_by('active_promo.status_promo', 'DESC');
		$this->db->order_by('active_promo.waktu_berakhir', 'DESC');
		$this->db->order_by('produk.id_produk', 'DESC');
		return $this->db->get();
	}

	/**
	 * Search produk berdasarkan keyword
	 */
	public function search($keyword, $id_kategori = null, $limit = null, $offset = null)
	{
		$now = date('Y-m-d H:i:s');
		$active_promo_subquery = "(SELECT promo_produk.id_produk, promo_produk.harga_diskon, promo.status_promo, promo.waktu_mulai, promo.waktu_berakhir, promo.tipe_diskon, promo.nilai_diskon 
		    FROM promo_produk 
		    JOIN promo ON promo.id_promo = promo_produk.id_promo 
		    WHERE promo.status_promo = 'aktif' 
		    AND promo.waktu_mulai <= '$now' 
		    AND promo.waktu_berakhir >= '$now'
		    GROUP BY promo_produk.id_produk
		) as active_promo";

		// Select semua kolom produk, kategori, dan data promo (akan difilter di helper)
		$this->db->select('produk.*, kategori.nama_kategori, active_promo.harga_diskon, active_promo.status_promo, active_promo.waktu_mulai, active_promo.waktu_berakhir, active_promo.tipe_diskon, active_promo.nilai_diskon');
		$this->db->from('produk');
		$this->db->join('kategori', 'kategori.id_kategori = produk.id_kategori', 'left');
		$this->db->join($active_promo_subquery, 'active_promo.id_produk = produk.id_produk', 'left');
		
		// Filter status_produk hanya jika kolom ada
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('produk.status_produk', 'aktif');
		}
		
		// Filter kategori jika ada
		if($id_kategori && !empty($id_kategori)) {
			$this->db->where('produk.id_kategori', $id_kategori);
		}
		
		// Search keyword
		if($keyword && !empty($keyword)) {
			$this->db->group_start();
			$this->db->like('produk.nama_produk', $keyword);
			$this->db->or_like('produk.deskripsi_produk', $keyword);
			$this->db->or_like('kategori.nama_kategori', $keyword);
			$this->db->group_end();
		}
		
		$this->db->group_by('produk.id_produk');
		$this->db->order_by('active_promo.status_promo', 'DESC');
		$this->db->order_by('active_promo.waktu_berakhir', 'DESC');
		$this->db->order_by('produk.id_produk', 'DESC');
		
		if($limit) {
			$this->db->limit($limit, $offset);
		}
		
		return $this->db->get();
	}

	/**
	 * Count total hasil search
	 */
	public function count_search($keyword = null, $id_kategori = null)
	{
		$this->db->from('produk');
		$this->db->join('kategori', 'kategori.id_kategori = produk.id_kategori', 'left');
		
		// Filter status_produk hanya jika kolom ada
		if($this->db->field_exists('status_produk', 'produk')) {
			$this->db->where('produk.status_produk', 'aktif');
		}
		
		// Filter kategori jika ada
		if($id_kategori && !empty($id_kategori)) {
			$this->db->where('produk.id_kategori', $id_kategori);
		}
		
		// Search keyword
		if($keyword && !empty($keyword)) {
			$this->db->group_start();
			$this->db->like('produk.nama_produk', $keyword);
			$this->db->or_like('produk.deskripsi_produk', $keyword);
			$this->db->or_like('kategori.nama_kategori', $keyword);
			$this->db->group_end();
		}
		
		return $this->db->count_all_results();
	}
}
