<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mretur extends CI_Model {

	/**
	 * Get retur by customer ID
	 */
	public function get_by_customer($id_customer)
	{
		// Cek kolom yang ada di tabel transaksi
		$has_order_id = $this->db->field_exists('order_id', 'transaksi');
		$has_total = $this->db->field_exists('total', 'transaksi');
		$has_total_harga = $this->db->field_exists('total_harga', 'transaksi');
		
		// Build select statement
		$select = 'r.*';
		
		// Add order_id
		if($has_order_id) {
			$select .= ', t.order_id';
		} else {
			$select .= ', t.id_transaksi as order_id';
		}
		
		// Add total
		if($has_total) {
			$select .= ', t.total';
		} elseif($has_total_harga) {
			$select .= ', t.total_harga as total';
		} else {
			$select .= ', 0 as total';
		}
		
		$this->db->select($select);
		$this->db->from('retur r');
		$this->db->join('transaksi t', 't.id_transaksi = r.id_transaksi', 'left');
		$this->db->where('r.id_customer', $id_customer);
		$this->db->order_by('r.id_retur', 'DESC');
		return $this->db->get();
	}

	/**
	 * Get retur by ID (untuk customer yang login)
	 */
	public function get_by_id($id_retur, $id_customer)
	{
		// Cek kolom yang ada di tabel transaksi
		$has_order_id = $this->db->field_exists('order_id', 'transaksi');
		$has_total = $this->db->field_exists('total', 'transaksi');
		$has_total_harga = $this->db->field_exists('total_harga', 'transaksi');
		
		// Build select statement
		$select = 'r.*';
		
		// Add order_id
		if($has_order_id) {
			$select .= ', t.order_id';
		} else {
			$select .= ', t.id_transaksi as order_id';
		}
		
		// Add total
		if($has_total) {
			$select .= ', t.total';
		} elseif($has_total_harga) {
			$select .= ', t.total_harga as total';
		} else {
			$select .= ', 0 as total';
		}
		
		$this->db->select($select);
		$this->db->from('retur r');
		$this->db->join('transaksi t', 't.id_transaksi = r.id_transaksi', 'left');
		$this->db->where('r.id_retur', $id_retur);
		$this->db->where('r.id_customer', $id_customer);
		return $this->db->get();
	}

	/**
	 * Check if retur already exists for transaction
	 */
	public function check_retur_exists($id_transaksi)
	{
		$this->db->where('id_transaksi', $id_transaksi);
		return $this->db->get('retur')->num_rows() > 0;
	}

	/**
	 * Insert new retur
	 */
	public function insert($data)
	{
		// Set default created_at jika belum ada
		if(!isset($data['created_at']))
		{
			date_default_timezone_set('Asia/Jakarta');
			$data['created_at'] = date('Y-m-d H:i:s');
		}

		// Set default status jika belum ada
		if(!isset($data['status_retur']))
		{
			$data['status_retur'] = 'pending';
		}

		return $this->db->insert('retur', $data);
	}

	/**
	 * Get retur items
	 */
	public function get_retur_items($id_retur)
	{
		$this->db->select('ri.*, p.nama_produk, p.harga_produk, p.gambar_produk');
		$this->db->from('retur_item ri');
		$this->db->join('produk p', 'p.id_produk = ri.id_produk', 'left');
		$this->db->where('ri.id_retur', $id_retur);
		return $this->db->get();
	}

	/**
	 * Insert retur item
	 */
	public function insert_item($data)
	{
		return $this->db->insert('retur_item', $data);
	}
}

