<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mtransaksi extends CI_Model {

	public function get_by_customer($id_customer)
	{
		// Pastikan mengambil semua kolom termasuk status_transaksi
		$this->db->select('*');
		$this->db->where('id_customer', $id_customer);
		$this->db->order_by('id_transaksi', 'DESC');
		return $this->db->get('transaksi');
	}

	public function get_by_id($id_transaksi)
	{
		$this->db->where('id_transaksi', $id_transaksi);
		return $this->db->get('transaksi');
	}

	public function get_detail_by_transaksi($id_transaksi)
	{
		// Cek apakah tabel transaksi_detail ada
		if($this->db->table_exists('transaksi_detail')) {
			$this->db->select('td.*, produk.nama_produk, kategori.nama_kategori, produk.gambar_produk');
			$this->db->from('transaksi_detail td');
			$this->db->join('produk', 'produk.id_produk = td.id_produk', 'left');
			$this->db->join('kategori', 'kategori.id_kategori = produk.id_kategori', 'left');
			$this->db->where('td.id_transaksi', $id_transaksi);
			$result = $this->db->get();
			
			// Jika ada data, return
			if($result->num_rows() > 0) {
				return $result;
			}
		}
		
		// Fallback: Ambil dari catatan transaksi (JSON)
		$this->db->select('catatan');
		$this->db->where('id_transaksi', $id_transaksi);
		$transaksi = $this->db->get('transaksi')->row();
		
		if($transaksi && !empty($transaksi->catatan)) {
			$catatan = $transaksi->catatan;
			
			// Cari JSON_DATA di catatan dengan berbagai format
			$json_string = null;
			
			// Method 1: Cari JSON_DATA: di awal atau di tengah (dengan separator | )
			if(preg_match('/JSON_DATA:\s*(\{.*\})/s', $catatan, $matches)) {
				$json_string = $matches[1];
			}
			// Method 2: Jika tidak ditemukan, coba cari dari posisi JSON_DATA: sampai akhir atau sampai separator
			else if(strpos($catatan, 'JSON_DATA:') !== false) {
				$start_pos = strpos($catatan, 'JSON_DATA:') + strlen('JSON_DATA:');
				$remaining = substr($catatan, $start_pos);
				
				// Cari akhir JSON (tutup kurung kurawal terakhir)
				$brace_count = 0;
				$json_end = -1;
				for($i = 0; $i < strlen($remaining); $i++) {
					if($remaining[$i] == '{') $brace_count++;
					if($remaining[$i] == '}') {
						$brace_count--;
						if($brace_count == 0) {
							$json_end = $i + 1;
							break;
						}
					}
				}
				
				if($json_end > 0) {
					$json_string = substr($remaining, 0, $json_end);
				}
			}
			
			if($json_string) {
				// Bersihkan whitespace di awal dan akhir
				$json_string = trim($json_string);
				
				// Decode JSON
				$json_data = json_decode($json_string, true);
				
				// Log untuk debugging (opsional)
				if($json_data === null && json_last_error() !== JSON_ERROR_NONE) {
					log_message('debug', 'JSON decode error: ' . json_last_error_msg() . ' | String: ' . substr($json_string, 0, 200));
				}
				
				if($json_data && isset($json_data['items']) && is_array($json_data['items']) && count($json_data['items']) > 0) {
					// Convert array ke object untuk kompatibilitas
					$items = array();
					foreach($json_data['items'] as $item) {
						// Skip ongkir dari display (sudah termasuk di total)
						if(isset($item['id_produk']) && ($item['id_produk'] == 'ONGKIR' || $item['id_produk'] === 'ONGKIR')) {
							continue;
						}
						
						$obj = new stdClass();
						$obj->id_produk = isset($item['id_produk']) ? $item['id_produk'] : '';
						$obj->nama_produk = isset($item['nama_produk']) ? $item['nama_produk'] : 'Produk';
						$obj->harga = isset($item['harga']) ? (float)$item['harga'] : 0;
						$obj->qty = isset($item['qty']) ? (int)$item['qty'] : 1;
						$obj->subtotal = isset($item['subtotal']) ? (float)$item['subtotal'] : ($obj->harga * $obj->qty);
						$obj->gambar_produk = isset($item['gambar_produk']) ? $item['gambar_produk'] : '';
						$obj->foto_produk = isset($item['gambar_produk']) ? $item['gambar_produk'] : (isset($item['foto_produk']) ? $item['foto_produk'] : '');
						
						// Ambil kategori jika ada id_kategori
						if(isset($item['id_kategori']) && $item['id_kategori'] > 0) {
							$this->db->select('nama_kategori');
							$this->db->where('id_kategori', $item['id_kategori']);
							$kategori = $this->db->get('kategori')->row();
							$obj->nama_kategori = $kategori ? $kategori->nama_kategori : '';
						} else {
							$obj->nama_kategori = '';
						}
						
						$items[] = $obj;
					}
					
					// Return sebagai query result object (compatible dengan CodeIgniter)
					// Buat object yang mirip dengan CI_DB_result
					$query_result = new stdClass();
					$query_result->result_array = array();
					$query_result->result = $items; // $items sudah berupa array of objects
					
					// Simpan num_rows sebagai property (bukan method)
					$query_result->num_rows = count($items);
					
					return $query_result;
				}
			}
		}
		
		// Return empty result
		$this->db->from('produk');
		$this->db->where('1', '0');
		return $this->db->get();
	}

	public function insert($data)
	{
		return $this->db->insert('transaksi', $data);
	}
}

