<style type="text/css">
	.login-container {
		max-width: 450px;
		margin: 40px auto;
		padding: 0 20px;
	}

	.login-box {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		overflow: hidden;
	}

	.login-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 30px;
		text-align: center;
	}

	.login-header h2 {
		margin: 0 0 10px 0;
		font-size: 28px;
		font-weight: 700;
	}

	.login-header p {
		margin: 0;
		opacity: 0.9;
	}

	.login-form {
		padding: 30px;
	}

	.form-group {
		margin-bottom: 20px;
	}

	.form-group label {
		display: block;
		font-weight: 500;
		color: #333;
		margin-bottom: 8px;
		font-size: 14px;
	}

	.form-group input {
		width: 100%;
		padding: 12px 15px;
		border: 2px solid #e0e0e0;
		border-radius: 8px;
		font-size: 14px;
		font-family: 'Poppins', sans-serif;
		transition: all 0.3s;
		box-sizing: border-box;
	}

	.form-group input:focus {
		outline: none;
		border-color: #d4af37;
		box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
	}

	.btn-login {
		width: 100%;
		padding: 14px;
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		border: none;
		border-radius: 8px;
		font-size: 16px;
		font-weight: 600;
		cursor: pointer;
		transition: all 0.3s;
		font-family: 'Poppins', sans-serif;
	}

	.btn-login:hover {
		transform: translateY(-2px);
		box-shadow: 0 5px 20px rgba(212, 175, 55, 0.4);
	}

	.login-footer {
		text-align: center;
		padding: 20px 30px 30px;
		border-top: 1px solid #f0f0f0;
	}

	.login-footer p {
		margin: 0;
		color: #666;
		font-size: 14px;
	}

	.login-footer a {
		color: #d4af37;
		text-decoration: none;
		font-weight: 600;
	}

	.login-footer a:hover {
		text-decoration: underline;
	}

	.alert {
		padding: 15px 20px;
		border-radius: 8px;
		margin-bottom: 20px;
		font-size: 14px;
	}

	.alert-error {
		background: #f8d7da;
		color: #721c24;
		border: 1px solid #f5c6cb;
	}

	.alert-success {
		background: #d4edda;
		color: #155724;
		border: 1px solid #c3e6cb;
	}

	.error-message {
		color: #dc3545;
		font-size: 12px;
		margin-top: 5px;
	}

	.password-toggle {
		position: relative;
	}

	.password-toggle input {
		padding-right: 45px;
	}

	.password-toggle .toggle-btn {
		position: absolute;
		right: 12px;
		top: 50%;
		transform: translateY(-50%);
		background: none;
		border: none;
		color: #999;
		cursor: pointer;
		font-size: 16px;
	}
</style>

<div class="login-container">
	<div class="login-box">
		<div class="login-header">
			<h2><i class="fas fa-user"></i> Login</h2>
			<p>Masuk ke akun Anda</p>
		</div>

		<div class="login-form">
			<?php if($this->session->flashdata('error')): ?>
				<div class="alert alert-error">
					<i class="fas fa-exclamation-circle"></i>
					<?php echo $this->session->flashdata('error'); ?>
				</div>
			<?php endif; ?>

			<?php if($this->session->flashdata('success')): ?>
				<div class="alert alert-success">
					<i class="fas fa-check-circle"></i>
					<?php echo $this->session->flashdata('success'); ?>
				</div>
			<?php endif; ?>

			<?php echo form_open('akun/login'); ?>
				<div class="form-group">
					<label for="email">Email</label>
					<input type="email" name="email" id="email" value="<?php echo set_value('email'); ?>" placeholder="Masukkan email Anda" required>
					<?php echo form_error('email', '<div class="error-message">', '</div>'); ?>
				</div>

				<div class="form-group">
					<label for="password">Password</label>
					<div class="password-toggle">
						<input type="password" name="password" id="password" placeholder="Masukkan password Anda" required>
						<button type="button" class="toggle-btn" onclick="togglePassword()">
							<i class="fas fa-eye" id="toggle-icon"></i>
						</button>
					</div>
					<?php echo form_error('password', '<div class="error-message">', '</div>'); ?>
				</div>

				<button type="submit" class="btn-login">
					<i class="fas fa-sign-in-alt"></i> Masuk
				</button>
			<?php echo form_close(); ?>
		</div>

		<div class="login-footer">
			<p>Belum punya akun? <a href="<?php echo base_url('register'); ?>">Daftar sekarang</a></p>
		</div>
	</div>
</div>

<script>
	function togglePassword() {
		const passwordInput = document.getElementById('password');
		const toggleIcon = document.getElementById('toggle-icon');
		
		if(passwordInput.type === 'password') {
			passwordInput.type = 'text';
			toggleIcon.classList.remove('fa-eye');
			toggleIcon.classList.add('fa-eye-slash');
		} else {
			passwordInput.type = 'password';
			toggleIcon.classList.remove('fa-eye-slash');
			toggleIcon.classList.add('fa-eye');
		}
	}
</script>

