<style type="text/css">
	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 50px 20px;
		text-align: center;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.page-header h1 {
		font-size: 36px;
		font-weight: 700;
		margin-bottom: 10px;
	}

	.container {
		max-width: 1200px;
		margin: 0 auto;
		padding: 0 20px;
	}

	.checkout-container {
		display: grid;
		grid-template-columns: 1fr 400px;
		gap: 30px;
		margin-bottom: 40px;
	}

	.checkout-form {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		padding: 30px;
	}

	.form-section {
		margin-bottom: 30px;
	}

	.section-title {
		font-size: 20px;
		font-weight: 600;
		color: #333;
		margin-bottom: 20px;
		padding-bottom: 10px;
		border-bottom: 2px solid #e0e0e0;
		display: flex;
		align-items: center;
		gap: 10px;
	}

	.section-title i {
		color: #d4af37;
	}

	.section-title.clickable {
		cursor: pointer;
		user-select: none;
		transition: all 0.3s;
	}

	.section-title.clickable:hover {
		color: #d4af37;
	}

	.section-title.clickable .toggle-icon {
		display: none;
	}

	.form-group {
		margin-bottom: 20px;
	}

	.form-group label {
		display: block;
		font-weight: 500;
		color: #333;
		margin-bottom: 8px;
		font-size: 14px;
	}

	.form-group label .required {
		color: #e74c3c;
	}

	.form-control {
		width: 100%;
		padding: 12px 15px;
		border: 2px solid #e0e0e0;
		border-radius: 8px;
		font-size: 14px;
		font-family: 'Poppins', sans-serif;
		transition: all 0.3s;
		background: white;
	}

	.form-control:focus {
		outline: none;
		border-color: #d4af37;
		box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
	}

	.form-control:disabled {
		background: #f5f5f5;
		cursor: not-allowed;
	}

	.form-group input,
	.form-group textarea,
	.form-group select {
		width: 100%;
		padding: 12px 15px;
		border: 2px solid #e0e0e0;
		border-radius: 8px;
		font-size: 14px;
		font-family: 'Poppins', sans-serif;
		transition: all 0.3s;
	}

	.form-group input:focus,
	.form-group textarea:focus,
	.form-group select:focus {
		outline: none;
		border-color: #d4af37;
		box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
	}

	.form-group textarea {
		resize: vertical;
		min-height: 100px;
	}


	.order-summary {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		padding: 30px;
		position: sticky;
		top: 100px;
		height: fit-content;
	}

	.order-items {
		margin-bottom: 20px;
	}

	.order-item {
		display: flex;
		gap: 15px;
		padding: 15px 0;
		border-bottom: 1px solid #e0e0e0;
	}

	.order-item:last-child {
		border-bottom: none;
	}

	.order-item-image {
		width: 60px;
		height: 60px;
		border-radius: 8px;
		background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
		display: flex;
		align-items: center;
		justify-content: center;
		overflow: hidden;
		flex-shrink: 0;
	}

	.order-item-image img {
		width: 100%;
		height: 100%;
		object-fit: cover;
	}

	.order-item-image i {
		font-size: 24px;
		color: #d4af37;
		opacity: 0.3;
	}

	.order-item-details {
		flex: 1;
	}

	.order-item-name {
		font-size: 14px;
		font-weight: 600;
		color: #333;
		margin-bottom: 5px;
	}

	.order-item-qty {
		font-size: 12px;
		color: #666;
	}

	.order-item-price {
		font-size: 14px;
		font-weight: 600;
		color: #d4af37;
		text-align: right;
	}

	.summary-section {
		margin-top: 20px;
		padding-top: 20px;
		border-top: 2px solid #e0e0e0;
	}

	.summary-row {
		display: flex;
		justify-content: space-between;
		margin-bottom: 15px;
		font-size: 14px;
	}

	.summary-label {
		color: #666;
	}

	.summary-value {
		font-weight: 600;
		color: #333;
	}

	.summary-total {
		display: flex;
		justify-content: space-between;
		margin-top: 20px;
		padding-top: 20px;
		border-top: 2px solid #e0e0e0;
		font-size: 18px;
		font-weight: 700;
	}

	.summary-total-label {
		color: #333;
	}

	.summary-total-value {
		color: #d4af37;
	}

	.btn-submit {
		width: 100%;
		padding: 15px;
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		border: none;
		border-radius: 8px;
		font-size: 16px;
		font-weight: 700;
		cursor: pointer;
		transition: all 0.3s;
		display: flex;
		align-items: center;
		justify-content: center;
		gap: 10px;
		margin-top: 20px;
	}

	.btn-submit:hover {
		transform: translateY(-2px);
		box-shadow: 0 5px 20px rgba(212, 175, 55, 0.4);
		background: linear-gradient(135deg, #2c3e5e 0%, #1a1f3a 100%);
	}

	.error-message {
		color: #e74c3c;
		font-size: 12px;
		margin-top: 5px;
	}

	@media (max-width: 968px) {
		.checkout-container {
			grid-template-columns: 1fr;
		}

		.order-summary {
			position: static;
		}
	}
</style>

<div class="page-header">
	<h1><i class="fas fa-shopping-bag"></i> Checkout</h1>
	<p>Lengkapi informasi pengiriman dan pembayaran</p>
</div>

<div class="container">
	<?php if(!empty($keranjang)): ?>
		<div class="checkout-container">
			<div class="checkout-form">
				<?php echo form_open('checkout/proses'); ?>
					
					<div class="form-section">
						<div class="section-title">
							<i class="fas fa-map-marker-alt"></i>
							Alamat Pengiriman
						</div>
						
						<div class="form-group">
							<label>Nama Penerima <span class="required">*</span></label>
							<input type="text" name="nama_penerima" value="<?php echo isset($customer->nama_customer) ? htmlspecialchars($customer->nama_customer) : ''; ?>" required>
						</div>

						<div class="form-group">
							<label>Alamat Lengkap <span class="required">*</span></label>
							<textarea name="alamat_pengiriman" required><?php echo isset($customer->alamat_customer) ? htmlspecialchars($customer->alamat_customer) : ''; ?></textarea>
						</div>

						<div class="form-group">
							<label>Telepon/HP <span class="required">*</span></label>
							<input type="text" name="telepon_pengiriman" value="<?php echo isset($customer->telp_customer) ? htmlspecialchars($customer->telp_customer) : ''; ?>" required>
						</div>

						<div class="form-group">
							<label>Provinsi <span class="required">*</span></label>
							<select name="provinsi" id="provinsi" class="form-control" required onchange="loadKota()">
								<option value="">Pilih Provinsi</option>
								<?php if(isset($provinsi) && !empty($provinsi) && is_array($provinsi)): ?>
									<?php 
									usort($provinsi, function($a, $b) {
										return strcmp($a['province'], $b['province']);
									});
									foreach($provinsi as $p): 
										if(isset($p['province_id']) && isset($p['province'])):
									?>
										<option value="<?php echo $p['province_id']; ?>"><?php echo htmlspecialchars($p['province']); ?></option>
									<?php 
										endif;
									endforeach; 
									?>
								<?php else: ?>
									<option value="" disabled>Gagal memuat data provinsi</option>
								<?php endif; ?>
							</select>
							<?php if(isset($rajaongkir_error) && $rajaongkir_error === true): ?>
								<div id="rajaongkir-error-box" style="background: #fff3cd; border: 1px solid #ffc107; border-radius: 8px; padding: 15px; margin-top: 10px;">
									<div style="color: #856404; font-weight: 600; margin-bottom: 8px;">
										<i class="fas fa-exclamation-triangle"></i> Gagal Memuat Data Provinsi
									</div>
									<div id="rajaongkir-error-text" style="color: #856404; font-size: 13px;">
										<?php echo isset($rajaongkir_error_msg) ? $rajaongkir_error_msg : 'Pastikan API Key Raja Ongkir sudah benar.'; ?>
									</div>
									<div style="margin-top:10px; display:flex; gap:8px;">
										<button type="button" id="rajaongkir-check-btn" class="btn" style="background:#ffc107; border:none; padding:8px 12px; border-radius:6px; cursor:pointer;">Coba Lagi</button>
										<button type="button" id="rajaongkir-help-btn" class="btn" style="background:#eee; border:1px solid #ddd; padding:8px 12px; border-radius:6px; cursor:pointer;">Petunjuk Perbaikan</button>
									</div>
								</div>
								<script>
									document.getElementById('rajaongkir-check-btn').addEventListener('click', function() {
										var btn = this;
										btn.disabled = true;
										var original = btn.innerText;
										btn.innerText = 'Memeriksa...';
										fetch('<?php echo base_url("checkout/check_rajaongkir"); ?>')
										.then(resp => resp.json())
										.then(data => {
											if (data.status === 'ok') {
												document.getElementById('rajaongkir-error-box').style.background = '#d4edda';
												document.getElementById('rajaongkir-error-text').style.color = '#155724';
												document.getElementById('rajaongkir-error-text').innerText = data.message;
												setTimeout(function(){ location.reload(); }, 1200);
											} else {
												document.getElementById('rajaongkir-error-text').innerText = data.message || 'Gagal memeriksa koneksi RajaOngkir';
											}
										})
										.catch(err => {
											console.error('check_rajaongkir failed', err);
											document.getElementById('rajaongkir-error-text').innerText = 'Terjadi kesalahan saat memeriksa: ' + err.message;
										})
										.finally(() => { btn.disabled = false; btn.innerText = original; });
									});

									document.getElementById('rajaongkir-help-btn').addEventListener('click', function(){
										var help = 'Langkah perbaikan:\n1) Isi API Key di application/config/rajaongkir.php\n2) Jika API starter deprecated, ubah $config["rajaongkir_account_type"] menjadi "basic" atau "pro" sesuai akun Anda.\n3) Jika masih gagal, jalankan test: /customer/test_rajaongkir.php dan cek logs di customer/application/logs/';
										alert(help);
									});
								</script>
							<?php endif; ?>
						</div>

						<div class="form-group">
							<label>Kota/Kabupaten <span class="required">*</span></label>
							<select name="kota" id="kota" class="form-control" required onchange="loadKurir()" disabled>
								<option value="">Pilih Provinsi terlebih dahulu</option>
							</select>
						</div>

						<?php if(!isset($use_manual_ongkir) || $use_manual_ongkir === false): ?>
							<div class="form-group">
								<label>Kurir <span class="required">*</span></label>
								<select name="kurir" id="kurir" class="form-control" required onchange="hitungOngkir()" disabled>
									<option value="">Pilih Kota terlebih dahulu</option>
									<option value="jne">JNE</option>
									<option value="pos">POS Indonesia</option>
									<option value="tiki">TIKI</option>
								</select>
							</div>

							<div class="form-group" id="layanan-group" style="display: none;">
								<label>Layanan Pengiriman <span class="required">*</span></label>
								<div id="layanan-options"></div>
							</div>
						<?php else: ?>
							<input type="hidden" name="kurir" value="manual">
						<?php endif; ?>

						<input type="hidden" name="ongkir" id="ongkir-value" value="0">
						<input type="hidden" name="origin_city" id="origin-city" value="<?php echo isset($origin_city_id) ? $origin_city_id : 152; ?>">
					</div>

					<div class="form-section">
						<div class="section-title">
							<i class="fas fa-truck"></i>
							Ongkos Kirim
						</div>
						<?php if(isset($use_manual_ongkir) && $use_manual_ongkir === true): ?>
							<!-- Input Manual Ongkir -->
							<div class="form-group">
								<label>Ongkos Kirim (Rp) <span class="required">*</span></label>
								<input type="number" name="ongkir_manual" id="ongkir-manual" class="form-control" min="0" value="0" required onchange="updateOngkirManual()">
								<small style="color: #666; margin-top: 5px; display: block;">
									<i class="fas fa-info-circle"></i> Masukkan ongkos kirim secara manual. Admin akan mengkonfirmasi ongkir yang sebenarnya.
								</small>
							</div>
							<div id="ongkir-display" style="padding: 15px; background: #fff3cd; border: 1px solid #ffc107; border-radius: 8px; color: #856404; margin-top: 10px;">
								<i class="fas fa-exclamation-triangle"></i> <strong>Mode Manual:</strong> Ongkir akan dikonfirmasi oleh admin setelah pesanan diterima.
							</div>
						<?php else: ?>
							<!-- Auto Calculate Ongkir -->
							<div id="ongkir-display" style="padding: 20px; background: #f8f9fa; border-radius: 8px; text-align: center; color: #666;">
								<i class="fas fa-info-circle"></i> Pilih provinsi, kota, dan kurir untuk menghitung ongkir
							</div>
						<?php endif; ?>
					</div>

					<!-- Hidden field untuk metode pembayaran (default: midtrans) -->
					<input type="hidden" name="metode_pembayaran" id="metode_pembayaran" value="midtrans">
					<input type="hidden" name="payment_detail" id="payment_detail" value="Midtrans Payment Gateway">

					<button type="submit" class="btn-submit" id="btn-submit-checkout">
						<i class="fas fa-check-circle"></i>
						<span id="btn-text">Buat Pesanan</span>
						<span id="btn-loading" style="display: none;">
							<i class="fas fa-spinner fa-spin"></i> Memproses...
						</span>
					</button>
				<?php echo form_close(); ?>
			</div>

			<div class="order-summary">
				<div class="section-title">
					<i class="fas fa-shopping-cart"></i>
					Ringkasan Pesanan
				</div>

				<div class="order-items">
					<?php foreach($keranjang as $item): ?>
						<div class="order-item">
							<div class="order-item-image">
								<?php
								$gambar = isset($item->gambar_produk) ? $item->gambar_produk : (isset($item->foto_produk) ? $item->foto_produk : (isset($item->gambar) ? $item->gambar : ''));
								if(!empty($gambar)):
									$image_path = 'http://localhost/gerabah/admin/uploads/produk/'.$gambar;
								?>
									<img src="<?php echo $image_path; ?>" alt="<?php echo isset($item->nama_produk) ? htmlspecialchars($item->nama_produk) : 'Produk'; ?>" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
									<i class="fas fa-image" style="display: none;"></i>
								<?php else: ?>
									<i class="fas fa-image"></i>
								<?php endif; ?>
							</div>
							<div class="order-item-details">
								<div class="order-item-name"><?php echo isset($item->nama_produk) ? htmlspecialchars($item->nama_produk) : 'Nama Produk'; ?></div>
								<?php if(isset($item->ukuran) && !empty($item->ukuran)): ?>
									<div class="order-item-size" style="font-size: 11px; color: #666; margin-bottom: 3px;">
										Ukuran: <strong><?php echo htmlspecialchars($item->ukuran); ?></strong>
									</div>
								<?php endif; ?>
								<div class="order-item-qty">Qty: <?php echo isset($item->qty) ? $item->qty : 1; ?></div>
							</div>
							<div class="order-item-price">
								<?php 
								$harga = isset($item->harga) && $item->harga > 0 ? $item->harga : 0;
								$qty = isset($item->qty) ? $item->qty : 1;
								
								// Cek apakah ada diskon (property ditambahkan di controller)
								if(isset($item->diskon_persen) && $item->diskon_persen > 0) {
									$harga_asli = isset($item->harga_asli) ? $item->harga_asli : 0;
									?>
									<div style="font-size: 11px; color: #999; text-decoration: line-through; text-align: right;">
										Rp <?php echo number_format($harga_asli * $qty, 0, ',', '.'); ?>
									</div>
									<div style="color: #ff424e; font-weight: bold;">
										Rp <?php echo number_format($harga * $qty, 0, ',', '.'); ?>
									</div>
									<?php
								} else {
									echo 'Rp ' . number_format($harga * $qty, 0, ',', '.'); 
								}
								?>
							</div>
						</div>
					<?php endforeach; ?>
				</div>

				<div class="summary-section">
					<div class="summary-row">
						<span class="summary-label">Subtotal</span>
						<span class="summary-value" id="summary-subtotal">Rp <?php echo number_format($subtotal, 0, ',', '.'); ?></span>
					</div>
					<div class="summary-row">
						<span class="summary-label">Ongkir</span>
						<span class="summary-value" id="summary-ongkir">Rp <?php echo number_format($ongkir, 0, ',', '.'); ?></span>
					</div>
					<div class="summary-total">
						<span class="summary-total-label">Total</span>
						<span class="summary-total-value" id="summary-total">Rp <?php echo number_format($total, 0, ',', '.'); ?></span>
					</div>
				</div>
			</div>
		</div>
	<?php else: ?>
		<div style="text-align: center; padding: 60px 20px; background: white; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.1);">
			<i class="fas fa-shopping-cart" style="font-size: 64px; color: #2c3e5e; margin-bottom: 20px; opacity: 0.3;"></i>
			<h3 style="color: #333; margin-bottom: 10px;">Keranjang Anda Kosong</h3>
			<p style="color: #666; margin-bottom: 30px;">Silakan tambahkan produk ke keranjang terlebih dahulu</p>
			<a href="<?php echo base_url('keranjang'); ?>" style="display: inline-block; padding: 12px 30px; background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%); color: #1a1f3a; text-decoration: none; border-radius: 8px; font-weight: 700;">
				<i class="fas fa-arrow-left"></i> Kembali ke Keranjang
			</a>
		</div>
	<?php endif; ?>
</div>

<script>

	// Load kota
	function loadKota() {
		const provinsiId = document.getElementById('provinsi').value;
		const kotaSelect = document.getElementById('kota');
		const kurirSelect = document.getElementById('kurir');
		
		if (!provinsiId) {
			kotaSelect.innerHTML = '<option value="">Pilih Provinsi terlebih dahulu</option>';
			kotaSelect.disabled = true;
			kurirSelect.disabled = true;
			return;
		}
		
		kotaSelect.innerHTML = '<option value="">Memuat...</option>';
		kotaSelect.disabled = true;
		
		fetch('<?php echo base_url("checkout/get_kota"); ?>?provinsi=' + provinsiId)
			.then(response => {
				if (!response.ok) throw new Error('Network response was not ok: ' + response.status);
				return response.json();
			})
			.then(data => {
				if (data.status === 'success' && data.data) {
					kotaSelect.innerHTML = '<option value="">Pilih Kota/Kabupaten</option>';
					data.data.forEach(function(kota) {
						const option = document.createElement('option');
						option.value = kota.city_id;
						option.textContent = (kota.type || '') + ' ' + kota.city_name;
						kotaSelect.appendChild(option);
					});
					kotaSelect.disabled = false;
				} else {
					console.error('get_kota error:', data.message || data);
					kotaSelect.innerHTML = '<option value="">Gagal memuat data: ' + (data.message ? data.message : 'Unknown') + '</option>';
				}
			})
			.catch(error => {
				console.error('Fetch get_kota failed:', error);
				kotaSelect.innerHTML = '<option value="">Error memuat data</option>';
			});
	}

	function loadKurir() {
		const kotaId = document.getElementById('kota').value;
		const kurirSelect = document.getElementById('kurir');
		
		if (kotaId) {
			kurirSelect.disabled = false;
		}
	}

	function hitungOngkir() {
		const origin = document.getElementById('origin-city').value;
		const destination = document.getElementById('kota').value;
		const courier = document.getElementById('kurir').value;
		
		if (!origin || !destination || !courier) return;
		
		document.getElementById('ongkir-display').innerHTML = '<i class="fas fa-spinner fa-spin"></i> Menghitung...';
		
		const formData = new FormData();
		formData.append('origin', origin);
		formData.append('destination', destination);
		formData.append('weight', 1000);
		formData.append('courier', courier);
		
		fetch('<?php echo base_url("checkout/hitung_ongkir"); ?>', {
			method: 'POST',
			body: formData
		})
		.then(response => {
			if (!response.ok) throw new Error('Network response was not ok: ' + response.status);
			return response.json();
		})
		.then(data => {
			if (data.status === 'success') {
				const layananGroup = document.getElementById('layanan-group');
				const layananOptions = document.getElementById('layanan-options');
				layananOptions.innerHTML = '';
				
				data.data.forEach(function(layanan) {
					const div = document.createElement('div');
					div.style.cssText = 'padding: 15px; margin-bottom: 10px; border: 2px solid #e0e0e0; border-radius: 8px; cursor: pointer; transition: all 0.3s;';
					div.onclick = function() { selectLayanan(layanan.cost, layanan.service, layanan.etd, this); };
					div.innerHTML = '<div style="display: flex; justify-content: space-between;"><div><strong>' + layanan.service + '</strong><div style="font-size: 12px; color: #666;">Est. ' + (layanan.etd || '-') + ' hari</div></div><div style="font-weight: 700; color: #d4af37;">Rp ' + formatNumber(layanan.cost) + '</div></div>';
					layananOptions.appendChild(div);
				});
				
				layananGroup.style.display = 'block';
				document.getElementById('ongkir-display').innerHTML = '<i class="fas fa-check-circle" style="color: #28a745;"></i> Pilih layanan pengiriman';
			} else if (data.status === 'api_unavailable' || data.manual_mode === true) {
				// API tidak tersedia, tampilkan input manual
				showManualOngkirInput(data.message || 'Silakan masukkan ongkir secara manual');
			} else {
				console.error('hitung_ongkir error:', data.message || data);
				document.getElementById('ongkir-display').innerHTML = '<i class="fas fa-times-circle" style="color: #dc3545;"></i> ' + (data.message ? data.message : 'Gagal menghitung ongkir');
			}
		})
		.catch(error => {
			console.error('Fetch hitung_ongkir failed:', error);
			showManualOngkirInput('Gagal menghubungi server. Silakan masukkan ongkir secara manual.');
		});
	}

	function selectLayanan(cost, service, etd, element) {
		document.querySelectorAll('#layanan-options > div').forEach(function(el) {
			el.style.borderColor = '#e0e0e0';
			el.style.background = 'white';
		});
		element.style.borderColor = '#d4af37';
		element.style.background = '#fff9e6';
		
		document.getElementById('ongkir-value').value = cost;
		document.getElementById('ongkir-display').innerHTML = '<strong>' + service + '</strong> - Rp ' + formatNumber(cost);
		
		const subtotal = <?php echo $subtotal; ?>;
		document.getElementById('summary-ongkir').textContent = 'Rp ' + formatNumber(cost);
		document.getElementById('summary-total').textContent = 'Rp ' + formatNumber(subtotal + cost);
	}

	function showManualOngkirInput(message) {
		const ongkirDisplay = document.getElementById('ongkir-display');
		const ongkirSection = ongkirDisplay ? ongkirDisplay.closest('.form-section') : null;
		
		if (!ongkirSection) {
			console.error('Ongkir section not found');
			return;
		}
		
		// Cek apakah input manual sudah ada
		let manualInput = document.getElementById('ongkir-manual');
		if (!manualInput) {
			// Buat input manual jika belum ada
			const formGroup = document.createElement('div');
			formGroup.className = 'form-group';
			formGroup.style.marginTop = '15px';
			formGroup.innerHTML = `
				<label>Ongkos Kirim (Rp) <span class="required">*</span></label>
				<input type="number" name="ongkir_manual" id="ongkir-manual" class="form-control" min="0" value="0" required onchange="updateOngkirManual()">
				<small style="color: #666; margin-top: 5px; display: block;">
					<i class="fas fa-info-circle"></i> Masukkan ongkos kirim secara manual. Admin akan mengkonfirmasi ongkir yang sebenarnya.
				</small>
			`;
			// Insert sebelum ongkir-display
			if (ongkirDisplay) {
				ongkirSection.insertBefore(formGroup, ongkirDisplay);
			} else {
				ongkirSection.appendChild(formGroup);
			}
		} else {
			// Tampilkan input manual yang sudah ada
			const manualGroup = manualInput.closest('.form-group');
			if (manualGroup) {
				manualGroup.style.display = 'block';
			}
		}
		
		// Update display message
		if (ongkirDisplay) {
			ongkirDisplay.innerHTML = '<div style="padding: 15px; background: #fff3cd; border: 1px solid #ffc107; border-radius: 8px; color: #856404;"><i class="fas fa-exclamation-triangle"></i> <strong>Mode Manual:</strong> ' + message + '</div>';
		}
		
		// Sembunyikan layanan group jika ada
		const layananGroup = document.getElementById('layanan-group');
		if (layananGroup) {
			layananGroup.style.display = 'none';
		}
		
		// Update ongkir value ke 0 sebagai default
		updateOngkirManual();
	}

	function updateOngkirManual() {
		const ongkirManual = parseFloat(document.getElementById('ongkir-manual').value) || 0;
		document.getElementById('ongkir-value').value = ongkirManual;
		
		const subtotal = <?php echo $subtotal; ?>;
		if (document.getElementById('summary-ongkir')) {
			document.getElementById('summary-ongkir').textContent = 'Rp ' + formatNumber(ongkirManual);
		}
		if (document.getElementById('summary-total')) {
			document.getElementById('summary-total').textContent = 'Rp ' + formatNumber(subtotal + ongkirManual);
		}
	}

	function formatNumber(num) {
		return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
	}

	// Inisialisasi ongkir manual jika mode manual aktif
	<?php if(isset($use_manual_ongkir) && $use_manual_ongkir === true): ?>
	document.addEventListener('DOMContentLoaded', function() {
		updateOngkirManual();
	});
	<?php endif; ?>

	// Load Midtrans Snap JS - Pastikan dimuat sebelum form submit
	// Load Midtrans Snap JS script immediately when page loads
	(function() {
		// Cek apakah script sudah ada
		if (document.querySelector('script[src*="midtrans.com/snap"]')) {
			console.log('Midtrans Snap JS already loaded');
			// Pastikan snap object tersedia
			if (typeof snap !== 'undefined' && snap.pay) {
				console.log('Midtrans snap object is ready');
				window.midtransReady = true;
			}
			return;
		}
		
		var script = document.createElement('script');
		script.type = 'text/javascript';
		script.src = '<?php 
			$is_production = isset($midtrans_is_production) ? $midtrans_is_production : false;
			echo ($is_production) ? "https://app.midtrans.com/snap/snap.js" : "https://app.sandbox.midtrans.com/snap/snap.js";
		?>';
		script.setAttribute('data-client-key', '<?php echo isset($midtrans_client_key) ? $midtrans_client_key : ''; ?>');
		script.async = true;
		script.onload = function() {
			console.log('Midtrans Snap JS loaded successfully');
			// Tunggu sebentar untuk memastikan snap object sudah diinisialisasi
			setTimeout(function() {
				if (typeof snap !== 'undefined' && snap.pay) {
					console.log('Midtrans snap object is ready');
					window.midtransReady = true;
					// Trigger custom event
					window.dispatchEvent(new Event('midtransReady'));
				} else {
					console.warn('Midtrans snap object not found after script load');
				}
			}, 100);
		};
		script.onerror = function() {
			console.error('Failed to load Midtrans Snap JS');
			window.midtransReady = false;
		};
		document.head.appendChild(script);
	})();

	// Handle form submission dengan AJAX
	document.addEventListener('DOMContentLoaded', function() {
		const checkoutForm = document.querySelector('form[action*="checkout/proses"]');
		if (!checkoutForm) return;

		checkoutForm.addEventListener('submit', function(e) {
			e.preventDefault();
			
			// Set metode pembayaran ke midtrans (default)
			document.getElementById('metode_pembayaran').value = 'midtrans';
			document.getElementById('payment_detail').value = 'Midtrans Payment Gateway';

			// Disable button dan show loading
			const btnSubmit = document.getElementById('btn-submit-checkout');
			const btnText = document.getElementById('btn-text');
			const btnLoading = document.getElementById('btn-loading');
			
			btnSubmit.disabled = true;
			btnText.style.display = 'none';
			btnLoading.style.display = 'inline';

			// Ambil semua form data
			const formData = new FormData(checkoutForm);
			
			// Tambahkan selected_items dari keranjang (semua item yang ditampilkan)
			<?php if(isset($keranjang) && !empty($keranjang)): ?>
			const selectedItems = [<?php 
				$item_ids = array();
				foreach($keranjang as $item) {
					if(isset($item->id_keranjang)) {
						$item_ids[] = $item->id_keranjang;
					}
				}
				echo !empty($item_ids) ? implode(',', $item_ids) : '';
			?>];
			if (selectedItems.length > 0) {
				selectedItems.forEach(function(id) {
					formData.append('selected_items[]', id);
				});
			}
			<?php endif; ?>

			// Submit via AJAX
			fetch('<?php echo base_url("checkout/proses"); ?>', {
				method: 'POST',
				body: formData,
				headers: {
					'X-Requested-With': 'XMLHttpRequest'
				}
			})
			.then(async response => {
				// Cek jika response OK
				if (!response.ok) {
					// Coba baca response text untuk error detail
					const text = await response.text();
					console.error('Server error response:', text);
					throw new Error('Server error: ' + response.status);
				}
				
				// Cek content type
				const contentType = response.headers.get("content-type");
				if (contentType && contentType.includes("application/json")) {
					return response.json();
				} else {
					// Jika bukan JSON, coba parse sebagai text
					const text = await response.text();
					console.error('Response is not JSON:', text);
					
					// Jika bukan JSON, mungkin redirect
					if (response.redirected) {
						window.location.href = response.url;
						return;
					}
					throw new Error('Response is not JSON: ' + text.substring(0, 100));
				}
			})
			.then(data => {
				if (!data) {
					throw new Error('No data received');
				}
				
				console.log('Checkout response:', data);
				
				if (data && data.status === 'success' && data.snap_token) {
					console.log('Snap token received:', data.snap_token.substring(0, 20) + '...');
					
					// Fungsi untuk membuka popup Midtrans
					function openMidtransPopup(snapToken) {
						if (typeof snap !== 'undefined' && snap && typeof snap.pay === 'function') {
							try {
								console.log('Opening Midtrans popup with token:', snapToken.substring(0, 20) + '...');
								snap.pay(snapToken, {
									onSuccess: function(result) {
										console.log('Payment success:', result);
										window.location.href = '<?php echo base_url("checkout/finish"); ?>?order_id=' + result.order_id;
									},
									onPending: function(result) {
										console.log('Payment pending:', result);
										window.location.href = '<?php echo base_url("checkout/unfinish"); ?>?order_id=' + result.order_id;
									},
									onError: function(result) {
										console.log('Payment error:', result);
										window.location.href = '<?php echo base_url("checkout/error"); ?>?order_id=' + result.order_id;
									},
									onClose: function() {
										console.log('Payment popup closed');
										btnSubmit.disabled = false;
										btnText.style.display = 'inline';
										btnLoading.style.display = 'none';
									}
								});
								return true;
							} catch (error) {
								console.error('Error calling snap.pay:', error);
								return false;
							}
						}
						return false;
					}
					
					// Coba buka popup langsung
					if (openMidtransPopup(data.snap_token)) {
						console.log('Midtrans popup opened successfully');
						return;
					}
					
					// Jika snap belum ready, tunggu dengan retry
					console.log('Midtrans snap not ready, waiting...');
					let retryCount = 0;
					const maxRetries = 20; // Increase retries
					const retryInterval = setInterval(function() {
						retryCount++;
						console.log('Waiting for Midtrans Snap script... (' + retryCount + '/' + maxRetries + ')');
						
						if (openMidtransPopup(data.snap_token)) {
							console.log('Midtrans popup opened after retry');
							clearInterval(retryInterval);
						} else if (retryCount >= maxRetries) {
							clearInterval(retryInterval);
							console.error('Failed to open Midtrans popup after ' + maxRetries + ' retries');
							alert('Gagal memuat halaman pembayaran. Silakan refresh halaman dan coba lagi.');
							btnSubmit.disabled = false;
							btnText.style.display = 'inline';
							btnLoading.style.display = 'none';
						}
					}, 300); // Reduce interval to 300ms for faster retry
					
					// Also listen for midtransReady event
					window.addEventListener('midtransReady', function() {
						console.log('Midtrans ready event received');
						if (openMidtransPopup(data.snap_token)) {
							clearInterval(retryInterval);
						}
					}, { once: true });
					
				} else if (data && data.status === 'error') {
					// Error dari server
					const errorMsg = data.message || 'Terjadi kesalahan saat memproses checkout. Silakan coba lagi.';
					
					// Tampilkan error message yang lebih user-friendly
					const errorDiv = document.createElement('div');
					errorDiv.style.cssText = 'position: fixed; top: 20px; left: 50%; transform: translateX(-50%); background: #f8d7da; color: #721c24; padding: 15px 20px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.15); z-index: 10000; max-width: 500px; text-align: center;';
					errorDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + errorMsg.replace(/\n/g, '<br>');
					document.body.appendChild(errorDiv);
					
					// Hapus error message setelah 5 detik
					setTimeout(function() {
						errorDiv.remove();
					}, 5000);
					
					btnSubmit.disabled = false;
					btnText.style.display = 'inline';
					btnLoading.style.display = 'none';
				} else {
					// Response tidak valid
					console.error('Invalid response:', data);
					alert('Terjadi kesalahan saat memproses checkout. Silakan refresh halaman dan coba lagi.');
					btnSubmit.disabled = false;
					btnText.style.display = 'inline';
					btnLoading.style.display = 'none';
				}
			})
			.catch(error => {
				console.error('Checkout error:', error);
				console.error('Error details:', error.message);
				
				// Tampilkan error message yang lebih informatif
				let errorMsg = 'Terjadi kesalahan saat memproses checkout.';
				
				if (error.message.includes('JSON')) {
					errorMsg += '\n\nKemungkinan ada masalah dengan server. Silakan refresh halaman dan coba lagi.';
				} else if (error.message.includes('Network')) {
					errorMsg += '\n\nKoneksi ke server terputus. Periksa koneksi internet Anda.';
				} else {
					errorMsg += '\n\n' + error.message;
				}
				
				alert(errorMsg);
				btnSubmit.disabled = false;
				btnText.style.display = 'inline';
				btnLoading.style.display = 'none';
			});
		});
	});
</script>
