<!DOCTYPE html>
<html lang="id">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?php echo isset($title) ? $title : 'Giska Keramik'; ?></title>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
	
	<style type="text/css">
		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		body {
			font-family: 'Poppins', sans-serif;
			background-color: #f8f9fa;
			color: #333;
			line-height: 1.6;
		}

		/* Navbar */
		.navbar {
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			padding: 15px 0;
			box-shadow: 0 4px 20px rgba(0,0,0,0.25);
			position: sticky;
			top: 0;
			z-index: 1000;
			border-bottom: 2px solid rgba(212, 175, 55, 0.2);
		}

	.navbar-container {
		max-width: 1400px;
		margin: 0 auto;
		padding: 0 20px;
		display: flex;
		justify-content: space-between;
		align-items: center;
		gap: 30px;
	}

	.logo {
		font-size: 24px;
		font-weight: 700;
		color: white;
		text-decoration: none;
		display: flex;
		align-items: center;
		gap: 10px;
		transition: all 0.3s ease;
		flex-shrink: 0;
	}

	.logo:hover {
		opacity: 0.9;
	}

	.logo i {
		font-size: 28px;
	}

	.nav-menu {
		display: flex;
		list-style: none;
		gap: 18px;
		align-items: center;
		flex: 1;
		justify-content: center;
	}

	.nav-menu a {
		color: white;
		text-decoration: none;
		font-weight: 500;
		transition: all 0.3s;
		display: flex;
		align-items: center;
		gap: 6px;
		font-size: 15px;
		white-space: nowrap;
	}

	.nav-menu a:hover {
		opacity: 0.8;
	}

	.nav-menu a i {
		font-size: 15px;
	}

	.user-menu {
		display: flex;
		align-items: center;
		gap: 12px;
		flex-shrink: 0;
	}

	.btn {
		padding: 8px 16px;
		border-radius: 8px;
		text-decoration: none;
		font-weight: 600;
		transition: all 0.3s;
		display: inline-flex;
		align-items: center;
		gap: 6px;
		font-size: 14px;
		white-space: nowrap;
	}

		.btn-outline {
			background: transparent;
			border: 2px solid white;
			color: white;
		}

		.btn-outline:hover {
			background: rgba(212, 175, 55, 0.1);
			border-color: #d4af37;
			color: #d4af37;
		}

		.btn-primary {
			background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
			color: #1a1f3a;
			border: none;
			font-weight: 700;
		}

		.btn-primary:hover {
			background: linear-gradient(135deg, #c9a961 0%, #d4af37 100%);
			transform: translateY(-2px);
			box-shadow: 0 4px 15px rgba(212, 175, 55, 0.4);
		}

	.user-info {
		color: white;
		display: flex;
		align-items: center;
		gap: 8px;
		font-size: 14px;
	}

	.user-info i {
		font-size: 18px;
	}

	.user-info span {
		max-width: 120px;
		overflow: hidden;
		text-overflow: ellipsis;
		white-space: nowrap;
	}

		.mobile-menu-toggle {
			display: none;
			color: white;
			font-size: 24px;
			cursor: pointer;
		}

		/* Notification Styles */
		.notification-wrapper {
			position: relative;
			margin-right: 15px;
			cursor: pointer;
		}

		.notification-icon {
			font-size: 20px;
			color: white;
			position: relative;
		}

		.notification-badge {
			position: absolute;
			top: -8px;
			right: -8px;
			background-color: #ff4757;
			color: white;
			border-radius: 50%;
			padding: 2px 6px;
			font-size: 10px;
			font-weight: bold;
			border: 1px solid white;
		}

		.notification-dropdown {
			position: absolute;
			top: 100%;
			right: 0;
			width: 320px;
			background: white;
			border-radius: 8px;
			box-shadow: 0 5px 20px rgba(0,0,0,0.2);
			display: none;
			z-index: 1001;
			overflow: hidden;
			margin-top: 15px;
		}

		.notification-dropdown.active {
			display: block;
		}

		.notification-header {
			padding: 12px 15px;
			border-bottom: 1px solid #eee;
			display: flex;
			justify-content: space-between;
			align-items: center;
			background: #f8f9fa;
		}

		.notification-header h4 {
			font-size: 14px;
			margin: 0;
			color: #333;
			font-weight: 600;
		}

		.mark-all-read {
			font-size: 11px;
			color: #007bff;
			text-decoration: none;
			font-weight: 500;
		}

		.mark-all-read:hover {
			text-decoration: underline;
		}

		.notification-list {
			max-height: 350px;
			overflow-y: auto;
		}

		.notification-item {
			padding: 12px 15px;
			border-bottom: 1px solid #f0f0f0;
			display: flex;
			gap: 12px;
			transition: background 0.2s;
			text-decoration: none;
			color: #333;
			align-items: flex-start;
		}

		.notification-item:hover {
			background: #f9f9f9;
		}

		.notification-item.unread {
			background: #eef5ff;
		}
		
		.notification-item.unread:hover {
			background: #e6f0ff;
		}

		.notification-icon-status {
			width: 32px;
			height: 32px;
			border-radius: 50%;
			display: flex;
			align-items: center;
			justify-content: center;
			flex-shrink: 0;
			background: #eee;
			color: #555;
		}

		.notification-item.unread .notification-icon-status {
			background: #fff;
			color: #007bff;
			border: 1px solid #cce5ff;
		}

		.notification-content {
			flex: 1;
		}

		.notification-content h5 {
			font-size: 13px;
			margin: 0 0 4px;
			color: #2c3e5e;
			font-weight: 600;
		}

		.notification-content p {
			font-size: 12px;
			margin: 0;
			color: #666;
			line-height: 1.4;
		}

		.notification-time {
			font-size: 10px;
			color: #999;
			margin-top: 6px;
			display: block;
		}

		/* Alert */
		.alert {
			padding: 15px 20px;
			border-radius: 8px;
			margin: 20px auto;
			max-width: 1200px;
			animation: slideDown 0.3s ease-out;
		}

		@keyframes slideDown {
			from {
				opacity: 0;
				transform: translateY(-10px);
			}
			to {
				opacity: 1;
				transform: translateY(0);
			}
		}

		.alert-success {
			background: #d4edda;
			color: #155724;
			border: 2px solid #c3e6cb;
		}

		.alert-danger {
			background: #f8d7da;
			color: #721c24;
			border: 2px solid #f5c6cb;
		}

		/* Responsive */
		@media (max-width: 1200px) {
			.navbar-container {
				max-width: 100%;
			}

			.nav-menu {
				gap: 15px;
			}

			.nav-menu a {
				font-size: 14px;
			}

			.user-info span {
				max-width: 80px;
			}
		}

		@media (max-width: 992px) {
			.logo {
				font-size: 20px;
			}

			.logo i {
				font-size: 24px;
			}

			.mobile-menu-toggle {
				display: block;
			}

			.nav-menu {
				position: fixed;
				left: -100%;
				top: 70px;
				flex-direction: column;
				background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
				width: 100%;
				text-align: center;
				transition: 0.3s;
				box-shadow: 0 10px 27px rgba(0,0,0,0.1);
				padding: 20px 0;
				gap: 0;
			}

			.nav-menu li {
				width: 100%;
			}

			.nav-menu a {
				width: 100%;
				justify-content: center;
				padding: 15px 20px;
			}

			.nav-menu.active {
				left: 0;
			}

			.user-menu {
				flex-direction: column;
				gap: 10px;
			}

			.user-info span {
				max-width: none;
			}
		}
	</style>
</head>
<body>

<nav class="navbar">
	<div class="navbar-container">
		<a href="<?php echo base_url('home'); ?>" class="logo">
			<i class="fas fa-store"></i>
			<span>Giska Keramik</span>
		</a>

		<ul class="nav-menu" id="navMenu">
			<li><a href="<?php echo base_url('home'); ?>"><i class="fas fa-home"></i> Beranda</a></li>
			<li><a href="<?php echo base_url('produk'); ?>"><i class="fas fa-box"></i> Produk</a></li>
			<li><a href="<?php echo base_url('kategori'); ?>"><i class="fas fa-tags"></i> Kategori</a></li>
			<li><a href="<?php echo base_url('keranjang'); ?>"><i class="fas fa-shopping-cart"></i> Keranjang</a></li>
			<?php if(isset($logged_in) && $logged_in): ?>
			<li><a href="<?php echo base_url('transaksi'); ?>"><i class="fas fa-receipt"></i> Transaksi</a></li>
			<li><a href="<?php echo base_url('retur'); ?>"><i class="fas fa-rotate-left"></i> Pengembalian</a></li>
			<?php endif; ?>
		</ul>

		<div class="user-menu">
			<?php if(isset($logged_in) && $logged_in): 
				// Load Notification Logic
				$CI =& get_instance();
				if(!isset($CI->Mnotifikasi)) {
					$CI->load->model('Mnotifikasi');
				}
				$id_customer_sess = $CI->session->userdata('id_customer');
				$unread_count = $CI->Mnotifikasi->get_unread_count($id_customer_sess);
				$notifikasi = $CI->Mnotifikasi->get_by_customer($id_customer_sess, 10)->result();
			?>
				<!-- Notification Bell -->
				<div class="notification-wrapper" onclick="toggleNotification(event)">
					<i class="fas fa-bell notification-icon"></i>
					<?php if($unread_count > 0): ?>
						<span class="notification-badge" id="notifBadge"><?php echo $unread_count; ?></span>
					<?php endif; ?>
					
					<div class="notification-dropdown" id="notificationDropdown">
						<div class="notification-header">
							<h4>Notifikasi</h4>
							<a href="#" class="mark-all-read" onclick="markAllRead(event)">Tandai semua dibaca</a>
						</div>
						<div class="notification-list">
							<?php if(empty($notifikasi)): ?>
								<div class="notification-item">
									<div class="notification-content">
										<p style="text-align: center; color: #999; padding: 10px; margin: 0;">Tidak ada notifikasi</p>
									</div>
								</div>
							<?php else: ?>
								<?php foreach($notifikasi as $notif): ?>
									<a href="<?php echo base_url($notif->link); ?>" class="notification-item <?php echo $notif->is_read ? '' : 'unread'; ?>" onclick="markRead(event, <?php echo $notif->id_notifikasi; ?>, '<?php echo base_url($notif->link); ?>')">
										<div class="notification-icon-status">
											<?php 
												$icon = 'fa-info-circle';
												if(strpos(strtolower($notif->judul), 'disetujui') !== false) $icon = 'fa-check-circle';
												else if(strpos(strtolower($notif->judul), 'ditolak') !== false) $icon = 'fa-times-circle';
												else if(strpos(strtolower($notif->judul), 'selesai') !== false) $icon = 'fa-flag-checkered';
												else if(strpos(strtolower($notif->judul), 'diproses') !== false) $icon = 'fa-cog';
											?>
											<i class="fas <?php echo $icon; ?>"></i>
										</div>
										<div class="notification-content">
											<h5><?php echo $notif->judul; ?></h5>
											<p><?php echo $notif->pesan; ?></p>
											<span class="notification-time"><?php echo date('d M Y H:i', strtotime($notif->created_at)); ?></span>
										</div>
									</a>
								<?php endforeach; ?>
							<?php endif; ?>
						</div>
					</div>
				</div>

				<div class="user-info">
					<i class="fas fa-user-circle"></i>
					<span><?php echo isset($nama_customer) ? $nama_customer : 'Customer'; ?></span>
				</div>
				<a href="<?php echo base_url('akun'); ?>" class="btn btn-outline">
					<i class="fas fa-user"></i> Akun
				</a>
				<a href="<?php echo base_url('logout'); ?>" class="btn btn-outline">
					<i class="fas fa-sign-out-alt"></i> Logout
				</a>
			<?php else: ?>
				<a href="<?php echo base_url('register'); ?>" class="btn btn-outline">
					<i class="fas fa-user-plus"></i> Daftar
				</a>
				<a href="<?php echo base_url('akun'); ?>" class="btn btn-primary">
					<i class="fas fa-sign-in-alt"></i> Login
				</a>
			<?php endif; ?>
		</div>

		<div class="mobile-menu-toggle" onclick="toggleMenu()">
			<i class="fas fa-bars"></i>
		</div>
	</div>
</nav>

<?php if($this->session->flashdata('success')): ?>
	<div class="alert alert-success">
		<i class="fas fa-check-circle"></i>
		<?php echo $this->session->flashdata('success'); ?>
	</div>
<?php endif; ?>

<?php if($this->session->flashdata('error')): ?>
	<div class="alert alert-danger">
		<i class="fas fa-exclamation-circle"></i>
		<?php echo $this->session->flashdata('error'); ?>
	</div>
<?php endif; ?>

<script>
	function toggleMenu() {
		const navMenu = document.getElementById('navMenu');
		navMenu.classList.toggle('active');
	}

	function toggleNotification(event) {
		event.stopPropagation();
		const dropdown = document.getElementById('notificationDropdown');
		dropdown.classList.toggle('active');
	}

	function markRead(event, id, url) {
		event.preventDefault(); 
		event.stopPropagation();
		
		fetch('<?php echo base_url("notifikasi/mark_read/"); ?>' + id)
			.then(response => response.json())
			.then(data => {
				window.location.href = url;
			})
			.catch(err => {
				console.error('Error:', err);
				window.location.href = url; 
			});
	}

	function markAllRead(event) {
		event.preventDefault();
		event.stopPropagation();
		
		fetch('<?php echo base_url("notifikasi/mark_all_read"); ?>')
			.then(response => response.json())
			.then(data => {
				location.reload();
			});
	}

	// Close dropdown when clicking outside
	window.onclick = function(event) {
		if (!event.target.closest('.notification-wrapper')) {
			var dropdowns = document.getElementsByClassName("notification-dropdown");
			for (var i = 0; i < dropdowns.length; i++) {
				var openDropdown = dropdowns[i];
				if (openDropdown.classList.contains('active')) {
					openDropdown.classList.remove('active');
				}
			}
		}
	}

	// Auto-hide alerts after 5 seconds
	setTimeout(function() {
		const alerts = document.querySelectorAll('.alert');
		alerts.forEach(function(alert) {
			alert.style.transition = 'opacity 0.5s';
			alert.style.opacity = '0';
			setTimeout(function() {
				alert.style.display = 'none';
			}, 500);
		});
	}, 5000);
</script>

