<style type="text/css">
	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 50px 20px;
		text-align: center;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.page-header h1 {
		font-size: 36px;
		font-weight: 700;
		margin-bottom: 10px;
	}

	.page-header p {
		font-size: 16px;
		opacity: 0.9;
	}

	.breadcrumb {
		max-width: 1200px;
		margin: 0 auto 20px;
		padding: 0 20px;
	}

	.breadcrumb a {
		color: #d4af37;
		text-decoration: none;
	}

	.breadcrumb a:hover {
		text-decoration: underline;
	}

	.container {
		max-width: 1200px;
		margin: 0 auto;
		padding: 0 20px;
	}

	.products-grid {
		display: grid;
		grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
		gap: 30px;
		margin-bottom: 60px;
	}

	.product-card {
		background: white;
		border-radius: 15px;
		overflow: hidden;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		transition: all 0.3s;
		cursor: pointer;
		text-decoration: none;
		color: inherit;
		display: block;
	}

	.product-card:hover {
		transform: translateY(-10px);
		box-shadow: 0 10px 30px rgba(0,0,0,0.15);
	}

	.product-image {
		width: 100%;
		height: 200px;
		background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
		display: flex;
		align-items: center;
		justify-content: center;
		position: relative;
		overflow: hidden;
	}

	.product-image img {
		width: 100%;
		height: 100%;
		object-fit: cover;
	}

	.product-image i {
		font-size: 60px;
		color: #d4af37;
		opacity: 0.3;
	}

	.product-info {
		padding: 20px;
	}

	.product-category {
		font-size: 12px;
		color: #d4af37;
		font-weight: 600;
		text-transform: uppercase;
		margin-bottom: 8px;
	}

	.product-name {
		font-size: 18px;
		font-weight: 600;
		color: #333;
		margin-bottom: 10px;
		display: -webkit-box;
		-webkit-line-clamp: 2;
		-webkit-box-orient: vertical;
		overflow: hidden;
		min-height: 54px;
	}

	.product-price {
		font-size: 24px;
		font-weight: 700;
		color: #d4af37;
		margin-bottom: 15px;
	}

	.btn-product {
		width: 100%;
		padding: 12px;
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		border: none;
		border-radius: 8px;
		font-weight: 600;
		cursor: pointer;
		transition: all 0.3s;
		display: flex;
		align-items: center;
		justify-content: center;
		gap: 8px;
		text-decoration: none;
	}

	.btn-product:hover {
		transform: translateY(-2px);
		box-shadow: 0 4px 15px rgba(212, 175, 55, 0.4);
	}

	.empty-state {
		text-align: center;
		padding: 60px 20px;
		color: #999;
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
	}

	.empty-state i {
		font-size: 80px;
		color: #ddd;
		margin-bottom: 20px;
	}

	.empty-state h3 {
		color: #666;
		margin-bottom: 10px;
	}

	/* Responsive */
	@media (max-width: 768px) {
		.page-header h1 {
			font-size: 28px;
		}

		.products-grid {
			grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
			gap: 20px;
		}
	}
</style>

<div class="page-header">
	<h1>
		<i class="fas fa-tag"></i> 
		<?php echo isset($kategori->nama_kategori) ? htmlspecialchars($kategori->nama_kategori) : 'Kategori'; ?>
	</h1>
	<p>Produk dalam kategori ini</p>
</div>

<div class="breadcrumb">
	<a href="<?php echo base_url('home'); ?>"><i class="fas fa-home"></i> Beranda</a> / 
	<a href="<?php echo base_url('kategori'); ?>">Kategori</a> / 
	<span><?php echo isset($kategori->nama_kategori) ? htmlspecialchars($kategori->nama_kategori) : 'Kategori'; ?></span>
</div>

<div class="container">
	<?php if(isset($produk) && !empty($produk)): ?>
		<div class="products-grid">
			<?php foreach($produk as $p): ?>
				<a href="<?php echo base_url('produk/detail/'.(isset($p->id_produk) ? $p->id_produk : 0)); ?>" class="product-card">
					<div class="product-image">
						<?php 
						$gambar = isset($p->gambar_produk) ? $p->gambar_produk : (isset($p->foto_produk) ? $p->foto_produk : (isset($p->gambar) ? $p->gambar : ''));
						if(!empty($gambar)): 
							// Path gambar ada di admin/uploads/produk/
							$image_path = 'http://localhost/gerabah/admin/uploads/produk/'.$gambar;
						?>
							<img src="<?php echo $image_path; ?>" alt="<?php echo isset($p->nama_produk) ? htmlspecialchars($p->nama_produk) : 'Produk'; ?>" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
							<i class="fas fa-image" style="display: none;"></i>
						<?php else: ?>
							<i class="fas fa-image"></i>
						<?php endif; ?>
					</div>
					<div class="product-info">
						<div class="product-category"><?php echo isset($p->nama_kategori) && !empty($p->nama_kategori) ? htmlspecialchars($p->nama_kategori) : 'Kategori'; ?></div>
						<div class="product-name"><?php echo isset($p->nama_produk) ? htmlspecialchars($p->nama_produk) : 'Nama Produk'; ?></div>
						<div class="product-price">
							Rp <?php 
							$harga = 0;
							if(isset($p->harga_produk) && $p->harga_produk > 0) {
								$harga = $p->harga_produk;
							} else if(isset($p->harga) && $p->harga > 0) {
								$harga = $p->harga;
							}
							echo number_format($harga, 0, ',', '.'); 
							?>
						</div>
					</div>
				</a>
			<?php endforeach; ?>
		</div>
	<?php else: ?>
		<div class="empty-state">
			<i class="fas fa-box-open"></i>
			<h3>Belum Ada Produk</h3>
			<p>Belum ada produk dalam kategori ini</p>
		</div>
	<?php endif; ?>
</div>

