<style type="text/css">
	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 60px 20px;
		text-align: center;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.page-header h1 {
		font-size: 42px;
		font-weight: 700;
		margin-bottom: 10px;
	}

	.page-header p {
		font-size: 18px;
		opacity: 0.9;
	}

	.container {
		max-width: 1200px;
		margin: 0 auto;
		padding: 0 20px;
	}

	.categories-grid {
		display: grid;
		grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
		gap: 30px;
		margin-bottom: 60px;
	}

	.category-card {
		background: white;
		border-radius: 15px;
		padding: 40px 20px;
		text-align: center;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		transition: all 0.3s;
		cursor: pointer;
		text-decoration: none;
		color: #333;
		display: block;
	}

	.category-card:hover {
		transform: translateY(-10px);
		box-shadow: 0 10px 30px rgba(0,0,0,0.15);
	}

	.category-icon {
		font-size: 64px;
		color: #d4af37;
		margin-bottom: 20px;
		transition: all 0.3s;
	}

	.category-card:hover .category-icon {
		transform: scale(1.1);
	}

	.category-name {
		font-size: 20px;
		font-weight: 600;
		color: #333;
		margin-bottom: 10px;
	}

	.category-link {
		color: #d4af37;
		font-size: 14px;
		font-weight: 500;
		text-decoration: none;
		display: inline-flex;
		align-items: center;
		gap: 5px;
		margin-top: 10px;
	}

	.category-link:hover {
		text-decoration: underline;
	}

	.empty-state {
		text-align: center;
		padding: 60px 20px;
		color: #999;
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
	}

	.empty-state i {
		font-size: 80px;
		color: #ddd;
		margin-bottom: 20px;
	}

	.empty-state h3 {
		color: #666;
		margin-bottom: 10px;
	}

	/* Responsive */
	@media (max-width: 768px) {
		.page-header h1 {
			font-size: 32px;
		}

		.categories-grid {
			grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
			gap: 20px;
		}
	}
</style>

<div class="page-header">
	<h1><i class="fas fa-tags"></i> Kategori Produk</h1>
	<p>Jelajahi produk berdasarkan kategori pilihan Anda</p>
</div>

<div class="container">
	<?php if(isset($kategori) && !empty($kategori)): ?>
		<div class="categories-grid">
			<?php foreach($kategori as $kat): ?>
				<a href="<?php echo base_url('kategori/produk/'.(isset($kat->id_kategori) ? $kat->id_kategori : 0)); ?>" class="category-card">
					<div class="category-icon">
						<i class="fas fa-tag"></i>
					</div>
					<div class="category-name"><?php echo isset($kat->nama_kategori) ? htmlspecialchars($kat->nama_kategori) : 'Kategori'; ?></div>
					<div class="category-link">
						Lihat Produk <i class="fas fa-arrow-right"></i>
					</div>
				</a>
			<?php endforeach; ?>
		</div>
	<?php else: ?>
		<div class="empty-state">
			<i class="fas fa-tags"></i>
			<h3>Belum Ada Kategori</h3>
			<p>Kategori akan muncul di sini setelah ditambahkan oleh admin</p>
		</div>
	<?php endif; ?>
</div>

