<style type="text/css">
	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 50px 20px;
		text-align: center;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.page-header h1 {
		font-size: 36px;
		font-weight: 700;
		margin-bottom: 10px;
	}

	.container {
		max-width: 1200px;
		margin: 0 auto;
		padding: 0 20px;
	}

	.cart-container {
		display: grid;
		grid-template-columns: 1fr 350px;
		gap: 30px;
		margin-bottom: 40px;
	}

	.cart-items {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		padding: 30px;
	}

	.cart-item {
		display: flex;
		gap: 20px;
		padding: 20px 0;
		border-bottom: 1px solid #e0e0e0;
		align-items: flex-start;
	}

	.cart-item:last-child {
		border-bottom: none;
	}

	.item-checkbox {
		display: flex;
		align-items: center;
		margin-right: 10px;
		flex-shrink: 0;
	}

	.item-checkbox input[type="checkbox"] {
		width: 20px;
		height: 20px;
		border: 2px solid #e0e0e0;
		border-radius: 4px;
		cursor: pointer;
		transition: all 0.3s;
	}

	.item-checkbox input[type="checkbox"]:checked {
		background: #d4af37;
		border-color: #d4af37;
	}

	.select-all {
		display: flex;
		align-items: center;
		gap: 10px;
		padding: 15px 0;
		border-bottom: 1px solid #e0e0e0;
		margin-bottom: 20px;
	}

	.select-all input[type="checkbox"] {
		width: 20px;
		height: 20px;
		border: 2px solid #e0e0e0;
		border-radius: 4px;
		cursor: pointer;
		transition: all 0.3s;
	}

	.select-all input[type="checkbox"]:checked {
		background: #d4af37;
		border-color: #d4af37;
	}

	.select-all label {
		font-weight: 600;
		color: #333;
		cursor: pointer;
	}

	.item-image {
		width: 120px;
		height: 120px;
		border-radius: 10px;
		background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
		display: flex;
		align-items: center;
		justify-content: center;
		overflow: hidden;
		flex-shrink: 0;
	}

	.item-image img {
		width: 100%;
		height: 100%;
		object-fit: cover;
	}

	.item-image i {
		font-size: 40px;
		color: #d4af37;
		opacity: 0.3;
	}

	.item-details {
		flex: 1;
	}

	.item-category {
		font-size: 12px;
		color: #d4af37;
		font-weight: 600;
		text-transform: uppercase;
		margin-bottom: 5px;
	}

	.item-name {
		font-size: 18px;
		font-weight: 600;
		color: #333;
		margin-bottom: 10px;
	}

	.item-price {
		font-size: 20px;
		font-weight: 700;
		color: #d4af37;
		margin-bottom: 15px;
	}

	.item-actions {
		display: flex;
		align-items: center;
		gap: 15px;
	}

	.qty-control {
		display: flex;
		align-items: center;
		gap: 10px;
	}

	.qty-btn {
		width: 35px;
		height: 35px;
		border: 2px solid #e0e0e0;
		background: white;
		border-radius: 8px;
		cursor: pointer;
		display: flex;
		align-items: center;
		justify-content: center;
		transition: all 0.3s;
	}

	.qty-btn:hover {
		border-color: #d4af37;
		color: #d4af37;
	}

	.qty-input {
		width: 60px;
		padding: 8px;
		border: 2px solid #e0e0e0;
		border-radius: 8px;
		text-align: center;
		font-weight: 600;
	}

	.btn-delete {
		padding: 10px 20px;
		background: #dc3545;
		color: white;
		border: none;
		border-radius: 8px;
		cursor: pointer;
		font-weight: 600;
		transition: all 0.3s;
		display: flex;
		align-items: center;
		gap: 8px;
	}

	.btn-delete:hover {
		background: #c82333;
		transform: translateY(-2px);
	}

	.cart-summary {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		padding: 30px;
		height: fit-content;
		position: sticky;
		top: 100px;
	}

	.summary-title {
		font-size: 24px;
		font-weight: 700;
		margin-bottom: 20px;
		color: #333;
	}

	.summary-row {
		display: flex;
		justify-content: space-between;
		padding: 15px 0;
		border-bottom: 1px solid #e0e0e0;
	}

	.summary-row:last-child {
		border-bottom: none;
		font-size: 20px;
		font-weight: 700;
		color: #d4af37;
	}

	.summary-label {
		color: #666;
	}

	.summary-value {
		font-weight: 600;
		color: #333;
	}

	.btn-checkout {
		width: 100%;
		padding: 15px;
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		border: none;
		border-radius: 10px;
		font-size: 18px;
		font-weight: 700;
		cursor: pointer;
		transition: all 0.3s;
		margin-top: 20px;
		display: flex;
		align-items: center;
		justify-content: center;
		gap: 10px;
	}

	.btn-checkout:hover {
		transform: translateY(-2px);
		box-shadow: 0 6px 20px rgba(212, 175, 55, 0.4);
		background: linear-gradient(135deg, #2c3e5e 0%, #1a1f3a 100%);
	}

	.btn-checkout:disabled {
		opacity: 0.5;
		cursor: not-allowed;
	}

	.empty-state {
		text-align: center;
		padding: 60px 20px;
		color: #999;
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
	}

	.empty-state i {
		font-size: 80px;
		color: #ddd;
		margin-bottom: 20px;
	}

	.empty-state h3 {
		color: #666;
		margin-bottom: 10px;
	}

	.empty-state a {
		display: inline-block;
		margin-top: 20px;
		padding: 12px 30px;
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		text-decoration: none;
		border-radius: 8px;
		font-weight: 600;
	}

	/* Responsive */
	@media (max-width: 968px) {
		.cart-container {
			grid-template-columns: 1fr;
		}

		.cart-summary {
			position: static;
		}
	}

	@media (max-width: 768px) {
		.cart-item {
			flex-direction: column;
		}

		.item-image {
			width: 100%;
			height: 200px;
		}
	}
</style>

<div class="page-header">
	<h1><i class="fas fa-shopping-cart"></i> Keranjang Belanja</h1>
</div>

<div class="container">
	<?php if(isset($keranjang) && !empty($keranjang)): ?>
		<div class="cart-container">
			<div class="cart-items">
			<div class="select-all">
				<input type="checkbox" id="select-all" onchange="toggleSelectAll()">
				<label for="select-all">Pilih Semua</label>
			</div>
			<?php foreach($keranjang as $item): ?>
				<div class="cart-item">
					<div class="item-checkbox">
						<input type="checkbox" class="item-check" id="item_<?php echo isset($item->id_keranjang) ? $item->id_keranjang : 0; ?>" value="<?php echo isset($item->id_keranjang) ? $item->id_keranjang : 0; ?>" onchange="updateSelectAll()">
					</div>
						<div class="item-image">
							<?php 
							$gambar = isset($item->gambar_produk) ? $item->gambar_produk : (isset($item->foto_produk) ? $item->foto_produk : (isset($item->gambar) ? $item->gambar : ''));
							if(!empty($gambar)): 
								// Path gambar ada di admin/uploads/produk/
								$image_path = 'http://localhost/gerabah/admin/uploads/produk/'.$gambar;
							?>
								<img src="<?php echo $image_path; ?>" alt="<?php echo isset($item->nama_produk) ? htmlspecialchars($item->nama_produk) : 'Produk'; ?>" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
								<i class="fas fa-image" style="display: none;"></i>
							<?php else: ?>
								<i class="fas fa-image"></i>
							<?php endif; ?>
						</div>
						<div class="item-details">
							<div class="item-category"><?php echo isset($item->nama_kategori) && !empty($item->nama_kategori) ? htmlspecialchars($item->nama_kategori) : 'Kategori'; ?></div>
							<div class="item-name"><?php echo isset($item->nama_produk) ? htmlspecialchars($item->nama_produk) : 'Nama Produk'; ?></div>
							<?php if(isset($item->ukuran) && !empty($item->ukuran)): ?>
								<div class="item-size" style="font-size: 13px; color: #666; margin-bottom: 5px;">
									Ukuran: <span style="font-weight: 600; color: #d4af37;"><?php echo htmlspecialchars($item->ukuran); ?></span>
								</div>
							<?php endif; ?>
							<div class="item-price">
								<?php 
								// Harga sudah dihitung di controller termasuk diskon
								$harga = isset($item->harga) ? $item->harga : 0;
								$harga_asli = isset($item->harga_asli) ? $item->harga_asli : 0;
								$diskon_persen = isset($item->diskon_persen) ? $item->diskon_persen : 0;
								
								if($diskon_persen > 0) {
									?>
									<div style="font-size: 14px; color: #999; text-decoration: line-through;">
										Rp <?php echo number_format($harga_asli, 0, ',', '.'); ?>
									</div>
									<div style="color: #ff424e; font-weight: bold;">
										Rp <?php echo number_format($harga, 0, ',', '.'); ?>
										<span style="font-size: 12px; background: #ff424e; color: white; padding: 2px 5px; border-radius: 3px; margin-left: 5px;"><?php echo $diskon_persen; ?>%</span>
									</div>
									<?php
								} else {
									echo 'Rp ' . number_format($harga, 0, ',', '.'); 
								}
								?>
							</div>
							<div class="item-subtotal" style="margin-top: 10px; font-size: 16px; font-weight: 600; color: #d4af37;">
								Subtotal: Rp <?php 
								$qty = isset($item->qty) ? $item->qty : 1;
								echo number_format($harga * $qty, 0, ',', '.'); 
								?>
							</div>
							<div class="item-actions">
								<form action="<?php echo base_url('keranjang/update'); ?>" method="POST" style="display: flex; align-items: center; gap: 15px;">
									<input type="hidden" name="id_keranjang" value="<?php echo isset($item->id_keranjang) ? $item->id_keranjang : ''; ?>">
									<div class="qty-control">
										<button type="button" class="qty-btn" onclick="decreaseQty(<?php echo isset($item->id_keranjang) ? $item->id_keranjang : 0; ?>)">
											<i class="fas fa-minus"></i>
										</button>
										<input type="number" name="qty" class="qty-input" value="<?php echo isset($item->qty) ? $item->qty : 1; ?>" min="1" id="qty_<?php echo isset($item->id_keranjang) ? $item->id_keranjang : 0; ?>" onchange="this.form.submit()">
										<button type="button" class="qty-btn" onclick="increaseQty(<?php echo isset($item->id_keranjang) ? $item->id_keranjang : 0; ?>)">
											<i class="fas fa-plus"></i>
										</button>
									</div>
								</form>
								<form action="<?php echo base_url('keranjang/hapus'); ?>" method="POST" style="display: inline;">
									<input type="hidden" name="id_keranjang" value="<?php echo isset($item->id_keranjang) ? $item->id_keranjang : ''; ?>">
									<button type="submit" class="btn-delete" onclick="return confirm('Yakin ingin menghapus produk ini?')">
										<i class="fas fa-trash"></i> Hapus
									</button>
								</form>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>

				<form id="checkout-form" action="<?php echo base_url('checkout'); ?>" method="POST">
					<div class="summary-title">Ringkasan Belanja</div>
					<div class="summary-row">
						<span class="summary-label">Subtotal</span>
						<span class="summary-value">Rp <span id="subtotal">0</span></span>
					</div>
					<div class="summary-row">
						<span class="summary-label">Ongkir</span>
						<span class="summary-value">Rp 0</span>
					</div>
					<div class="summary-row">
						<span class="summary-label">Total</span>
						<span class="summary-value">Rp <span id="total">0</span></span>
					</div>
					<button type="submit" class="btn-checkout" id="checkout-btn" disabled>
						<i class="fas fa-credit-card"></i> Checkout
					</button>
				</form>
		</div>
	<?php else: ?>
		<div class="empty-state">
			<i class="fas fa-shopping-cart"></i>
			<h3>Keranjang Anda Kosong</h3>
			<p>Mulai berbelanja dan tambahkan produk ke keranjang Anda</p>
			<a href="<?php echo base_url('produk'); ?>">
				<i class="fas fa-shopping-bag"></i> Belanja Sekarang
			</a>
		</div>
	<?php endif; ?>
</div>

<script>
	let cartItems = <?php echo json_encode(array_map(function($item) { return (array)$item; }, $keranjang)); ?>;

	function increaseQty(id) {
		const input = document.getElementById('qty_' + id);
		input.value = parseInt(input.value) + 1;
		input.form.submit();
	}

	function decreaseQty(id) {
		const input = document.getElementById('qty_' + id);
		if(parseInt(input.value) > 1) {
			input.value = parseInt(input.value) - 1;
			input.form.submit();
		}
	}

	function toggleSelectAll() {
		const selectAllCheckbox = document.getElementById('select-all');
		const itemCheckboxes = document.querySelectorAll('.item-check');
		itemCheckboxes.forEach(checkbox => {
			checkbox.checked = selectAllCheckbox.checked;
		});
		updateSummary();
	}

	function updateSelectAll() {
		const selectAllCheckbox = document.getElementById('select-all');
		const itemCheckboxes = document.querySelectorAll('.item-check');
		const checkedItems = document.querySelectorAll('.item-check:checked');
		selectAllCheckbox.checked = itemCheckboxes.length === checkedItems.length && itemCheckboxes.length > 0;
		updateSummary();
	}

	function updateSummary() {
		const checkedItems = document.querySelectorAll('.item-check:checked');
		let subtotal = 0;
		const form = document.getElementById('checkout-form');
		
		// Clear previous hidden inputs
		form.querySelectorAll('input[name="selected_items[]"]').forEach(input => input.remove());
		
		checkedItems.forEach(checkbox => {
			const id = checkbox.value;
			const item = cartItems.find(item => item.id_keranjang == id);
			if(item) {
				let harga = 0;
				if(item.harga && item.harga > 0) {
					harga = item.harga;
				} else if(item.harga_produk && item.harga_produk > 0) {
					harga = item.harga_produk;
				} else if(item.harga_produk_alt && item.harga_produk_alt > 0) {
					harga = item.harga_produk_alt;
				}
				const qty = item.qty || 1;
				subtotal += harga * qty;
				
				// Add hidden input for selected item
				const hiddenInput = document.createElement('input');
				hiddenInput.type = 'hidden';
				hiddenInput.name = 'selected_items[]';
				hiddenInput.value = id;
				form.appendChild(hiddenInput);
			}
		});
		
		document.getElementById('subtotal').textContent = subtotal.toLocaleString('id-ID');
		document.getElementById('total').textContent = subtotal.toLocaleString('id-ID');
		
		const checkoutBtn = document.getElementById('checkout-btn');
		checkoutBtn.disabled = checkedItems.length === 0;
	}

	// Initialize on page load
	document.addEventListener('DOMContentLoaded', function() {
		updateSummary();
	});
</script>

