<!DOCTYPE html>
<html lang="id">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?php echo isset($title) ? $title : 'Pembayaran - Marketplace'; ?></title>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	
	<!-- Midtrans Snap JS -->
	<script type="text/javascript" 
		src="<?php echo (isset($is_production) && $is_production) ? 'https://app.midtrans.com/snap/snap.js' : 'https://app.sandbox.midtrans.com/snap/snap.js'; ?>" 
		data-client-key="<?php echo isset($client_key) ? $client_key : ''; ?>">
	</script>
	
	<style type="text/css">
		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		body {
			font-family: 'Poppins', sans-serif;
			background-color: #f8f9fa;
			color: #333;
			line-height: 1.6;
		}

		.payment-container {
			max-width: 800px;
			margin: 40px auto;
			padding: 0 20px;
		}

		.payment-header {
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			color: white;
			padding: 30px;
			border-radius: 15px 15px 0 0;
			text-align: center;
		}

		.payment-header h1 {
			font-size: 28px;
			font-weight: 700;
			margin-bottom: 10px;
		}

		.payment-header p {
			opacity: 0.9;
		}

		.payment-content {
			background: white;
			padding: 40px;
			border-radius: 0 0 15px 15px;
			box-shadow: 0 5px 20px rgba(0,0,0,0.1);
			min-height: 500px;
		}

		.loading {
			text-align: center;
			padding: 60px 20px;
		}

		.loading i {
			font-size: 48px;
			color: #d4af37;
			margin-bottom: 20px;
			animation: spin 1s linear infinite;
		}

		@keyframes spin {
			from { transform: rotate(0deg); }
			to { transform: rotate(360deg); }
		}

		.loading p {
			color: #666;
			font-size: 16px;
		}

		.error-message {
			background: #f8d7da;
			color: #721c24;
			padding: 20px;
			border-radius: 8px;
			margin-bottom: 20px;
			border: 2px solid #f5c6cb;
		}

		.btn-back {
			display: inline-block;
			padding: 12px 30px;
			background: #6c757d;
			color: white;
			text-decoration: none;
			border-radius: 8px;
			font-weight: 600;
			transition: all 0.3s;
			margin-top: 20px;
		}

		.btn-back:hover {
			background: #5a6268;
			transform: translateY(-2px);
		}
	</style>
</head>
<body>

<div class="payment-container">
	<div class="payment-header">
		<h1><i class="fas fa-credit-card"></i> Pembayaran</h1>
		<p>Lengkapi pembayaran Anda melalui Midtrans</p>
	</div>
	
	<div class="payment-content">
		<?php if(isset($snap_token) && !empty($snap_token)): ?>
			<div id="snap-container">
				<div class="loading">
					<i class="fas fa-spinner"></i>
					<p>Memuat halaman pembayaran...</p>
				</div>
			</div>
		<?php else: ?>
			<div class="error-message">
				<i class="fas fa-exclamation-circle"></i>
				<strong>Error:</strong> Token pembayaran tidak ditemukan. Silakan ulangi proses checkout.
			</div>
			<div style="text-align: center;">
				<a href="<?php echo base_url('checkout'); ?>" class="btn-back">
					<i class="fas fa-arrow-left"></i> Kembali ke Checkout
				</a>
			</div>
		<?php endif; ?>
	</div>
</div>

<script type="text/javascript">
	<?php if(isset($snap_token) && !empty($snap_token)): ?>
		// Inisialisasi Snap Midtrans
		snap.pay('<?php echo $snap_token; ?>', {
			onSuccess: function(result){
				console.log('success');
				console.log(result);
				// Redirect akan dilakukan oleh Midtrans ke finish URL
			},
			onPending: function(result){
				console.log('pending');
				console.log(result);
				// Redirect akan dilakukan oleh Midtrans ke unfinish URL
			},
			onError: function(result){
				console.log('error');
				console.log(result);
				// Redirect akan dilakukan oleh Midtrans ke error URL
			},
			onClose: function(){
				console.log('customer closed the popup without finishing the payment');
				// User menutup popup tanpa menyelesaikan pembayaran
			}
		});
	<?php endif; ?>
</script>

</body>
</html>

