<style type="text/css">
	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 40px 20px;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.breadcrumb {
		max-width: 1200px;
		margin: 0 auto 20px;
		padding: 0 20px;
	}

	.breadcrumb a {
		color: #d4af37;
		text-decoration: none;
	}

	.breadcrumb a:hover {
		text-decoration: underline;
	}

	.container {
		max-width: 1200px;
		margin: 0 auto;
		padding: 0 20px;
	}

	.product-detail {
		display: grid;
		grid-template-columns: 1fr 1fr;
		gap: 40px;
		margin-bottom: 60px;
	}

	.product-image-section {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		padding: 20px;
	}

	.product-main-image {
		width: 100%;
		height: 500px;
		background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
		border-radius: 10px;
		display: flex;
		align-items: center;
		justify-content: center;
		overflow: hidden;
		margin-bottom: 20px;
	}

	.product-main-image img {
		width: 100%;
		height: 100%;
		object-fit: cover;
	}

	.product-main-image i {
		font-size: 100px;
		color: #d4af37;
		opacity: 0.3;
	}

	.product-info-section {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		padding: 30px;
	}

	.product-category {
		font-size: 14px;
		color: #d4af37;
		font-weight: 600;
		text-transform: uppercase;
		margin-bottom: 10px;
	}

	.product-name {
		font-size: 32px;
		font-weight: 700;
		color: #333;
		margin-bottom: 20px;
	}

	.product-price {
		font-size: 36px;
		font-weight: 700;
		color: #d4af37;
		margin-bottom: 30px;
	}

	.product-description {
		margin-bottom: 30px;
	}

	.product-description h3 {
		font-size: 20px;
		font-weight: 600;
		margin-bottom: 15px;
		color: #333;
	}

	.product-description p {
		color: #666;
		line-height: 1.8;
	}

	.product-actions {
		margin-top: 30px;
	}

	.qty-section {
		display: flex;
		align-items: center;
		gap: 15px;
		margin-bottom: 20px;
	}

	.qty-label {
		font-weight: 600;
		color: #333;
	}

	.qty-control {
		display: flex;
		align-items: center;
		gap: 10px;
	}

	.qty-btn {
		width: 40px;
		height: 40px;
		border: 2px solid #e0e0e0;
		background: white;
		border-radius: 8px;
		cursor: pointer;
		display: flex;
		align-items: center;
		justify-content: center;
		transition: all 0.3s;
		font-size: 18px;
	}

	.qty-btn:hover {
		border-color: #d4af37;
		color: #d4af37;
	}

	.qty-input {
		width: 80px;
		padding: 10px;
		border: 2px solid #e0e0e0;
		border-radius: 8px;
		text-align: center;
		font-weight: 600;
		font-size: 16px;
	}

	.btn-add-cart {
		width: 100%;
		padding: 15px;
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		border: none;
		border-radius: 10px;
		font-size: 18px;
		font-weight: 600;
		cursor: pointer;
		transition: all 0.3s;
		display: flex;
		align-items: center;
		justify-content: center;
		gap: 10px;
		margin-bottom: 15px;
	}

	.btn-add-cart:hover {
		transform: translateY(-2px);
		box-shadow: 0 6px 20px rgba(212, 175, 55, 0.4);
	}

	.btn-buy-now {
		width: 100%;
		padding: 15px;
		background: white;
		color: #d4af37;
		border: 2px solid #d4af37;
		border-radius: 10px;
		font-size: 18px;
		font-weight: 600;
		cursor: pointer;
		transition: all 0.3s;
		display: flex;
		align-items: center;
		justify-content: center;
		gap: 10px;
		text-decoration: none;
	}

	.btn-buy-now:hover {
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		font-weight: 700;
		transform: translateY(-2px);
		box-shadow: 0 4px 15px rgba(212, 175, 55, 0.4);
	}

	.product-specs {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		padding: 30px;
		margin-bottom: 40px;
	}

	.specs-title {
		font-size: 24px;
		font-weight: 700;
		margin-bottom: 20px;
		color: #333;
	}

	.spec-row {
		display: grid;
		grid-template-columns: 200px 1fr;
		gap: 20px;
		padding: 15px 0;
		border-bottom: 1px solid #e0e0e0;
	}

	.spec-row:last-child {
		border-bottom: none;
	}

	.spec-label {
		font-weight: 600;
		color: #666;
	}

	.spec-value {
		color: #333;
	}

	/* Responsive */
	@media (max-width: 968px) {
		.product-detail {
			grid-template-columns: 1fr;
		}

		.product-main-image {
			height: 400px;
		}
	}
</style>

<div class="breadcrumb">
	<a href="<?php echo base_url('home'); ?>"><i class="fas fa-home"></i> Beranda</a> / 
	<a href="<?php echo base_url('produk'); ?>">Produk</a> / 
	<?php if(isset($kategori) && $kategori): ?>
		<a href="<?php echo base_url('kategori/produk/'.$kategori->id_kategori); ?>"><?php echo htmlspecialchars($kategori->nama_kategori); ?></a> / 
	<?php endif; ?>
	<span><?php echo isset($produk->nama_produk) ? htmlspecialchars($produk->nama_produk) : 'Detail Produk'; ?></span>
</div>

<div class="container">
	<?php if(isset($produk) && $produk): ?>
		<div class="product-detail">
			<div class="product-image-section">
				<div class="product-main-image">
					<?php 
					$gambar = isset($produk->gambar_produk) ? $produk->gambar_produk : (isset($produk->foto_produk) ? $produk->foto_produk : (isset($produk->gambar) ? $produk->gambar : ''));
					if(!empty($gambar)): 
						$image_path = 'http://localhost/gerabah/admin/uploads/produk/'.$gambar;
					?>
						<img src="<?php echo $image_path; ?>" alt="<?php echo isset($produk->nama_produk) ? htmlspecialchars($produk->nama_produk) : 'Produk'; ?>" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
						<i class="fas fa-image" style="display: none;"></i>
					<?php else: ?>
						<i class="fas fa-image"></i>
					<?php endif; ?>
				</div>
			</div>

			<div class="product-info-section">
				<div class="product-category">
					<?php echo isset($produk->nama_kategori) && !empty($produk->nama_kategori) ? htmlspecialchars($produk->nama_kategori) : 'Kategori'; ?>
				</div>
				<div class="product-name">
					<?php echo isset($produk->nama_produk) ? htmlspecialchars($produk->nama_produk) : 'Nama Produk'; ?>
				</div>
				<?php 
				// Hitung harga diskon
				$harga = 0;
				if(isset($produk->harga_produk) && $produk->harga_produk > 0) {
					$harga = $produk->harga_produk;
				} else if(isset($produk->harga) && $produk->harga > 0) {
					$harga = $produk->harga;
				}
				
			$harga_info = get_harga_diskon($produk, $harga);
			$has_diskon = $harga_info['persen_diskon'] > 0;
			?>
			
			<div style="margin-bottom: 20px;" id="price-container">
				<?php if($has_diskon): ?>
					<!-- Badge Diskon ala Shopee -->
					<span style="background: linear-gradient(135deg, #ff424e 0%, #ff0017 100%); color: white; padding: 6px 15px; border-radius: 5px; font-size: 16px; font-weight: 700; display: inline-block; margin-bottom: 12px; box-shadow: 0 3px 8px rgba(255, 0, 23, 0.4);">
						-<?php echo $harga_info['persen_diskon']; ?>%
					</span>
					<!-- Harga Diskon (Merah, Besar) -->
					<div style="font-size: 36px; font-weight: 700; color: #ff424e; margin-bottom: 5px;" id="display-harga-diskon">
						Rp<?php echo number_format($harga_info['harga_diskon'], 0, ',', '.'); ?>
					</div>
					<!-- Harga Normal Dicoret (Abu-abu, Kecil) -->
					<div style="font-size: 20px; color: #888; text-decoration: line-through;" id="display-harga-coret">
						Rp<?php echo number_format($harga_info['harga_awal'], 0, ',', '.'); ?>
					</div>
				<?php else: ?>
					<!-- Harga Normal -->
					<div style="font-size: 36px; font-weight: 700; color: #1a1f3a; margin-top: 10px;" id="display-harga-normal">
						Rp <?php echo number_format($harga, 0, ',', '.'); ?>
					</div>
				<?php endif; ?>
			</div>

				<?php if(isset($produk->deskripsi_produk) && !empty($produk->deskripsi_produk)): ?>
				<div class="product-description">
					<h3>Deskripsi Produk</h3>
					<p><?php echo nl2br(htmlspecialchars($produk->deskripsi_produk)); ?></p>
				</div>
				<?php endif; ?>

				<div class="product-actions">
					<?php if($this->session->userdata('logged_in')): ?>
						<?php 
						$stok = isset($produk->stok) ? $produk->stok : (isset($produk->stok_produk) ? $produk->stok_produk : 0);
						?>
						<form action="<?php echo base_url('keranjang/tambah'); ?>" method="POST" id="addToCartForm">
							<input type="hidden" name="id_produk" value="<?php echo isset($produk->id_produk) ? $produk->id_produk : ''; ?>">
							
							<?php if(isset($ukuran) && !empty($ukuran)): ?>
							<div class="size-section" style="margin-bottom: 20px;">
								<span class="qty-label" style="display: block; margin-bottom: 10px;">Pilih Ukuran:</span>
								<div class="size-options" style="display: flex; flex-wrap: wrap; gap: 10px;">
									<?php foreach($ukuran as $u): ?>
										<label class="size-option" style="cursor: pointer;">
											<input type="radio" name="id_ukuran" value="<?php echo $u->id_ukuran; ?>" 
												data-harga="<?php echo $u->harga; ?>" 
												data-stok="<?php echo isset($u->stok) ? $u->stok : 0; ?>"
												style="display: none;" 
												onchange="updatePrice(this)">
											<span class="size-box" style="display: inline-block; padding: 8px 15px; border: 2px solid #e0e0e0; border-radius: 8px; font-weight: 600; color: #333; transition: all 0.3s;">
												<?php echo htmlspecialchars($u->ukuran); ?>
											</span>
										</label>
									<?php endforeach; ?>
								</div>
								<input type="hidden" name="harga_custom" id="harga_custom" value="">
							</div>
							<style>
								.size-option input:checked + .size-box {
									border-color: #d4af37;
									background: #d4af37;
									color: white;
								}
								.size-box:hover {
									border-color: #d4af37;
								}
							</style>
							<?php endif; ?>

							<div class="qty-section">
								<span class="qty-label">Jumlah:</span>
								<div class="qty-control">
									<button type="button" class="qty-btn" onclick="decreaseQty()">
										<i class="fas fa-minus"></i>
									</button>
									<input type="number" name="qty" id="qty" class="qty-input" value="1" min="1" max="<?php echo $stok; ?>" required <?php echo $stok <= 0 ? 'disabled' : ''; ?>>
									<button type="button" class="qty-btn" onclick="increaseQty()">
										<i class="fas fa-plus"></i>
									</button>
								</div>
								<div style="margin-left: 15px; font-size: 14px; color: <?php echo $stok > 5 ? '#666' : '#ff424e'; ?>; font-weight: 600;">
									<?php echo $stok > 0 ? "Stok: $stok" : "Stok Habis"; ?>
								</div>
							</div>

							<?php if($stok > 0): ?>
							<button type="submit" class="btn-add-cart">
								<i class="fas fa-shopping-cart"></i> Tambah ke Keranjang
							</button>
							<?php else: ?>
							<button type="button" class="btn-add-cart" style="background: #ccc; cursor: not-allowed;" disabled>
								<i class="fas fa-times-circle"></i> Stok Habis
							</button>
							<?php endif; ?>
						</form>

						<?php if($stok > 0): ?>
						<a href="<?php echo base_url('keranjang/buy_now?id_produk=' . (isset($produk->id_produk) ? $produk->id_produk : '') . '&qty=1'); ?>" class="btn-buy-now" id="buyNowBtn">
							<i class="fas fa-credit-card"></i> Beli Sekarang
						</a>
						<?php endif; ?>
					<?php else: ?>
						<div style="padding: 20px; background: #f8f9fa; border-radius: 10px; text-align: center;">
							<p style="margin-bottom: 15px; color: #666;">Silakan login untuk menambahkan produk ke keranjang</p>
							<a href="<?php echo base_url('akun'); ?>" class="btn-add-cart" style="text-decoration: none; display: inline-block;">
								<i class="fas fa-sign-in-alt"></i> Login
							</a>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>

		<div class="product-specs">
			<div class="specs-title">Spesifikasi Produk</div>
			<div class="spec-row">
				<div class="spec-label">Kategori</div>
				<div class="spec-value"><?php echo isset($produk->nama_kategori) && !empty($produk->nama_kategori) ? htmlspecialchars($produk->nama_kategori) : '-'; ?></div>
			</div>
			<?php if(isset($produk->stok) || isset($produk->stok_produk)): ?>
			<div class="spec-row">
				<div class="spec-label">Stok</div>
				<div class="spec-value">
					<?php 
					$stok = isset($produk->stok) ? $produk->stok : (isset($produk->stok_produk) ? $produk->stok_produk : 0);
					echo $stok > 0 ? $stok . ' unit tersedia' : 'Stok habis';
					?>
				</div>
			</div>
			<?php endif; ?>
			<?php if(isset($produk->berat) || isset($produk->berat_produk)): ?>
			<div class="spec-row">
				<div class="spec-label">Berat</div>
				<div class="spec-value">
					<?php 
					$berat = isset($produk->berat) ? $produk->berat : (isset($produk->berat_produk) ? $produk->berat_produk : 0);
					echo $berat > 0 ? number_format($berat, 0, ',', '.') . ' Kg' : '-';
					?>
				</div>
			</div>
			<?php endif; ?>
			<div class="spec-row">
				<div class="spec-label">Harga</div>
				<div class="spec-value">
					<strong style="color: #d4af37; font-size: 20px;">
						Rp <?php 
						$harga = 0;
						if(isset($produk->harga_produk) && $produk->harga_produk > 0) {
							$harga = $produk->harga_produk;
						} else if(isset($produk->harga) && $produk->harga > 0) {
							$harga = $produk->harga;
						}
						echo number_format($harga, 0, ',', '.');
						?>
					</strong>
				</div>
			</div>
		</div>
	<?php else: ?>
		<div style="text-align: center; padding: 60px 20px; background: white; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.1);">
			<i class="fas fa-exclamation-circle" style="font-size: 80px; color: #ddd; margin-bottom: 20px;"></i>
			<h3 style="color: #666; margin-bottom: 10px;">Produk Tidak Ditemukan</h3>
			<p style="color: #999; margin-bottom: 20px;">Produk yang Anda cari tidak tersedia</p>
			<a href="<?php echo base_url('produk'); ?>" style="display: inline-block; padding: 12px 30px; background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%); color: #1a1f3a; text-decoration: none; border-radius: 8px; font-weight: 700;">
				<i class="fas fa-arrow-left"></i> Kembali ke Daftar Produk
			</a>
		</div>
	<?php endif; ?>
</div>

<script>
	function increaseQty() {
		const qtyInput = document.getElementById('qty');
		const max = qtyInput.getAttribute('max');
		const current = parseInt(qtyInput.value);
		
		if (!max || current < parseInt(max)) {
			qtyInput.value = current + 1;
			updateBuyNowLink();
		}
	}

	function decreaseQty() {
		const qtyInput = document.getElementById('qty');
		if(parseInt(qtyInput.value) > 1) {
			qtyInput.value = parseInt(qtyInput.value) - 1;
			updateBuyNowLink();
		}
	}

	function updateBuyNowLink() {
		const qtyInput = document.getElementById('qty');
		const buyNowBtn = document.getElementById('buyNowBtn');
		const idProduk = '<?php echo isset($produk->id_produk) ? $produk->id_produk : ''; ?>';
		
		// Ambil ukuran yang dipilih
		let idUkuran = '';
		const selectedSize = document.querySelector('input[name="id_ukuran"]:checked');
		if(selectedSize) {
			idUkuran = selectedSize.value;
		}

		if(buyNowBtn && idProduk) {
			const qty = qtyInput.value;
			let url = '<?php echo base_url('keranjang/buy_now?id_produk='); ?>' + idProduk + '&qty=' + qty;
			if(idUkuran) {
				url += '&id_ukuran=' + idUkuran;
			}
			buyNowBtn.href = url;
		}
	}

	function updatePrice(radio) {
		const harga = parseInt(radio.getAttribute('data-harga'));
		const stok = parseInt(radio.getAttribute('data-stok'));
		const displayNormal = document.getElementById('display-harga-normal');
		const displayDiskon = document.getElementById('display-harga-diskon');
		const qtyInput = document.getElementById('qty');
		const stokDisplay = document.querySelector('.qty-section div[style*="margin-left"]');
		const addToCartBtn = document.querySelector('.btn-add-cart');
		const buyNowBtn = document.getElementById('buyNowBtn');
		
		// Format Rupiah
		const formattedHarga = 'Rp ' + new Intl.NumberFormat('id-ID').format(harga);
		
		// Update harga normal jika ada
		if(displayNormal) {
			displayNormal.textContent = formattedHarga;
		}
		
		// Update harga diskon jika ada (asumsi harga ukuran menimpa harga diskon untuk saat ini, atau reset diskon)
		// Simplifikasi: jika pilih ukuran, kita tampilkan harga ukuran sebagai harga utama
		// Jika ada elemen diskon, kita sembunyikan coretan dan tampilkan harga baru
		if(displayDiskon) {
			displayDiskon.textContent = formattedHarga;
			const displayCoret = document.getElementById('display-harga-coret');
			if(displayCoret) displayCoret.style.display = 'none';
			
			// Sembunyikan badge diskon
			const badge = document.querySelector('.price-container span'); // Perlu selector yang lebih spesifik jika ada banyak span
			// Tapi untuk amannya biarkan saja, atau kita bisa reload page kalau mau strict
		}

		// Update Stok dan Max Qty
		if(qtyInput) {
			qtyInput.setAttribute('max', stok);
			if(parseInt(qtyInput.value) > stok) {
				qtyInput.value = stok > 0 ? 1 : 0;
			}
			if(stok <= 0) {
				qtyInput.value = 0;
				qtyInput.setAttribute('disabled', 'disabled');
			} else {
				qtyInput.removeAttribute('disabled');
				if(parseInt(qtyInput.value) === 0) qtyInput.value = 1;
			}
		}

		// Update Stok Display Text
		if(stokDisplay) {
			if(stok > 0) {
				stokDisplay.textContent = "Stok: " + stok;
				stokDisplay.style.color = stok > 5 ? '#666' : '#ff424e';
			} else {
				stokDisplay.textContent = "Stok Habis";
				stokDisplay.style.color = '#ff424e';
			}
		}

		// Update Buttons State
		if(stok <= 0) {
			if(addToCartBtn) {
				addToCartBtn.setAttribute('disabled', 'disabled');
				addToCartBtn.style.background = '#ccc';
				addToCartBtn.style.cursor = 'not-allowed';
				addToCartBtn.innerHTML = '<i class="fas fa-times-circle"></i> Stok Habis';
			}
			if(buyNowBtn) {
				buyNowBtn.style.display = 'none';
			}
		} else {
			if(addToCartBtn) {
				addToCartBtn.removeAttribute('disabled');
				addToCartBtn.style.background = 'linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%)';
				addToCartBtn.style.cursor = 'pointer';
				addToCartBtn.innerHTML = '<i class="fas fa-shopping-cart"></i> Tambah ke Keranjang';
			}
			if(buyNowBtn) {
				buyNowBtn.style.display = 'flex';
			}
		}

		updateBuyNowLink();
	}

	// Update link saat input qty berubah
	document.addEventListener('DOMContentLoaded', function() {
		const qtyInput = document.getElementById('qty');
		if(qtyInput) {
			qtyInput.addEventListener('change', updateBuyNowLink);
			qtyInput.addEventListener('input', updateBuyNowLink);
		}
		// Inisialisasi link saat pertama kali load
		updateBuyNowLink();
	});
</script>

