<style type="text/css">
	/* Hero Section with Slider */
	.hero {
		position: relative;
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 0;
		text-align: center;
		margin-bottom: 0; /* Changed from 60px to 0 to merge with page header if needed, or keep separate */
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
		overflow: hidden;
		height: 500px;
	}

	.hero-slider {
		position: relative;
		width: 100%;
		height: 100%;
	}

	.hero-slide {
		position: absolute;
		top: 0;
		left: 0;
		width: 100%;
		height: 100%;
		opacity: 0;
		transition: opacity 0.8s ease-in-out;
		display: flex;
		align-items: center;
		justify-content: center;
		background-size: cover;
		background-position: center;
	}

	.hero-slide.active {
		opacity: 1;
		z-index: 1;
	}

	.hero-content {
		max-width: 800px;
		margin: 0 auto;
		padding: 20px;
		z-index: 2;
		position: relative;
	}

	.hero-overlay {
		position: absolute;
		top: 0;
		left: 0;
		width: 100%;
		height: 100%;
		background: rgba(26, 31, 58, 0.7);
		z-index: 1;
	}

	.hero h1 {
		font-size: 48px;
		font-weight: 700;
		margin-bottom: 20px;
		animation: fadeInUp 0.8s ease-out;
	}

	.hero p {
		font-size: 20px;
		margin-bottom: 30px;
		opacity: 0.9;
		animation: fadeInUp 1s ease-out;
	}

	.hero-buttons {
		display: flex;
		gap: 20px;
		justify-content: center;
		flex-wrap: wrap;
		animation: fadeInUp 1.2s ease-out;
	}

	.hero-slider-controls {
		position: absolute;
		bottom: 20px;
		left: 0;
		width: 100%;
		display: flex;
		justify-content: center;
		gap: 15px;
		z-index: 10;
	}

	.slider-dot {
		width: 12px;
		height: 12px;
		background: rgba(255, 255, 255, 0.5);
		border-radius: 50%;
		cursor: pointer;
		transition: all 0.3s;
	}

	.slider-dot.active {
		background: #d4af37;
		transform: scale(1.2);
	}

	.slider-arrow {
		position: absolute;
		top: 50%;
		transform: translateY(-50%);
		background: rgba(255, 255, 255, 0.1);
		color: white;
		border: none;
		width: 50px;
		height: 50px;
		border-radius: 50%;
		cursor: pointer;
		display: flex;
		align-items: center;
		justify-content: center;
		font-size: 20px;
		transition: all 0.3s;
		z-index: 10;
	}

	.slider-arrow:hover {
		background: rgba(212, 175, 55, 0.8);
		color: #1a1f3a;
	}

	.slider-prev { left: 20px; }
	.slider-next { right: 20px; }

	.btn-hero {
		padding: 15px 30px;
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		border: none;
		border-radius: 50px;
		font-weight: 700;
		text-decoration: none;
		display: inline-flex;
		align-items: center;
		gap: 10px;
		transition: all 0.3s;
		box-shadow: 0 4px 15px rgba(212, 175, 55, 0.3);
	}

	.btn-hero:hover {
		transform: translateY(-3px);
		box-shadow: 0 6px 20px rgba(212, 175, 55, 0.4);
		background: linear-gradient(135deg, #c9a961 0%, #d4af37 100%);
	}

	.btn-hero-outline {
		background: transparent;
		border: 2px solid white;
		color: white;
	}

	.btn-hero-outline:hover {
		background: white;
		color: #d4af37;
	}

	@keyframes fadeInUp {
		from {
			opacity: 0;
			transform: translateY(30px);
		}
		to {
			opacity: 1;
			transform: translateY(0);
		}
	}
	
	/* Responsive for Slider */
	@media (max-width: 768px) {
		.hero h1 {
			font-size: 32px;
		}

		.hero p {
			font-size: 16px;
		}
	}

	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 60px 20px;
		text-align: center;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.page-header h1 {
		font-size: 42px;
		font-weight: 700;
		margin-bottom: 10px;
	}

	.page-header p {
		font-size: 18px;
		opacity: 0.9;
	}

	.container {
		max-width: 1200px;
		margin: 0 auto;
		padding: 0 20px;
	}

	/* Filter Section */
	.filter-section {
		background: white;
		padding: 20px;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		margin-bottom: 30px;
	}

	.filter-title {
		font-size: 18px;
		font-weight: 600;
		margin-bottom: 15px;
		color: #333;
	}

	/* Search Form */
	.search-form {
		margin-bottom: 20px;
	}

	.search-wrapper {
		display: flex;
		gap: 10px;
	}

	.search-input {
		flex: 1;
		padding: 12px 20px;
		border: 2px solid #e0e0e0;
		border-radius: 25px;
		font-size: 16px;
		outline: none;
		transition: all 0.3s;
	}

	.search-input:focus {
		border-color: #d4af37;
		box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
	}

	.search-btn {
		padding: 12px 30px;
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		border: none;
		border-radius: 25px;
		cursor: pointer;
		font-weight: 600;
		transition: all 0.3s;
	}

	.search-btn:hover {
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		transform: translateY(-2px);
	}

	/* Pagination */
	.pagination-wrapper {
		margin-top: 40px;
		margin-bottom: 40px;
		text-align: center;
	}

	.pagination {
		display: inline-flex;
		list-style: none;
		padding: 0;
		margin: 0;
		gap: 5px;
	}

	.pagination li {
		display: inline-block;
	}

	.pagination li a,
	.pagination li span {
		padding: 10px 15px;
		border: 2px solid #e0e0e0;
		border-radius: 8px;
		text-decoration: none;
		color: #333;
		transition: all 0.3s;
		display: block;
	}

	.pagination li.active a {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		border-color: transparent;
	}

	.pagination li a:hover {
		background: #f8f9fa;
		border-color: #d4af37;
	}

	.filter-buttons {
		display: flex;
		flex-wrap: wrap;
		gap: 10px;
	}

	.filter-btn {
		padding: 10px 20px;
		border: 2px solid #e0e0e0;
		background: white;
		border-radius: 25px;
		cursor: pointer;
		transition: all 0.3s;
		text-decoration: none;
		color: #333;
		font-weight: 500;
	}

	.filter-btn:hover,
	.filter-btn.active {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		border-color: transparent;
	}

	/* Products Grid */
	.products-grid {
		display: grid;
		grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
		gap: 30px;
		margin-bottom: 60px;
	}

	.product-card {
		background: white;
		border-radius: 15px;
		overflow: hidden;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		transition: all 0.3s;
		cursor: pointer;
		text-decoration: none;
		color: inherit;
		display: block;
	}

	.product-card:hover {
		transform: translateY(-10px);
		box-shadow: 0 10px 30px rgba(0,0,0,0.15);
	}

	.product-image {
		width: 100%;
		height: 200px;
		background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
		display: flex;
		align-items: center;
		justify-content: center;
		position: relative;
		overflow: hidden;
	}

	.product-image img {
		width: 100%;
		height: 100%;
		object-fit: cover;
	}

	.product-image i {
		font-size: 60px;
		color: #2c3e5e;
		opacity: 0.3;
	}

	.stok-badge {
		font-size: 13px;
		font-weight: 500;
		color: #666;
		display: inline-flex;
		align-items: center;
		gap: 6px;
		margin-bottom: 10px;
	}

	.stok-badge.habis {
		color: #dc3545;
	}

	.stok-badge.rendah {
		color: #ff9800;
	}

	.stok-badge.cukup {
		color: #666;
	}

	.product-info {
		padding: 20px;
	}

	.product-category {
		font-size: 12px;
		color: #2c3e5e;
		font-weight: 600;
		text-transform: uppercase;
		margin-bottom: 8px;
	}

	.product-name {
		font-size: 18px;
		font-weight: 600;
		color: #333;
		margin-bottom: 10px;
		display: -webkit-box;
		-webkit-line-clamp: 2;
		-webkit-box-orient: vertical;
		overflow: hidden;
		min-height: 54px;
	}

	.product-price {
		font-size: 24px;
		font-weight: 700;
		color: #2c3e5e;
		margin-bottom: 15px;
	}

	.btn-product {
		width: 100%;
		padding: 12px;
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		border: none;
		border-radius: 8px;
		font-weight: 700;
		cursor: pointer;
		transition: all 0.3s;
		display: flex;
		align-items: center;
		justify-content: center;
		gap: 8px;
		text-decoration: none;
	}

	.btn-product:hover {
		transform: translateY(-2px);
		box-shadow: 0 4px 15px rgba(212, 175, 55, 0.5);
		background: linear-gradient(135deg, #c9a961 0%, #d4af37 100%);
	}

	.empty-state {
		text-align: center;
		padding: 60px 20px;
		color: #999;
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
	}

	.empty-state i {
		font-size: 80px;
		color: #ddd;
		margin-bottom: 20px;
	}

	.empty-state h3 {
		color: #666;
		margin-bottom: 10px;
	}

	/* Responsive */
	@media (max-width: 768px) {
		.page-header h1 {
			font-size: 32px;
		}

		.products-grid {
			grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
			gap: 20px;
		}
	}
</style>

<!-- Hero Section -->
<section class="hero">
	<div class="hero-slider" id="heroSlider">
		<?php if(isset($sliders) && !empty($sliders)): ?>
			<?php foreach($sliders as $key => $slide): ?>
				<?php 
					$bg_style = '';
					$is_video = false;
					$file_ext = '';
					
					if(!empty($slide->gambar_slider)) {
						$file_ext = pathinfo($slide->gambar_slider, PATHINFO_EXTENSION);
						if(in_array(strtolower($file_ext), ['mp4', 'webm'])) {
							$is_video = true;
						} else {
							$bg_style = "background-image: url('http://localhost/gerabah/admin/uploads/slider/" . $slide->gambar_slider . "');";
						}
					}
				?>
				<div class="hero-slide <?php echo $key == 0 ? 'active' : ''; ?>" style="<?php echo $bg_style; ?>">
					<?php if($is_video): ?>
						<video autoplay muted loop playsinline style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; object-fit: cover; z-index: 0;">
							<source src="<?php echo 'http://localhost/gerabah/admin/uploads/slider/' . $slide->gambar_slider; ?>" type="video/<?php echo $file_ext; ?>">
						</video>
					<?php endif; ?>
					<div class="hero-overlay"></div>
					<div class="hero-content">
						<h1><?php echo $slide->judul_slider; ?></h1>
						<p><?php echo $slide->deskripsi_slider; ?></p>
						<?php if(!empty($slide->link_slider)): ?>
						<div class="hero-buttons">
							<a href="<?php echo base_url($slide->link_slider); ?>" class="btn-hero">
								<i class="fas fa-arrow-right"></i> Lihat Detail
							</a>
						</div>
						<?php endif; ?>
					</div>
				</div>
			<?php endforeach; ?>
		<?php else: ?>
			<!-- Slide Default 1 -->
			<div class="hero-slide active">
				<div class="hero-overlay"></div>
				<div class="hero-content">
					<h1>Selamat Datang di Giska Keramik</h1>
					<p>Temukan berbagai produk berkualitas dengan harga terbaik untuk kebutuhan Anda</p>
					<div class="hero-buttons">
						<a href="<?php echo base_url('produk'); ?>" class="btn-hero">
							<i class="fas fa-shopping-bag"></i> Belanja Sekarang
						</a>
						<a href="<?php echo base_url('kategori'); ?>" class="btn-hero btn-hero-outline">
							<i class="fas fa-tags"></i> Lihat Kategori
						</a>
					</div>
				</div>
			</div>
			
			<!-- Slide Default 2 -->
			<div class="hero-slide">
				<div class="hero-overlay"></div>
				<div class="hero-content">
					<h1>Koleksi Keramik Terbaru</h1>
					<p>Hiasi rumah Anda dengan desain elegan dan modern dari koleksi terbaru kami</p>
					<div class="hero-buttons">
						<a href="<?php echo base_url('produk'); ?>" class="btn-hero">
							<i class="fas fa-star"></i> Lihat Koleksi
						</a>
					</div>
				</div>
			</div>
		<?php endif; ?>
	</div>

	<button class="slider-arrow slider-prev" onclick="moveSlide(-1)"><i class="fas fa-chevron-left"></i></button>
	<button class="slider-arrow slider-next" onclick="moveSlide(1)"><i class="fas fa-chevron-right"></i></button>
	
	<div class="hero-slider-controls">
		<?php if(isset($sliders) && !empty($sliders)): ?>
			<?php foreach($sliders as $key => $slide): ?>
				<div class="slider-dot <?php echo $key == 0 ? 'active' : ''; ?>" onclick="currentSlide(<?php echo $key; ?>)"></div>
			<?php endforeach; ?>
		<?php else: ?>
			<div class="slider-dot active" onclick="currentSlide(0)"></div>
			<div class="slider-dot" onclick="currentSlide(1)"></div>
		<?php endif; ?>
	</div>
</section>

<div class="page-header">
	<h1><i class="fas fa-box"></i> Daftar Produk</h1>
	<p>Temukan berbagai produk berkualitas untuk kebutuhan Anda</p>
</div>

<div class="container">
	<!-- Search & Filter Section -->
	<div class="filter-section">
		<!-- Search Form -->
		<div class="search-form">
			<form method="get" action="<?php echo base_url('produk'); ?>">
				<div class="search-wrapper">
					<input type="text" name="q" class="search-input" 
						   placeholder="Cari produk..." 
						   value="<?php echo isset($keyword) ? htmlspecialchars($keyword) : ''; ?>">
					<?php if(isset($selected_kategori) && !empty($selected_kategori)): ?>
						<input type="hidden" name="kategori" value="<?php echo $selected_kategori; ?>">
					<?php endif; ?>
					<button type="submit" class="search-btn">
						<i class="fas fa-search"></i> Cari
					</button>
				</div>
			</form>
		</div>

		<!-- Filter Kategori -->
		<?php if(isset($kategori) && !empty($kategori)): ?>
		<div class="filter-title">
			<i class="fas fa-filter"></i> Filter Kategori
		</div>
		<div class="filter-buttons">
			<a href="<?php echo base_url('produk' . (isset($keyword) && !empty($keyword) ? '?q='.urlencode($keyword) : '')); ?>" 
			   class="filter-btn <?php echo !isset($selected_kategori) || empty($selected_kategori) ? 'active' : ''; ?>">
				Semua
			</a>
			<?php foreach($kategori as $kat): ?>
				<a href="<?php 
					$url = base_url('produk?kategori='.$kat->id_kategori);
					if(isset($keyword) && !empty($keyword)) {
						$url .= '&q='.urlencode($keyword);
					}
					echo $url;
				?>" 
				   class="filter-btn <?php echo (isset($selected_kategori) && $selected_kategori == $kat->id_kategori) ? 'active' : ''; ?>">
					<?php echo htmlspecialchars($kat->nama_kategori); ?>
				</a>
			<?php endforeach; ?>
		</div>
		<?php endif; ?>
	</div>

	<!-- Daftar Produk -->
	<?php if(isset($produk) && !empty($produk)): ?>
		<div class="products-grid">
			<?php foreach($produk as $p): ?>
				<a href="<?php echo base_url('produk/detail/'.(isset($p->id_produk) ? $p->id_produk : 0)); ?>" class="product-card">
					<div class="product-image">
						<?php 
						$gambar = isset($p->gambar_produk) ? $p->gambar_produk : (isset($p->foto_produk) ? $p->foto_produk : (isset($p->gambar) ? $p->gambar : ''));
						if(!empty($gambar)): 
							// Path gambar ada di admin/uploads/produk/
							$image_path = 'http://localhost/gerabah/admin/uploads/produk/'.$gambar;
						?>
							<img src="<?php echo $image_path; ?>" alt="<?php echo isset($p->nama_produk) ? htmlspecialchars($p->nama_produk) : 'Produk'; ?>" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
							<i class="fas fa-image" style="display: none;"></i>
						<?php else: ?>
							<i class="fas fa-image"></i>
						<?php endif; ?>
					</div>
					<div class="product-info">
						<div class="product-category"><?php echo isset($p->nama_kategori) && !empty($p->nama_kategori) ? htmlspecialchars($p->nama_kategori) : 'Kategori'; ?></div>
						<div class="product-name"><?php echo isset($p->nama_produk) ? htmlspecialchars($p->nama_produk) : 'Nama Produk'; ?></div>
						
						<?php 
						// Tampilkan badge stok di atas harga
						$stok = isset($p->stok_produk) ? (int)$p->stok_produk : 0;
						$stok_class = 'cukup';
						$stok_text = 'Stok: ' . $stok;
						
						if($stok == 0) {
							$stok_class = 'habis';
							$stok_text = 'STOK HABIS';
						} elseif($stok <= 10) {
							$stok_class = 'rendah';
							$stok_text = 'STOK RENDAH';
						}
						?>
						<div style="margin-bottom: 10px;">
							<span class="stok-badge <?php echo $stok_class; ?>">
								<?php echo $stok_text; ?>
							</span>
						</div>
						
						<?php 
						// Hitung harga diskon
						$harga = 0;
						if(isset($p->harga_produk) && $p->harga_produk > 0) {
							$harga = $p->harga_produk;
						} else if(isset($p->harga) && $p->harga > 0) {
							$harga = $p->harga;
						}
						
					$harga_info = get_harga_diskon($p, $harga);
					$has_diskon = $harga_info['persen_diskon'] > 0;
					?>
					
					<div style="margin-bottom: 10px;">
						<?php if($has_diskon): ?>
							<!-- Badge Diskon ala Shopee -->
							<span style="background: linear-gradient(135deg, #ff424e 0%, #ff0017 100%); color: white; padding: 4px 10px; border-radius: 3px; font-size: 11px; font-weight: 700; display: inline-block; margin-bottom: 8px; box-shadow: 0 2px 5px rgba(255, 0, 23, 0.3);">
								-<?php echo $harga_info['persen_diskon']; ?>%
							</span>
							<!-- Harga Diskon (Merah, Besar) -->
							<div style="font-size: 20px; font-weight: 700; color: #ff424e; margin-bottom: 3px;">
								Rp<?php echo number_format($harga_info['harga_diskon'], 0, ',', '.'); ?>
							</div>
							<!-- Harga Normal Dicoret (Abu-abu, Kecil) -->
							<div style="font-size: 13px; color: #888; text-decoration: line-through;">
								Rp<?php echo number_format($harga_info['harga_awal'], 0, ',', '.'); ?>
							</div>
						<?php else: ?>
							<!-- Harga Normal -->
							<div class="product-price" style="margin-top: 8px;">
								Rp <?php echo number_format($harga, 0, ',', '.'); ?>
							</div>
						<?php endif; ?>
					</div>
					</div>
				</a>
			<?php endforeach; ?>
		</div>
		
		<!-- Pagination -->
		<?php if(isset($pagination) && !empty($pagination)): ?>
			<?php echo $pagination; ?>
		<?php endif; ?>
	<?php else: ?>
		<div class="empty-state">
			<i class="fas fa-box-open"></i>
			<h3><?php echo (isset($keyword) && !empty($keyword)) ? 'Produk Tidak Ditemukan' : 'Belum Ada Produk'; ?></h3>
			<p><?php echo (isset($keyword) && !empty($keyword)) ? 'Coba gunakan kata kunci lain atau filter kategori yang berbeda' : 'Produk akan muncul di sini setelah ditambahkan oleh admin'; ?></p>
		</div>
	<?php endif; ?>
</div>

<script>
	let slideIndex = 0;
	const slides = document.querySelectorAll('.hero-slide');
	const dots = document.querySelectorAll('.slider-dot');
	let slideInterval;

	function showSlide(n) {
		if (n >= slides.length) slideIndex = 0;
		if (n < 0) slideIndex = slides.length - 1;

		slides.forEach(slide => slide.classList.remove('active'));
		dots.forEach(dot => dot.classList.remove('active'));

		slides[slideIndex].classList.add('active');
		dots[slideIndex].classList.add('active');
	}

	function moveSlide(n) {
		slideIndex += n;
		showSlide(slideIndex);
		resetTimer();
	}

	function currentSlide(n) {
		slideIndex = n;
		showSlide(slideIndex);
		resetTimer();
	}

	function startTimer() {
		slideInterval = setInterval(() => {
			slideIndex++;
			showSlide(slideIndex);
		}, 5000); // 5 seconds
	}

	function resetTimer() {
		clearInterval(slideInterval);
		startTimer();
	}

	// Initialize
	if(slides.length > 0) {
		startTimer();
	}
</script>

