<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?><!DOCTYPE html>
<html lang="id">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Daftar Akun - Marketplace</title>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
	
	<style type="text/css">
		* {
			margin: 0;
			padding: 0;
			box-sizing: border-box;
		}

		body {
			font-family: 'Poppins', sans-serif;
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			min-height: 100vh;
			display: flex;
			justify-content: center;
			align-items: center;
			padding: 20px;
		}

		.register-container {
			background: white;
			border-radius: 20px;
			box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
			overflow: hidden;
			width: 100%;
			max-width: 500px;
			animation: slideUp 0.5s ease-out;
		}

		@keyframes slideUp {
			from {
				opacity: 0;
				transform: translateY(30px);
			}
			to {
				opacity: 1;
				transform: translateY(0);
			}
		}

		.register-header {
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			padding: 40px 30px;
			text-align: center;
			color: white;
		}

		.register-header i {
			font-size: 50px;
			margin-bottom: 15px;
		}

		.register-header h2 {
			font-size: 28px;
			font-weight: 600;
			margin-bottom: 5px;
		}

		.register-header p {
			font-size: 14px;
			opacity: 0.9;
			font-weight: 300;
		}

		.register-body {
			padding: 40px 30px;
		}

		.alert {
			padding: 12px 15px;
			border-radius: 8px;
			margin-bottom: 20px;
			font-size: 14px;
			animation: shake 0.5s;
		}

		.alert-danger {
			background-color: #fee;
			color: #c33;
			border: 1px solid #fcc;
		}

		.alert-success {
			background-color: #efe;
			color: #3c3;
			border: 1px solid #cfc;
		}

		@keyframes shake {
			0%, 100% { transform: translateX(0); }
			10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); }
			20%, 40%, 60%, 80% { transform: translateX(5px); }
		}

		.form-group {
			margin-bottom: 20px;
			position: relative;
		}

		.form-group label {
			display: block;
			margin-bottom: 8px;
			color: #333;
			font-weight: 500;
			font-size: 14px;
		}

		.form-group label .required {
			color: #dc3545;
		}

		.input-wrapper {
			position: relative;
		}

		.input-wrapper i:not(.password-toggle) {
			position: absolute;
			left: 15px;
			top: 50%;
			transform: translateY(-50%);
			color: #999;
			font-size: 16px;
			pointer-events: none;
		}

		.form-control {
			width: 100%;
			padding: 12px 15px 12px 45px;
			border: 2px solid #e0e0e0;
			border-radius: 10px;
			font-size: 15px;
			font-family: 'Poppins', sans-serif;
			transition: all 0.3s ease;
			outline: none;
		}

		.form-control:focus {
		border-color: #d4af37;
		box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
		}

		.input-wrapper:focus-within i:not(.password-toggle) {
			color: #d4af37;
		}

		.password-toggle {
			position: absolute;
			right: 15px;
			top: 50%;
			transform: translateY(-50%);
			cursor: pointer;
			color: #999;
			font-size: 16px;
			z-index: 10;
		}

		.password-toggle:hover {
			color: #d4af37;
		}

		.text-danger {
			color: #dc3545;
			font-size: 12px;
			margin-top: 5px;
			display: block;
		}

		.btn-register {
			width: 100%;
			padding: 14px;
			background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
			color: white;
			border: none;
			border-radius: 10px;
			font-size: 16px;
			font-weight: 600;
			cursor: pointer;
			transition: all 0.3s ease;
			font-family: 'Poppins', sans-serif;
			box-shadow: 0 4px 15px rgba(212, 175, 55, 0.4);
			margin-top: 10px;
		}

		.btn-register:hover {
			transform: translateY(-2px);
			box-shadow: 0 6px 20px rgba(212, 175, 55, 0.6);
		}

		.btn-register:active {
			transform: translateY(0);
		}

		.register-footer {
			text-align: center;
			padding: 20px;
			background-color: #f8f9fa;
			font-size: 13px;
			color: #666;
		}

		.register-footer a {
			color: #d4af37;
			text-decoration: none;
			font-weight: 500;
		}

		.register-footer a:hover {
			text-decoration: underline;
		}

		@media (max-width: 480px) {
			.register-container {
				border-radius: 15px;
			}

			.register-header {
				padding: 30px 20px;
			}

			.register-header h2 {
				font-size: 24px;
			}

			.register-body {
				padding: 30px 20px;
			}
		}
	</style>
</head>
<body>

<div class="register-container">
	<div class="register-header">
		<i class="fas fa-user-plus"></i>
		<h2>Daftar Akun</h2>
		<p>Buat akun baru untuk mulai berbelanja</p>
	</div>

	<div class="register-body">
		<?php if($this->session->flashdata('error')): ?>
			<div class="alert alert-danger">
				<i class="fas fa-exclamation-circle"></i>
				<?php echo $this->session->flashdata('error'); ?>
			</div>
		<?php endif; ?>

		<?php if($this->session->flashdata('success')): ?>
			<div class="alert alert-success">
				<i class="fas fa-check-circle"></i>
				<?php echo $this->session->flashdata('success'); ?>
			</div>
		<?php endif; ?>

		<form action="<?php echo base_url('register/proses'); ?>" method="POST" id="registerForm">
			<div class="form-group">
				<label for="nama_customer">Nama Lengkap <span class="required">*</span></label>
				<div class="input-wrapper">
					<input type="text" 
						   class="form-control <?php echo form_error('nama_customer') ? 'is-invalid' : ''; ?>" 
						   id="nama_customer" 
						   name="nama_customer" 
						   placeholder="Masukkan nama lengkap"
						   value="<?php echo set_value('nama_customer'); ?>"
						   required 
						   autofocus>
					<i class="fas fa-user"></i>
				</div>
				<?php echo form_error('nama_customer', '<span class="text-danger">', '</span>'); ?>
			</div>

			<div class="form-group">
				<label for="email_customer">Email <span class="required">*</span></label>
				<div class="input-wrapper">
					<input type="email" 
						   class="form-control <?php echo form_error('email_customer') ? 'is-invalid' : ''; ?>" 
						   id="email_customer" 
						   name="email_customer" 
						   placeholder="Masukkan email"
						   value="<?php echo set_value('email_customer'); ?>"
						   required>
					<i class="fas fa-envelope"></i>
				</div>
				<?php echo form_error('email_customer', '<span class="text-danger">', '</span>'); ?>
			</div>

			<div class="form-group">
				<label for="telp_customer">No. Telepon</label>
				<div class="input-wrapper">
					<input type="text" 
						   class="form-control <?php echo form_error('telp_customer') ? 'is-invalid' : ''; ?>" 
						   id="telp_customer" 
						   name="telp_customer" 
						   placeholder="Masukkan nomor telepon (opsional)"
						   value="<?php echo set_value('telp_customer'); ?>">
					<i class="fas fa-phone"></i>
				</div>
				<?php echo form_error('telp_customer', '<span class="text-danger">', '</span>'); ?>
			</div>

			<div class="form-group">
				<label for="alamat_customer">Alamat</label>
				<div class="input-wrapper">
					<textarea class="form-control <?php echo form_error('alamat_customer') ? 'is-invalid' : ''; ?>" 
							  id="alamat_customer" 
							  name="alamat_customer" 
							  placeholder="Masukkan alamat lengkap (opsional)"
							  rows="3"><?php echo set_value('alamat_customer'); ?></textarea>
					<i class="fas fa-map-marker-alt" style="top: 15px;"></i>
				</div>
				<?php echo form_error('alamat_customer', '<span class="text-danger">', '</span>'); ?>
			</div>

			<div class="form-group">
				<label for="password_customer">Password <span class="required">*</span></label>
				<div class="input-wrapper">
					<i class="fas fa-lock"></i>
					<input type="password" 
						   class="form-control <?php echo form_error('password_customer') ? 'is-invalid' : ''; ?>" 
						   id="password_customer" 
						   name="password_customer" 
						   placeholder="Masukkan password (min. 6 karakter)"
						   required>
					<i class="fas fa-eye password-toggle" id="togglePassword"></i>
				</div>
				<?php echo form_error('password_customer', '<span class="text-danger">', '</span>'); ?>
			</div>

			<div class="form-group">
				<label for="password_confirm">Konfirmasi Password <span class="required">*</span></label>
				<div class="input-wrapper">
					<i class="fas fa-lock"></i>
					<input type="password" 
						   class="form-control <?php echo form_error('password_confirm') ? 'is-invalid' : ''; ?>" 
						   id="password_confirm" 
						   name="password_confirm" 
						   placeholder="Masukkan ulang password"
						   required>
					<i class="fas fa-eye password-toggle" id="togglePasswordConfirm"></i>
				</div>
				<?php echo form_error('password_confirm', '<span class="text-danger">', '</span>'); ?>
			</div>

			<button type="submit" class="btn-register">
				<i class="fas fa-user-plus"></i> Daftar Sekarang
			</button>
		</form>
	</div>

	<div class="register-footer">
		Sudah punya akun? <a href="<?php echo base_url('akun'); ?>">Masuk di sini</a>
	</div>
</div>

<script>
	// Toggle password visibility
	const togglePassword = document.getElementById('togglePassword');
	const password = document.getElementById('password_customer');
	
	if(togglePassword) {
		togglePassword.addEventListener('click', function() {
			const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
			password.setAttribute('type', type);
			
			this.classList.toggle('fa-eye');
			this.classList.toggle('fa-eye-slash');
		});
	}

	const togglePasswordConfirm = document.getElementById('togglePasswordConfirm');
	const passwordConfirm = document.getElementById('password_confirm');
	
	if(togglePasswordConfirm) {
		togglePasswordConfirm.addEventListener('click', function() {
			const type = passwordConfirm.getAttribute('type') === 'password' ? 'text' : 'password';
			passwordConfirm.setAttribute('type', type);
			
			this.classList.toggle('fa-eye');
			this.classList.toggle('fa-eye-slash');
		});
	}

	// Form validation
	document.getElementById('registerForm').addEventListener('submit', function(e) {
		const password = document.getElementById('password_customer').value;
		const passwordConfirm = document.getElementById('password_confirm').value;

		if(password !== passwordConfirm) {
			e.preventDefault();
			alert('Password dan konfirmasi password tidak cocok!');
			return false;
		}

		if(password.length < 6) {
			e.preventDefault();
			alert('Password minimal 6 karakter!');
			return false;
		}
	});

	// Auto-hide alerts after 5 seconds
	setTimeout(function() {
		const alerts = document.querySelectorAll('.alert');
		alerts.forEach(function(alert) {
			alert.style.transition = 'opacity 0.5s';
			alert.style.opacity = '0';
			setTimeout(function() {
				alert.style.display = 'none';
			}, 500);
		});
	}, 5000);
</script>

</body>
</html>

