<style type="text/css">
	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 50px 20px;
		text-align: center;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.page-header h1 {
		font-size: 36px;
		font-weight: 700;
		margin-bottom: 10px;
	}

	.page-header p {
		font-size: 16px;
		opacity: 0.9;
	}

	.container {
		max-width: 900px;
		margin: 0 auto;
		padding: 0 20px 60px 20px;
	}

	.card {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		overflow: hidden;
		margin-bottom: 30px;
	}

	.card-header {
		background: linear-gradient(135deg, #2c3e5e 0%, #1a1f3a 100%);
		color: white;
		padding: 20px 30px;
		font-weight: 600;
		font-size: 18px;
		display: flex;
		align-items: center;
		gap: 10px;
		border-left: 4px solid #d4af37;
	}

	.card-body {
		padding: 30px;
	}

	.info-row {
		display: grid;
		grid-template-columns: 200px 1fr;
		gap: 20px;
		padding: 15px 0;
		border-bottom: 1px solid #e9ecef;
	}

	.info-row:last-child {
		border-bottom: none;
	}

	.info-label {
		font-weight: 600;
		color: #666;
	}

	.info-value {
		color: #333;
	}

	.badge {
		padding: 8px 15px;
		border-radius: 20px;
		font-size: 12px;
		font-weight: 600;
		display: inline-block;
		text-transform: uppercase;
	}

	.badge-warning {
		background: linear-gradient(135deg, #f39c12, #e67e22);
		color: white;
	}

	.badge-success {
		background: linear-gradient(135deg, #27ae60, #229954);
		color: white;
	}

	.badge-danger {
		background: linear-gradient(135deg, #e74c3c, #c0392b);
		color: white;
	}

	.badge-info {
		background: linear-gradient(135deg, #3498db, #2980b9);
		color: white;
	}

	.note-box {
		background: linear-gradient(135deg, #e3f2fd, #bbdefb);
		border-left: 4px solid #2196f3;
		padding: 15px 20px;
		border-radius: 8px;
	}

	.foto-bukti {
		max-width: 400px;
		border-radius: 10px;
		box-shadow: 0 3px 10px rgba(0,0,0,0.1);
		transition: all 0.3s;
		cursor: pointer;
	}

	.foto-bukti:hover {
		transform: scale(1.02);
		box-shadow: 0 5px 20px rgba(0,0,0,0.2);
	}

	table {
		width: 100%;
		border-collapse: collapse;
		margin-top: 20px;
	}

	table thead {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
	}

	table th {
		padding: 15px;
		text-align: left;
		font-weight: 600;
	}

	table td {
		padding: 15px;
		border-bottom: 1px solid #e9ecef;
		vertical-align: middle;
	}

	table tbody tr:hover {
		background: #f8f9fa;
	}

	.product-image {
		width: 60px;
		height: 60px;
		border-radius: 8px;
		object-fit: cover;
		margin-right: 10px;
		vertical-align: middle;
	}

	.btn-back {
		padding: 15px 40px;
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		font-weight: 700;
		border: none;
		border-radius: 10px;
		font-weight: 600;
		display: inline-flex;
		align-items: center;
		gap: 10px;
		cursor: pointer;
		text-decoration: none;
		transition: all 0.3s;
		margin-top: 20px;
	}

	.btn-back:hover {
		transform: translateY(-2px);
		box-shadow: 0 5px 15px rgba(212, 175, 55, 0.4);
		background: linear-gradient(135deg, #c9a961 0%, #d4af37 100%);
	}

	@media (max-width: 768px) {
		.page-header h1 {
			font-size: 28px;
		}

		.info-row {
			grid-template-columns: 1fr;
			gap: 5px;
		}

		.foto-bukti {
			max-width: 100%;
		}
	}
</style>

<div class="page-header">
	<h1><i class="fas fa-file-invoice"></i> Detail Pengembalian Barang</h1>
	<p>Informasi lengkap pengajuan pengembalian barang Anda</p>
</div>

<div class="container">
	<div class="card">
		<div class="card-header">
			<i class="fas fa-info-circle"></i>
			Detail Pengembalian Barang #<?php echo $retur->id_retur; ?>
		</div>
		<div class="card-body">
			
			<div class="info-row">
				<div class="info-label">Order ID</div>
				<div class="info-value"><strong>#<?php echo $retur->order_id; ?></strong></div>
			</div>
			
			<div class="info-row">
				<div class="info-label">Tanggal Ajukan</div>
				<div class="info-value"><?php echo date('d M Y H:i:s', strtotime($retur->created_at)); ?></div>
			</div>
			
			<div class="info-row">
				<div class="info-label">Jenis Pengembalian</div>
				<div class="info-value">
					<?php 
					$jenis = isset($retur->jenis_retur) ? $retur->jenis_retur : 'tukar_barang';
					if($jenis == 'refund_dana') {
						echo '<span class="badge badge-info"><i class="fas fa-money-bill-wave"></i> Refund Dana</span>';
					} else {
						echo '<span class="badge badge-warning"><i class="fas fa-exchange-alt"></i> Tukar Barang</span>';
					}
					?>
				</div>
			</div>

			<?php if(isset($retur->jenis_retur) && $retur->jenis_retur == 'refund_dana'): ?>
			<div class="info-row">
				<div class="info-label">Info Rekening</div>
				<div class="info-value">
					<strong>Bank:</strong> <?php echo isset($retur->bank_customer) ? $retur->bank_customer : '-'; ?><br>
					<strong>No. Rek:</strong> <?php echo isset($retur->rekening_customer) ? $retur->rekening_customer : '-'; ?><br>
					<strong>A.N:</strong> <?php echo isset($retur->an_customer) ? $retur->an_customer : '-'; ?><br>
					<strong>Nominal:</strong> Rp <?php echo isset($retur->nominal_refund) ? number_format($retur->nominal_refund, 0, ',', '.') : '0'; ?>
				</div>
			</div>
			<?php endif; ?>

			<div class="info-row">
				<div class="info-label">Status</div>
				<div class="info-value">
					<?php 
					$status = isset($retur->status_retur) ? strtolower(trim($retur->status_retur)) : '';
					if($status == 'pending'): ?>
						<span class="badge badge-warning">Pending</span>
					<?php elseif($status == 'diterima' || $status == 'disetujui'): ?>
						<span class="badge badge-success">Disetujui</span>
					<?php elseif($status == 'ditolak'): ?>
						<span class="badge badge-danger">Ditolak</span>
					<?php elseif($status == 'diproses'): ?>
						<span class="badge badge-info">Diproses</span>
					<?php elseif($status == 'selesai'): ?>
						<span class="badge badge-success">Selesai</span>
					<?php else: ?>
						<span class="badge badge-secondary"><?php echo ucfirst($status); ?></span>
					<?php endif; ?>
				</div>
			</div>
			
			<div class="info-row">
				<div class="info-label">Alasan Pengembalian</div>
				<div class="info-value"><?php echo nl2br(htmlspecialchars($retur->alasan_retur)); ?></div>
			</div>
			
			<?php if(!empty($retur->catatan_admin)): ?>
			<div class="info-row">
				<div class="info-label">Catatan Admin</div>
				<div class="info-value">
					<div class="note-box">
						<i class="fas fa-comment-dots"></i>
						<?php echo nl2br(htmlspecialchars($retur->catatan_admin)); ?>
					</div>
				</div>
			</div>
			<?php endif; ?>
			
			<?php if(!empty($retur->foto_bukti)): ?>
			<div class="info-row">
				<div class="info-label">Foto Bukti (Anda)</div>
				<div class="info-value">
					<?php 
					// Path foto bukti - disimpan di customer/uploads/retur/
					$foto_url = 'http://localhost/gerabah/customer/uploads/retur/'.$retur->foto_bukti;
					// Fallback ke base_url jika absolute path tidak bekerja
					$foto_url_fallback = base_url('uploads/retur/'.$retur->foto_bukti);
					?>
					<a href="<?php echo $foto_url; ?>" target="_blank" onclick="if(!this.href.includes('localhost')) this.href='<?php echo $foto_url_fallback; ?>'; return true;">
						<img src="<?php echo $foto_url; ?>" alt="Foto Bukti" class="foto-bukti" onerror="this.onerror=null; this.src='<?php echo $foto_url_fallback; ?>'; this.parentElement.href='<?php echo $foto_url_fallback; ?>';">
					</a>
				</div>
			</div>
			<?php endif; ?>

			<?php if(!empty($retur->bukti_transfer)): ?>
			<div class="info-row">
				<div class="info-label">Bukti Transfer (Admin)</div>
				<div class="info-value">
					<?php 
					// Path bukti transfer
					$bukti_url = 'http://localhost/gerabah/customer/uploads/retur/'.$retur->bukti_transfer;
					$bukti_url_fallback = base_url('uploads/retur/'.$retur->bukti_transfer);
					?>
					<a href="<?php echo $bukti_url; ?>" target="_blank" onclick="if(!this.href.includes('localhost')) this.href='<?php echo $bukti_url_fallback; ?>'; return true;">
						<img src="<?php echo $bukti_url; ?>" alt="Bukti Transfer" class="foto-bukti" onerror="this.onerror=null; this.src='<?php echo $bukti_url_fallback; ?>'; this.parentElement.href='<?php echo $bukti_url_fallback; ?>';">
					</a>
					<div style="margin-top: 5px; font-size: 12px; color: #666;">
						<i class="fas fa-check-circle" style="color: #28a745;"></i> Bukti transfer pengembalian dana
					</div>
				</div>
			</div>
			<?php endif; ?>

			<?php if(!empty($retur->bukti_transfer)): ?>
			<div class="info-row">
				<div class="info-label">Bukti Transfer (Admin)</div>
				<div class="info-value">
					<?php 
					// Path bukti transfer - disimpan di customer/uploads/retur/
					$bukti_url = 'http://localhost/gerabah/customer/uploads/retur/'.$retur->bukti_transfer;
					$bukti_url_fallback = base_url('uploads/retur/'.$retur->bukti_transfer);
					?>
					<a href="<?php echo $bukti_url; ?>" target="_blank" onclick="if(!this.href.includes('localhost')) this.href='<?php echo $bukti_url_fallback; ?>'; return true;">
						<img src="<?php echo $bukti_url; ?>" alt="Bukti Transfer" class="foto-bukti" onerror="this.onerror=null; this.src='<?php echo $bukti_url_fallback; ?>'; this.parentElement.href='<?php echo $bukti_url_fallback; ?>';">
					</a>
				</div>
			</div>
			<?php endif; ?>
						
		
		</div>
	</div>
	
	<?php if(!empty($retur_items)): ?>
	<div class="card">
		<div class="card-header">
			<i class="fas fa-box"></i>
			Produk yang Dikembalikan
		</div>
		<div class="card-body">
			<table>
				<thead>
					<tr>
						<th>Produk</th>
						<th width="100" style="text-align: center;">Qty</th>
						<th width="150" style="text-align: right;">Harga</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach($retur_items as $item): ?>
					<tr>
						<td>
							<?php if(!empty($item->gambar_produk)): ?>
							<img src="<?php echo base_url('../admin/uploads/produk/'.$item->gambar_produk); ?>" alt="<?php echo htmlspecialchars($item->nama_produk); ?>" class="product-image">
							<?php endif; ?>
							<?php echo htmlspecialchars($item->nama_produk); ?>
						</td>
						<td style="text-align: center;"><?php echo $item->qty; ?></td>
						<td style="text-align: right;"><strong>Rp <?php echo number_format($item->harga_produk); ?></strong></td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		</div>
	</div>
	<?php endif; ?>
	
	<div style="text-align: center;">
		<a href="<?php echo base_url('retur'); ?>" class="btn-back">
			<i class="fas fa-arrow-left"></i> Kembali ke Daftar Pengembalian Barang
		</a>
	</div>
</div>


