<style type="text/css">
	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 50px 20px;
		text-align: center;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.page-header h1 {
		font-size: 36px;
		font-weight: 700;
		margin-bottom: 10px;
	}

	.page-header p {
		font-size: 16px;
		opacity: 0.9;
	}

	.container {
		max-width: 900px;
		margin: 0 auto;
		padding: 0 20px 60px 20px;
	}

	.card {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		overflow: hidden;
		margin-bottom: 30px;
	}

	.card-header {
		background: linear-gradient(135deg, #2c3e5e 0%, #1a1f3a 100%);
		color: white;
		padding: 20px 30px;
		font-weight: 600;
		font-size: 18px;
		display: flex;
		align-items: center;
		gap: 10px;
		border-left: 4px solid #d4af37;
	}

	.card-body {
		padding: 30px;
	}

	.info-box {
		background: linear-gradient(135deg, #e3f2fd, #bbdefb);
		border-left: 4px solid #2196f3;
		padding: 20px;
		border-radius: 8px;
		margin-bottom: 30px;
	}

	.info-box i {
		color: #2196f3;
		margin-right: 10px;
	}

	.info-box strong {
		color: #1976d2;
	}

	.warning-box {
		background: linear-gradient(135deg, #fff3e0, #ffe0b2);
		border-left: 4px solid #ff9800;
		padding: 20px;
		border-radius: 8px;
		margin-top: 30px;
	}

	.warning-box i {
		color: #f57c00;
		margin-right: 10px;
	}

	.form-group {
		margin-bottom: 25px;
	}

	.form-group label {
		display: block;
		margin-bottom: 10px;
		font-weight: 600;
		color: #333;
	}

	.form-group .required {
		color: #e74c3c;
	}

	.form-group .text-muted {
		color: #999;
		font-size: 12px;
		font-weight: normal;
		margin-left: 5px;
	}

	.form-group small {
		display: block;
		margin-top: 8px;
		color: #666;
		font-size: 13px;
	}

	.form-control {
		width: 100%;
		padding: 12px 15px;
		border: 2px solid #e9ecef;
		border-radius: 8px;
		font-size: 15px;
		transition: all 0.3s;
	}

	.form-control:focus {
		outline: none;
		border-color: #d4af37;
		box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.1);
	}

	textarea.form-control {
		resize: vertical;
		min-height: 120px;
	}

	.checkbox {
		margin-bottom: 12px;
	}

	.checkbox label {
		display: flex;
		align-items: flex-start;
		font-weight: normal;
		cursor: pointer;
		padding: 12px;
		background: #f8f9fa;
		border-radius: 8px;
		transition: all 0.3s;
	}

	.checkbox label:hover {
		background: #e9ecef;
	}

	.checkbox input[type="checkbox"] {
		margin-right: 10px;
		margin-top: 4px;
		width: 18px;
		height: 18px;
		cursor: pointer;
	}

	.button-group {
		display: flex;
		gap: 15px;
		justify-content: center;
		margin-top: 40px;
	}

	.btn {
		padding: 15px 40px;
		border: none;
		border-radius: 10px;
		font-weight: 600;
		font-size: 16px;
		cursor: pointer;
		display: inline-flex;
		align-items: center;
		gap: 10px;
		text-decoration: none;
		transition: all 0.3s;
	}

	.btn-default {
		background: #6c757d;
		color: white;
	}

	.btn-default:hover {
		background: #5a6268;
		transform: translateY(-2px);
		box-shadow: 0 5px 15px rgba(108, 117, 125, 0.3);
	}

	.btn-danger {
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		font-weight: 700;
	}

	.btn-danger:hover {
		background: linear-gradient(135deg, #c9a961 0%, #d4af37 100%);
		transform: translateY(-2px);
		box-shadow: 0 5px 15px rgba(212, 175, 55, 0.4);
	}

	@media (max-width: 768px) {
		.page-header h1 {
			font-size: 28px;
		}

		.button-group {
			flex-direction: column;
		}

		.btn {
			width: 100%;
			justify-content: center;
		}
	}
</style>

<div class="page-header">
	<h1><i class="fas fa-rotate-left"></i> Ajukan Pengembalian Barang</h1>
	<p>Isi formulir di bawah untuk mengajukan pengembalian barang</p>
</div>

<div class="container">
	<div class="card">
		<div class="card-header">
			<i class="fas fa-file-alt"></i>
			Formulir Pengajuan Pengembalian Barang
		</div>
		<div class="card-body">
			
			<div class="info-box">
				<i class="fas fa-info-circle"></i> <strong>Informasi Transaksi:</strong><br>
				Order ID: <strong>#<?php echo isset($transaksi->order_id) ? $transaksi->order_id : $transaksi->id_transaksi; ?></strong><br>
				Tanggal: <?php echo date('d M Y H:i', strtotime($transaksi->tanggal_transaksi)); ?><br>
				Total: <strong>Rp <?php echo number_format(isset($transaksi->total) ? $transaksi->total : (isset($transaksi->total_harga) ? $transaksi->total_harga : 0)); ?></strong>
			</div>
						
						<form action="<?php echo base_url('retur/proses'); ?>" method="post" enctype="multipart/form-data">
							<input type="hidden" name="id_transaksi" value="<?php echo $transaksi->id_transaksi; ?>">
							
							<div class="form-group">
								<label>Pilih Produk yang Dikembalikan <span class="text-muted">(Opsional)</span></label>
								<?php foreach($transaksi_detail as $detail): ?>
								<div class="product-item-row" style="margin-bottom: 15px; padding: 15px; background: #f8f9fa; border-radius: 8px; border: 1px solid #e9ecef;">
									<div style="display: flex; align-items: center; justify-content: space-between; flex-wrap: wrap; gap: 15px;">
										<div style="display: flex; align-items: center; flex: 1;">
											<input type="checkbox" name="produk_retur_id[]" value="<?php echo $detail->id_produk; ?>" id="check_<?php echo $detail->id_produk; ?>" data-harga="<?php echo $detail->harga; ?>" onchange="toggleQty(<?php echo $detail->id_produk; ?>)" style="width: 20px; height: 20px; margin-right: 15px; cursor: pointer;">
											<label for="check_<?php echo $detail->id_produk; ?>" style="margin: 0; cursor: pointer; font-weight: 600;">
												<?php echo $detail->nama_produk; ?>
												<br>
												<small class="text-muted" style="font-weight: normal;">Dibeli: <?php echo $detail->qty; ?> unit x Rp <?php echo number_format($detail->harga); ?></small>
											</label>
										</div>
										<div style="width: 150px;">
											<label for="qty_<?php echo $detail->id_produk; ?>" style="font-size: 12px; margin-bottom: 5px; display: block;">Jumlah Retur:</label>
											<input type="number" name="produk_retur_qty[<?php echo $detail->id_produk; ?>]" id="qty_<?php echo $detail->id_produk; ?>" value="1" min="1" max="<?php echo $detail->qty; ?>" class="form-control" disabled style="padding: 8px;" onchange="calculateRefund()" onkeyup="calculateRefund()">
											<small class="text-muted">Max: <?php echo $detail->qty; ?></small>
										</div>
									</div>
								</div>
								<?php endforeach; ?>
								<small class="text-muted">Kosongkan jika ingin mengembalikan seluruh pesanan</small>
							</div>

							<div class="form-group">
								<label>Jenis Pengembalian <span class="text-danger">*</span></label>
								<div class="radio-group">
									<label class="radio-inline">
										<input type="radio" name="jenis_retur" value="tukar_barang" checked onclick="toggleRefundFields()"> 
										<i class="fas fa-exchange-alt"></i> Tukar Barang
									</label>
									<label class="radio-inline">
										<input type="radio" name="jenis_retur" value="refund_dana" onclick="toggleRefundFields()"> 
										<i class="fas fa-money-bill-wave"></i> Pengembalian Dana (Refund)
									</label>
								</div>
							</div>

							<div id="refund-fields" style="display: none; background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 25px; border: 1px solid #ddd;">
								<h4 style="margin-top: 0; margin-bottom: 15px; font-size: 16px; border-bottom: 1px solid #eee; padding-bottom: 10px;">
									<i class="fas fa-university"></i> Data Rekening Tujuan
								</h4>
								<div class="row">
									<div class="col-md-4">
										<div class="form-group">
											<label>Nama Bank</label>
											<input type="text" name="bank_customer" class="form-control" placeholder="Contoh: BCA, Mandiri, BRI">
										</div>
									</div>
									<div class="col-md-4">
										<div class="form-group">
											<label>Nomor Rekening</label>
											<input type="text" name="rekening_customer" class="form-control" placeholder="Nomor Rekening">
										</div>
									</div>
									<div class="col-md-4">
										<div class="form-group">
											<label>Atas Nama</label>
											<input type="text" name="an_customer" class="form-control" placeholder="Nama Pemilik Rekening">
										</div>
									</div>
								</div>
								<div class="form-group">
									<label>Nominal Refund (Otomatis)</label>
									<input type="number" name="nominal_refund" id="nominal_refund" class="form-control" placeholder="Akan terisi otomatis berdasarkan barang yang dipilih" readonly>
									<small class="text-muted">Total estimasi refund berdasarkan harga produk yang dikembalikan</small>
								</div>
							</div>
							
							<div class="form-group">
								<label>Alasan Pengembalian <span class="text-danger">*</span></label>
								<textarea name="alasan_retur" class="form-control" rows="5" placeholder="Jelaskan alasan pengembalian Anda..." required></textarea>
								<small class="text-muted">Contoh: Produk rusak, tidak sesuai deskripsi, salah kirim, dll.</small>
							</div>
							
							<div class="form-group">
								<label>Foto Bukti <span class="text-muted">(Opsional)</span></label>
								<input type="file" name="foto_bukti" class="form-control" accept="image/*">
								<small class="text-muted">Upload foto produk sebagai bukti (Max 2MB, format: JPG, PNG, GIF)</small>
							</div>
							
			<div class="warning-box">
				<i class="fas fa-exclamation-triangle"></i> <strong>Perhatian:</strong><br>
				• Pastikan alasan pengembalian jelas dan detail<br>
				• Foto bukti akan mempercepat proses verifikasi<br>
				• Pengembalian akan diproses maksimal 3 hari kerja<br>
				• Produk harus dalam kondisi baik dan lengkap
			</div>
			
			<div class="button-group">
				<a href="<?php echo base_url('transaksi/detail/'.$transaksi->id_transaksi); ?>" class="btn btn-default">
					<i class="fas fa-arrow-left"></i> Kembali
				</a>
				<button type="submit" class="btn btn-danger">
					<i class="fas fa-paper-plane"></i> Ajukan Pengembalian
				</button>
			</div>
			
		</form>
		
	</div>
</div>
</div>

<script>
function toggleQty(id) {
	var checkbox = document.getElementById('check_' + id);
	var qtyInput = document.getElementById('qty_' + id);
	
	if(checkbox.checked) {
		qtyInput.removeAttribute('disabled');
	} else {
		qtyInput.setAttribute('disabled', 'disabled');
		qtyInput.value = 1; // Reset to default
	}
	calculateRefund();
}

function calculateRefund() {
	var checkboxes = document.getElementsByName('produk_retur_id[]');
	var totalRefund = 0;
	
	for(var i = 0; i < checkboxes.length; i++) {
		if(checkboxes[i].checked) {
			var id = checkboxes[i].value;
			var price = parseFloat(checkboxes[i].getAttribute('data-harga'));
			var qtyInput = document.getElementById('qty_' + id);
			var qty = parseInt(qtyInput.value) || 0;
			
			totalRefund += price * qty;
		}
	}
	
	var nominalInput = document.getElementById('nominal_refund');
	if(nominalInput) {
		nominalInput.value = totalRefund;
	}
}

function toggleRefundFields() {
	var type = document.querySelector('input[name="jenis_retur"]:checked').value;
	var fields = document.getElementById('refund-fields');
	
	if(type === 'refund_dana') {
		fields.style.display = 'block';
		document.getElementsByName('bank_customer')[0].setAttribute('required', 'required');
		document.getElementsByName('rekening_customer')[0].setAttribute('required', 'required');
		document.getElementsByName('an_customer')[0].setAttribute('required', 'required');
		calculateRefund(); // Recalculate when showing fields
	} else {
		fields.style.display = 'none';
		document.getElementsByName('bank_customer')[0].removeAttribute('required');
		document.getElementsByName('rekening_customer')[0].removeAttribute('required');
		document.getElementsByName('an_customer')[0].removeAttribute('required');
	}
}
</script>


