<style type="text/css">
	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 50px 20px;
		text-align: center;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.page-header h1 {
		font-size: 36px;
		font-weight: 700;
		margin-bottom: 10px;
	}

	.page-header p {
		font-size: 16px;
		opacity: 0.9;
	}

	.container {
		max-width: 1200px;
		margin: 0 auto;
		padding: 0 20px 60px 20px;
	}

	.card {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		overflow: hidden;
		margin-bottom: 30px;
	}

	.card-header {
		background: linear-gradient(135deg, #2c3e5e 0%, #1a1f3a 100%);
		color: white;
		padding: 20px 30px;
		font-weight: 600;
		font-size: 18px;
		display: flex;
		align-items: center;
		gap: 10px;
		border-left: 4px solid #d4af37;
	}

	.card-body {
		padding: 30px;
	}

	.empty-state {
		text-align: center;
		padding: 60px 20px;
	}

	.empty-state i {
		font-size: 64px;
		color: #2c3e5e;
		margin-bottom: 20px;
		opacity: 0.2;
	}

	.empty-state h3 {
		color: #333;
		margin-bottom: 10px;
		font-size: 24px;
	}

	.empty-state p {
		color: #666;
		font-size: 16px;
	}

	.table-responsive {
		overflow-x: auto;
	}

	table {
		width: 100%;
		border-collapse: collapse;
	}

	table thead {
		background: linear-gradient(135deg, #2c3e5e 0%, #1a1f3a 100%);
		color: white;
	}

	table th {
		padding: 15px;
		text-align: left;
		font-weight: 600;
	}

	table td {
		padding: 15px;
		border-bottom: 1px solid #e9ecef;
		vertical-align: middle;
	}

	table tbody tr:hover {
		background: #f8f9fa;
		transition: background 0.3s;
	}

	.badge {
		padding: 8px 15px;
		border-radius: 20px;
		font-size: 12px;
		font-weight: 600;
		display: inline-block;
		text-transform: uppercase;
	}

	.badge-warning {
		background: linear-gradient(135deg, #f39c12, #e67e22);
		color: white;
	}

	.badge-success {
		background: linear-gradient(135deg, #27ae60, #229954);
		color: white;
	}

	.badge-danger {
		background: linear-gradient(135deg, #e74c3c, #c0392b);
		color: white;
	}

	.badge-info {
		background: linear-gradient(135deg, #3498db, #2980b9);
		color: white;
	}

	.btn-detail {
		padding: 8px 20px;
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		border: none;
		border-radius: 8px;
		font-weight: 700;
		text-decoration: none;
		display: inline-flex;
		align-items: center;
		gap: 8px;
		cursor: pointer;
		transition: all 0.3s;
	}

	.btn-detail:hover {
		transform: translateY(-2px);
		box-shadow: 0 5px 15px rgba(212, 175, 55, 0.4);
		background: linear-gradient(135deg, #c9a961 0%, #d4af37 100%);
	}

	@media (max-width: 768px) {
		.page-header h1 {
			font-size: 28px;
		}

		table {
			font-size: 14px;
		}

		table th, table td {
			padding: 10px;
		}
	}
</style>

<div class="page-header">
	<h1><i class="fas fa-rotate-left"></i> Pengembalian Barang Saya</h1>
	<p>Kelola pengajuan pengembalian barang Anda</p>
</div>

<div class="container">
	<?php if(empty($retur)): ?>
		<div class="card">
			<div class="card-body">
				<div class="empty-state">
					<i class="fas fa-box-open"></i>
					<h3>Belum Ada Pengembalian Barang</h3>
					<p>Anda belum pernah mengajukan pengembalian barang. Jika ada masalah dengan pesanan, Anda dapat mengajukan pengembalian dari halaman detail transaksi.</p>
				</div>
			</div>
		</div>
	<?php else: ?>
		<div class="card">
			<div class="card-header">
				<i class="fas fa-list"></i>
				Daftar Pengembalian Barang
			</div>
			<div class="card-body">
				<div class="table-responsive">
					<table>
						<thead>
							<tr>
								<th width="60">No</th>
								<th>Order ID</th>
								<th>Tanggal Ajukan</th>
								<th>Jenis</th>
								<th>Alasan</th>
								<th width="120" style="text-align: center;">Status</th>
								<th width="120" style="text-align: center;">Aksi</th>
							</tr>
						</thead>
						<tbody>
							<?php 
							$no = 1;
							foreach($retur as $r): 
							?>
							<tr>
								<td><?php echo $no++; ?></td>
								<td><strong>#<?php echo $r->order_id; ?></strong></td>
								<td><?php echo date('d M Y H:i', strtotime($r->created_at)); ?></td>
								<td>
									<?php 
									$jenis = isset($r->jenis_retur) ? $r->jenis_retur : 'tukar_barang';
									if($jenis == 'refund_dana') {
										echo '<span class="badge badge-info"><i class="fas fa-money-bill-wave"></i> Refund</span>';
									} else {
										echo '<span class="badge badge-warning"><i class="fas fa-exchange-alt"></i> Tukar</span>';
									}
									?>
								</td>
								<td><?php echo substr($r->alasan_retur, 0, 50) . (strlen($r->alasan_retur) > 50 ? '...' : ''); ?></td>
								<td style="text-align: center;">
									<?php 
									$status = isset($r->status_retur) ? strtolower(trim($r->status_retur)) : '';
									if($status == 'pending'): ?>
										<span class="badge badge-warning">Pending</span>
									<?php elseif($status == 'diterima' || $status == 'disetujui'): ?>
										<span class="badge badge-success">Disetujui</span>
									<?php elseif($status == 'ditolak'): ?>
										<span class="badge badge-danger">Ditolak</span>
									<?php elseif($status == 'diproses'): ?>
										<span class="badge badge-info">Diproses</span>
									<?php elseif($status == 'selesai'): ?>
										<span class="badge badge-success">Selesai</span>
									<?php else: ?>
										<span class="badge badge-secondary"><?php echo ucfirst($status); ?></span>
									<?php endif; ?>
								</td>
								<td style="text-align: center;">
									<a href="<?php echo base_url('retur/detail/'.$r->id_retur); ?>" class="btn-detail">
										<i class="fas fa-eye"></i> Detail
									</a>
								</td>
							</tr>
							<?php endforeach; ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	<?php endif; ?>
</div>
