<style type="text/css">
	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 50px 20px;
		text-align: center;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.page-header h1 {
		font-size: 38px;
		font-weight: 700;
		margin-bottom: 10px;
		letter-spacing: 0.5px;
	}

	.page-header p {
		font-size: 16px;
		opacity: 0.9;
	}

	.container {
		max-width: 1200px;
		margin: 0 auto;
		padding: 0 20px 40px;
	}

	.card {
		background: white;
		border-radius: 16px;
		box-shadow: 0 8px 30px rgba(0,0,0,0.12);
		overflow: hidden;
		margin-bottom: 30px;
		transition: transform 0.3s, box-shadow 0.3s;
	}

	.card:hover {
		transform: translateY(-2px);
		box-shadow: 0 12px 40px rgba(0,0,0,0.15);
	}

	.card-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 22px 35px;
		font-weight: 600;
		font-size: 19px;
		display: flex;
		align-items: center;
		gap: 12px;
		border-bottom: 2px solid rgba(212, 175, 55, 0.2);
	}

	.card-header i {
		font-size: 20px;
		color: #d4af37;
	}

	.card-body {
		padding: 35px;
	}

	.info-row {
		display: grid;
		grid-template-columns: 220px 1fr;
		gap: 25px;
		padding: 18px 0;
		border-bottom: 1px solid #f0f0f0;
		align-items: center;
	}

	.info-row:last-child {
		border-bottom: none;
	}

	.info-label {
		font-weight: 600;
		color: #555;
		font-size: 14px;
		text-transform: uppercase;
		letter-spacing: 0.5px;
	}

	.info-value {
		color: #2c3e5e;
		font-size: 15px;
		line-height: 1.6;
	}

	.badge {
		padding: 8px 18px;
		border-radius: 25px;
		font-size: 13px;
		font-weight: 600;
		display: inline-block;
		letter-spacing: 0.3px;
		box-shadow: 0 2px 8px rgba(0,0,0,0.1);
	}

	.badge-success {
		background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
		color: white;
	}

	.badge-warning {
		background: linear-gradient(135deg, #ffc107 0%, #ffb300 100%);
		color: #1a1f3a;
	}

	.badge-danger {
		background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
		color: white;
	}

	.badge-info {
		background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
		color: white;
	}

	.table-responsive {
		overflow-x: auto;
		margin-top: 25px;
		border-radius: 10px;
		overflow: hidden;
	}

	table {
		width: 100%;
		border-collapse: collapse;
		background: white;
	}

	table thead {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
	}

	table th {
		padding: 18px 20px;
		text-align: left;
		font-weight: 600;
		font-size: 14px;
		text-transform: uppercase;
		letter-spacing: 0.5px;
		border-right: 1px solid rgba(255,255,255,0.1);
	}

	table th:last-child {
		border-right: none;
	}

	table td {
		padding: 20px;
		border-bottom: 1px solid #f0f0f0;
		vertical-align: middle;
	}

	table tbody tr {
		transition: background 0.2s;
	}

	table tbody tr:hover {
		background: #f8f9fa;
	}

	table tbody tr:last-child td {
		border-bottom: none;
	}

	.item-image {
		width: 70px;
		height: 70px;
		border-radius: 10px;
		background: linear-gradient(135deg, #f5f7fa 0%, #e8ecf1 100%);
		display: flex;
		align-items: center;
		justify-content: center;
		overflow: hidden;
		border: 2px solid #f0f0f0;
		flex-shrink: 0;
	}

	.item-image img {
		width: 100%;
		height: 100%;
		object-fit: cover;
	}

	.item-image i {
		font-size: 28px;
		color: #1a1f3a;
		opacity: 0.25;
	}

	.price {
		font-weight: 700;
		color: #1a1f3a;
		font-size: 15px;
	}

	.product-name {
		font-weight: 600;
		color: #2c3e5e;
		margin-bottom: 6px;
		font-size: 15px;
	}

	.product-category {
		font-size: 13px;
		color: #888;
	}

	.summary-section {
		margin-top: 35px;
		padding: 25px;
		background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
		border-radius: 12px;
		border: 1px solid #e9ecef;
	}

	.summary-row {
		display: flex;
		justify-content: space-between;
		align-items: center;
		margin-bottom: 18px;
		font-size: 16px;
		padding: 8px 0;
	}

	.summary-row:last-of-type {
		margin-bottom: 0;
	}

	.summary-label {
		color: #555;
		font-weight: 500;
		font-size: 15px;
	}

	.summary-value {
		font-weight: 700;
		color: #2c3e5e;
		font-size: 16px;
	}

	.summary-total {
		display: flex;
		justify-content: space-between;
		align-items: center;
		margin-top: 20px;
		padding-top: 22px;
		border-top: 3px solid #d4af37;
		font-size: 22px;
		font-weight: 700;
		background: linear-gradient(135deg, rgba(212, 175, 55, 0.05) 0%, rgba(212, 175, 55, 0.02) 100%);
		padding: 20px;
		margin: 20px -25px -25px;
		border-radius: 0 0 12px 12px;
	}

	.summary-total-label {
		color: #1a1f3a;
		font-size: 18px;
		text-transform: uppercase;
		letter-spacing: 0.5px;
	}

	.summary-total-value {
		color: #d4af37;
		font-size: 24px;
		text-shadow: 0 2px 4px rgba(212, 175, 55, 0.2);
	}

	.btn-back {
		display: inline-flex;
		align-items: center;
		gap: 10px;
		padding: 14px 32px;
		background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%);
		color: white;
		text-decoration: none;
		border-radius: 10px;
		font-weight: 600;
		font-size: 15px;
		transition: all 0.3s;
		margin-top: 20px;
		box-shadow: 0 4px 12px rgba(108, 117, 125, 0.3);
	}

	.btn-back:hover {
		background: linear-gradient(135deg, #5a6268 0%, #495057 100%);
		transform: translateY(-2px);
		box-shadow: 0 6px 18px rgba(108, 117, 125, 0.4);
		color: white;
	}

	.btn-return {
		padding: 14px 40px;
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		border: none;
		border-radius: 10px;
		font-weight: 700;
		font-size: 15px;
		display: inline-flex;
		align-items: center;
		gap: 10px;
		cursor: pointer;
		box-shadow: 0 5px 18px rgba(212, 175, 55, 0.35);
		transition: all 0.3s;
		margin-left: 12px;
		text-decoration: none;
	}

	.btn-return:hover {
		background: linear-gradient(135deg, #c9a961 0%, #d4af37 100%);
		transform: translateY(-2px);
		box-shadow: 0 8px 24px rgba(212, 175, 55, 0.45);
		color: #1a1f3a;
	}

	.btn-cancel {
		padding: 14px 40px;
		background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
		color: white;
		border: none;
		border-radius: 10px;
		font-weight: 700;
		font-size: 15px;
		display: inline-flex;
		align-items: center;
		gap: 10px;
		cursor: pointer;
		box-shadow: 0 5px 18px rgba(220, 53, 69, 0.35);
		transition: all 0.3s;
		margin-left: 12px;
		text-decoration: none;
	}

	.btn-cancel:hover {
		background: linear-gradient(135deg, #c82333 0%, #dc3545 100%);
		transform: translateY(-2px);
		box-shadow: 0 8px 24px rgba(220, 53, 69, 0.45);
		color: white;
	}

	.btn-refresh {
		padding: 6px 16px;
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		border: none;
		border-radius: 6px;
		font-weight: 600;
		font-size: 12px;
		text-decoration: none;
		display: inline-flex;
		align-items: center;
		gap: 6px;
		margin-left: 12px;
		transition: all 0.3s;
		box-shadow: 0 2px 8px rgba(212, 175, 55, 0.3);
	}

	.btn-refresh:hover {
		background: linear-gradient(135deg, #c9a961 0%, #d4af37 100%);
		transform: translateY(-1px);
		box-shadow: 0 4px 12px rgba(212, 175, 55, 0.4);
		color: #1a1f3a;
	}

	.action-buttons {
		display: flex;
		justify-content: center;
		align-items: center;
		gap: 15px;
		flex-wrap: wrap;
		margin-top: 35px;
		padding-top: 30px;
		border-top: 2px solid #f0f0f0;
	}

	@media (max-width: 768px) {
		.info-row {
			grid-template-columns: 1fr;
			gap: 8px;
		}

		.card-body {
			padding: 25px 20px;
		}

		.card-header {
			padding: 18px 20px;
			font-size: 17px;
		}

		.summary-total {
			flex-direction: column;
			align-items: flex-start;
			gap: 10px;
		}

		.action-buttons {
			flex-direction: column;
		}

		.btn-return {
			margin-left: 0;
			width: 100%;
			justify-content: center;
		}
	}
</style>




<div class="container">
	<?php if($transaksi): ?>
		<div class="card">
			<div class="card-header">
				<i class="fas fa-info-circle"></i>
				Informasi Transaksi
			</div>
			<div class="card-body">
				<div class="info-row">
					<div class="info-label">ID Transaksi</div>
					<div class="info-value"><strong>#<?php echo isset($transaksi->id_transaksi) ? $transaksi->id_transaksi : '-'; ?></strong></div>
				</div>
				<div class="info-row">
					<div class="info-label">Tanggal</div>
					<div class="info-value">
						<?php 
						$tanggal = isset($transaksi->tanggal_transaksi) ? $transaksi->tanggal_transaksi : (isset($transaksi->created_at) ? $transaksi->created_at : '-');
						if($tanggal != '-') {
							echo date('d F Y H:i', strtotime($tanggal));
						} else {
							echo '-';
						}
						?>
					</div>
				</div>
				<div class="info-row">
					<div class="info-label">Status</div>
					<div class="info-value">
						<?php
						// Gunakan status_transaksi jika ada, jika tidak gunakan status
						$status = isset($transaksi->status_transaksi) ? strtolower($transaksi->status_transaksi) : (isset($transaksi->status) ? strtolower($transaksi->status) : 'pending');
						
						// Mapping status ke teks yang lebih user-friendly
						$status_mapping = array(
							'pending' => 'Menunggu Pembayaran',
							'dibayar' => 'Dibayar',
							'diproses' => 'Diproses',
							'dikirim' => 'Dikirim',
							'selesai' => 'Selesai',
							'dibatalkan' => 'Dibatalkan',
							'menunggu_pembayaran' => 'Menunggu Pembayaran',
							'menunggu_konfirmasi' => 'Menunggu Konfirmasi'
						);
						
						$status_text = isset($status_mapping[$status]) ? $status_mapping[$status] : ucfirst(str_replace('_', ' ', $status));
						$badge_class = 'badge-info';
						if($status == 'selesai' || $status == 'dikirim' || $status == 'dibayar') {
							$badge_class = 'badge-success';
						} else if($status == 'dibatalkan') {
							$badge_class = 'badge-danger';
						} else if($status == 'menunggu_pembayaran' || $status == 'pending' || $status == 'menunggu_konfirmasi') {
							$badge_class = 'badge-warning';
						}
						?>
						<span class="badge <?php echo $badge_class; ?>"><?php echo $status_text; ?></span>
						
						<?php 
						// Tampilkan tombol refresh status jika menggunakan Midtrans dan status masih pending
						if(isset($transaksi->metode_pembayaran) && strtolower($transaksi->metode_pembayaran) == 'midtrans' && ($status == 'pending' || $status == 'menunggu_pembayaran')): 
						?>
							<a href="<?php echo base_url('transaksi/refresh_status/'.$transaksi->id_transaksi); ?>" class="btn-refresh">
								<i class="fas fa-sync-alt"></i> Refresh Status
							</a>
						<?php endif; ?>
					</div>
				</div>
				<?php if(isset($transaksi->alamat_pengiriman) && !empty($transaksi->alamat_pengiriman)): ?>
				<div class="info-row">
					<div class="info-label">Alamat Pengiriman</div>
					<div class="info-value"><?php echo htmlspecialchars($transaksi->alamat_pengiriman); ?></div>
				</div>
				<?php endif; ?>
				<?php if(isset($transaksi->telepon_pengiriman) && !empty($transaksi->telepon_pengiriman)): ?>
				<div class="info-row">
					<div class="info-label">Telepon</div>
					<div class="info-value"><?php echo htmlspecialchars($transaksi->telepon_pengiriman); ?></div>
				</div>
				<?php endif; ?>
				<?php if(isset($transaksi->metode_pembayaran) && !empty($transaksi->metode_pembayaran)): ?>
				<div class="info-row">
					<div class="info-label">Metode Pembayaran</div>
					<div class="info-value"><?php echo ucfirst(str_replace('_', ' ', $transaksi->metode_pembayaran)); ?></div>
				</div>
				<?php endif; ?>
			</div>
		</div>

		<div class="card">
			<div class="card-header">
				<i class="fas fa-shopping-bag"></i>
				Item Pesanan
			</div>
			<div class="card-body">
				<div class="table-responsive">
					<table>
						<thead>
							<tr>
								<th>Produk</th>
								<th>Harga</th>
								<th>Qty</th>
								<th>Subtotal</th>
							</tr>
						</thead>
						<tbody>
							<?php 
							// Prepare retur map
							$retur_map = array();
							if(isset($retur_items) && !empty($retur_items)) {
								foreach($retur_items as $r_item) {
									$retur_map[$r_item->id_produk] = $r_item->qty;
								}
							}
							?>
							<?php if(!empty($transaksi_detail)): ?>
								<?php foreach($transaksi_detail as $detail): ?>
									<tr>
										<td>
											<div style="display: flex; align-items: center; gap: 15px;">
												<div class="item-image">
													<?php
													$gambar = isset($detail->gambar_produk) ? $detail->gambar_produk : (isset($detail->foto_produk) ? $detail->foto_produk : (isset($detail->gambar) ? $detail->gambar : ''));
													if(!empty($gambar)):
														$image_path = 'http://localhost/gerabah/admin/uploads/produk/'.$gambar;
													?>
														<img src="<?php echo $image_path; ?>" alt="<?php echo isset($detail->nama_produk) ? htmlspecialchars($detail->nama_produk) : 'Produk'; ?>" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
														<i class="fas fa-image" style="display: none;"></i>
													<?php else: ?>
														<i class="fas fa-image"></i>
													<?php endif; ?>
												</div>
												<div style="flex: 1;">
													<div class="product-name">
														<?php echo isset($detail->nama_produk) ? htmlspecialchars($detail->nama_produk) : 'Nama Produk'; ?>
													</div>
													<?php if(isset($retur_map[$detail->id_produk])): ?>
														<div style="display: inline-block; background: #fff3cd; color: #856404; padding: 3px 8px; border-radius: 4px; font-size: 11px; margin-bottom: 6px; border: 1px solid #ffeeba;">
															<i class="fas fa-exchange-alt" style="margin-right: 3px;"></i> 
															Diretur: <strong><?php echo $retur_map[$detail->id_produk]; ?></strong> unit
														</div>
													<?php endif; ?>
													<?php if(isset($detail->ukuran) && !empty($detail->ukuran)): ?>
														<div class="product-category" style="color: #d4af37; margin-top: 2px;">
															Ukuran: <strong><?php echo htmlspecialchars($detail->ukuran); ?></strong>
														</div>
													<?php endif; ?>
													<?php if(isset($detail->nama_kategori) && !empty($detail->nama_kategori)): ?>
														<div class="product-category">
															<i class="fas fa-tag" style="font-size: 10px; margin-right: 5px;"></i>
															<?php echo htmlspecialchars($detail->nama_kategori); ?>
														</div>
													<?php endif; ?>
												</div>
											</div>
										</td>
										<td class="price">
											Rp <?php 
											$harga = isset($detail->harga) && $detail->harga > 0 ? $detail->harga : 0;
											echo number_format($harga, 0, ',', '.'); 
											?>
										</td>
										<td><?php echo isset($detail->qty) ? $detail->qty : 1; ?></td>
										<td class="price">
											Rp <?php 
											$harga = isset($detail->harga) && $detail->harga > 0 ? $detail->harga : 0;
											$qty = isset($detail->qty) ? $detail->qty : 1;
											$subtotal = isset($detail->subtotal) && $detail->subtotal > 0 ? $detail->subtotal : ($harga * $qty);
											echo number_format($subtotal, 0, ',', '.'); 
											?>
										</td>
									</tr>
								<?php endforeach; ?>
							<?php else: ?>
								<tr>
									<td colspan="4" style="text-align: center; padding: 60px 40px; color: #888;">
										<div style="display: flex; flex-direction: column; align-items: center; gap: 15px;">
											<i class="fas fa-shopping-bag" style="font-size: 64px; opacity: 0.2; color: #1a1f3a;"></i>
											<div style="font-size: 16px; font-weight: 500;">Tidak ada item</div>
											<div style="font-size: 13px; color: #aaa;">
												<?php 
												// Cek apakah ada catatan yang mungkin berisi info item
												if(isset($transaksi->catatan) && !empty($transaksi->catatan)) {
													if(strpos($transaksi->catatan, 'JSON_DATA') !== false) {
														echo 'Data item ditemukan di catatan tetapi gagal di-parse. Silakan hubungi admin.';
													} else {
														echo 'Item pesanan tidak ditemukan. Transaksi ini mungkin dibuat sebelum sistem penyimpanan item diperbarui.';
													}
												} else {
													echo 'Item pesanan tidak ditemukan.';
												}
												?>
											</div>
										</div>
									</td>
								</tr>
							<?php endif; ?>
						</tbody>
					</table>
				</div>

				<div class="summary-section">
					<div class="summary-row">
						<span class="summary-label">Subtotal</span>
						<span class="summary-value">
							Rp <?php 
							$subtotal = 0;
							if(!empty($transaksi_detail)) {
								foreach($transaksi_detail as $detail) {
									$harga = isset($detail->harga) && $detail->harga > 0 ? $detail->harga : 0;
									$qty = isset($detail->qty) ? $detail->qty : 1;
									$subtotal += isset($detail->subtotal) && $detail->subtotal > 0 ? $detail->subtotal : ($harga * $qty);
								}
							}
							echo number_format($subtotal, 0, ',', '.'); 
							?>
						</span>
					</div>
					<div class="summary-row">
						<span class="summary-label">Ongkir</span>
						<span class="summary-value">
							Rp <?php 
							// Cek ongkir dari total_harga - subtotal, atau dari catatan
							$ongkir = 0;
							$total_harga = isset($transaksi->total_harga) && $transaksi->total_harga > 0 ? $transaksi->total_harga : (isset($transaksi->total) && $transaksi->total > 0 ? $transaksi->total : 0);
							if($total_harga > 0 && $subtotal > 0) {
								$ongkir = $total_harga - $subtotal;
							} else if(isset($transaksi->ongkir) && $transaksi->ongkir > 0) {
								$ongkir = $transaksi->ongkir;
							} else if(isset($transaksi->catatan) && !empty($transaksi->catatan)) {
								// Coba ambil dari catatan
								if(preg_match('/Ongkir:\s*Rp\s*([0-9.,]+)/i', $transaksi->catatan, $matches)) {
									$ongkir = (float)str_replace(array('.', ','), '', $matches[1]);
								}
							}
							echo number_format($ongkir, 0, ',', '.'); 
							?>
						</span>
					</div>
					<?php if(isset($transaksi->total_refund) && $transaksi->total_refund > 0): ?>
					<div class="summary-row">
						<span class="summary-label" style="font-weight: bold;">Total Awal</span>
						<span class="summary-value">
							Rp <?php 
							$total = isset($transaksi->total_harga) && $transaksi->total_harga > 0 ? $transaksi->total_harga : (isset($transaksi->total) && $transaksi->total > 0 ? $transaksi->total : ($subtotal + $ongkir));
							echo number_format($total, 0, ',', '.'); 
							?>
						</span>
					</div>
					<div class="summary-row">
						<span class="summary-label" style="color: #dc3545; font-weight: bold;">Refund Dana</span>
						<span class="summary-value" style="color: #dc3545;">
							- Rp <?php echo number_format($transaksi->total_refund, 0, ',', '.'); ?>
						</span>
					</div>
					<div class="summary-total">
						<span class="summary-total-label">Total Akhir</span>
						<span class="summary-total-value">
							Rp <?php 
							echo number_format($total - $transaksi->total_refund, 0, ',', '.'); 
							?>
						</span>
					</div>
					<?php else: ?>
					<div class="summary-total">
						<span class="summary-total-label">Total</span>
						<span class="summary-total-value">
							Rp <?php 
							$total = isset($transaksi->total_harga) && $transaksi->total_harga > 0 ? $transaksi->total_harga : (isset($transaksi->total) && $transaksi->total > 0 ? $transaksi->total : ($subtotal + $ongkir));
							echo number_format($total, 0, ',', '.'); 
							?>
						</span>
					</div>
					<?php endif; ?>
				</div>
			</div>
		</div>

		<div class="action-buttons">
			<a href="<?php echo base_url('transaksi'); ?>" class="btn-back">
				<i class="fas fa-arrow-left"></i> Kembali ke Riwayat
			</a>
			
			<?php 
			// Cek status untuk tombol bayar
			$status_pay = isset($transaksi->status_transaksi) ? strtolower($transaksi->status_transaksi) : (isset($transaksi->status) ? strtolower($transaksi->status) : 'pending');
			?>
			
			<?php if(isset($transaksi->metode_pembayaran) && strtolower($transaksi->metode_pembayaran) == 'midtrans' && ($status_pay == 'pending' || $status_pay == 'menunggu_pembayaran')): ?>
				<button id="pay-button" class="btn-return">
					<i class="fas fa-credit-card"></i> Bayar Sekarang
				</button>
				<a href="<?php echo base_url('transaksi/batalkan/'.$transaksi->id_transaksi); ?>" class="btn-cancel" onclick="return confirm('Apakah Anda yakin ingin membatalkan pesanan ini?');">
					<i class="fas fa-times-circle"></i> Batalkan Pesanan
				</a>
			<?php endif; ?>
			
			<?php 
			// Cek apakah customer bisa ajukan retur
			// Status harus selesai/dikirim dan belum pernah ajukan retur
			$status_for_return = isset($transaksi->status_transaksi) ? strtolower($transaksi->status_transaksi) : (isset($transaksi->status) ? strtolower($transaksi->status) : '');
			$can_return = in_array($status_for_return, ['selesai', 'dikirim', 'dibayar']);
			?>
			
			<?php if($can_return): ?>
				<a href="<?php echo base_url('retur/ajukan/'.$transaksi->id_transaksi); ?>" class="btn-return">
					<i class="fas fa-rotate-left"></i> Ajukan Pengembalian
				</a>
			<?php endif; ?>
		</div>
	<?php else: ?>
		<div style="text-align: center; padding: 60px 20px; background: white; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.1);">
			<i class="fas fa-exclamation-circle" style="font-size: 64px; color: #2c3e5e; margin-bottom: 20px; opacity: 0.3;"></i>
			<h3 style="color: #333; margin-bottom: 10px;">Transaksi Tidak Ditemukan</h3>
			<p style="color: #666; margin-bottom: 30px;">Transaksi yang Anda cari tidak ditemukan</p>
			<a href="<?php echo base_url('transaksi'); ?>" class="btn-back">
				<i class="fas fa-arrow-left"></i> Kembali ke Riwayat
			</a>
		</div>
	<?php endif; ?>
</div>

<!-- Midtrans Snap -->
<script src="<?php echo isset($midtrans_is_production) && $midtrans_is_production ? 'https://app.midtrans.com/snap/snap.js' : 'https://app.sandbox.midtrans.com/snap/snap.js'; ?>" data-client-key="<?php echo isset($midtrans_client_key) ? $midtrans_client_key : ''; ?>"></script>

<script type="text/javascript">
	var payButton = document.getElementById('pay-button');
	if(payButton) {
		payButton.addEventListener('click', function (e) {
			e.preventDefault();
			
			// Disable button
			payButton.disabled = true;
			payButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Memproses...';
			
			// Get token via AJAX
			fetch('<?php echo base_url('transaksi/get_payment_token/'.(isset($transaksi->id_transaksi) ? $transaksi->id_transaksi : '')); ?>')
				.then(response => response.json())
				.then(data => {
					if(data.status == 'success') {
						// Snap Pay
						window.snap.pay(data.token, {
							onSuccess: function(result){
								window.location.href = '<?php echo base_url('transaksi/refresh_status/'.(isset($transaksi->id_transaksi) ? $transaksi->id_transaksi : '')); ?>';
							},
							onPending: function(result){
								window.location.href = '<?php echo base_url('transaksi/refresh_status/'.(isset($transaksi->id_transaksi) ? $transaksi->id_transaksi : '')); ?>';
							},
							onError: function(result){
								alert("Pembayaran gagal!");
								payButton.disabled = false;
								payButton.innerHTML = '<i class="fas fa-credit-card"></i> Bayar Sekarang';
							},
							onClose: function(){
								// Optional: check status on close just in case
								payButton.disabled = false;
								payButton.innerHTML = '<i class="fas fa-credit-card"></i> Bayar Sekarang';
							}
						});
					} else {
						alert(data.message);
						payButton.disabled = false;
						payButton.innerHTML = '<i class="fas fa-credit-card"></i> Bayar Sekarang';
					}
				})
				.catch(error => {
					console.error('Error:', error);
					alert('Terjadi kesalahan saat memproses pembayaran.');
					payButton.disabled = false;
					payButton.innerHTML = '<i class="fas fa-credit-card"></i> Bayar Sekarang';
				});
		});
	}
</script>

