<style type="text/css">
	.page-header {
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		padding: 50px 20px;
		text-align: center;
		margin-bottom: 40px;
		box-shadow: 0 4px 20px rgba(0,0,0,0.15);
		border-bottom: 3px solid rgba(212, 175, 55, 0.3);
	}

	.page-header h1 {
		font-size: 36px;
		font-weight: 700;
		margin-bottom: 10px;
	}

	.container {
		max-width: 1200px;
		margin: 0 auto;
		padding: 0 20px;
	}

	.transaction-card {
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
		padding: 25px;
		margin-bottom: 20px;
		transition: all 0.3s;
	}

	.transaction-card:hover {
		transform: translateY(-5px);
		box-shadow: 0 8px 25px rgba(0,0,0,0.15);
	}

	.transaction-header {
		display: flex;
		justify-content: space-between;
		align-items: center;
		margin-bottom: 20px;
		padding-bottom: 15px;
		border-bottom: 2px solid #e9ecef;
	}

	.transaction-id {
		font-size: 18px;
		font-weight: 700;
		color: #d4af37;
	}

	.transaction-date {
		font-size: 14px;
		color: #666;
	}

	.transaction-status {
		padding: 6px 15px;
		border-radius: 20px;
		font-size: 12px;
		font-weight: 600;
		display: inline-block;
	}

	.badge-success {
		background: #28a745;
		color: white;
	}

	.badge-warning {
		background: #ffc107;
		color: #000;
	}

	.badge-danger {
		background: #dc3545;
		color: white;
	}

	.badge-info {
		background: #17a2b8;
		color: white;
	}

	.transaction-info {
		display: grid;
		grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
		gap: 15px;
		margin-bottom: 20px;
	}

	.info-item {
		display: flex;
		flex-direction: column;
		gap: 5px;
	}

	.info-label {
		font-size: 12px;
		color: #666;
		font-weight: 600;
		text-transform: uppercase;
	}

	.info-value {
		font-size: 16px;
		color: #333;
		font-weight: 600;
	}

	.transaction-total {
		display: flex;
		justify-content: space-between;
		align-items: center;
		padding-top: 15px;
		border-top: 2px solid #e9ecef;
	}

	.total-label {
		font-size: 16px;
		font-weight: 600;
		color: #333;
	}

	.total-value {
		font-size: 24px;
		font-weight: 700;
		color: #d4af37;
	}

	.btn-detail {
		padding: 10px 25px;
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		text-decoration: none;
		border-radius: 8px;
		font-weight: 700;
		transition: all 0.3s;
		display: inline-flex;
		align-items: center;
		gap: 8px;
	}

	.btn-detail:hover {
		transform: translateY(-2px);
		box-shadow: 0 5px 20px rgba(212, 175, 55, 0.4);
		background: linear-gradient(135deg, #d4af37 0%, #c9a961 100%);
		color: #1a1f3a;
		font-weight: 700;
	}

	.empty-state {
		text-align: center;
		padding: 60px 20px;
		background: white;
		border-radius: 15px;
		box-shadow: 0 5px 20px rgba(0,0,0,0.1);
	}

	.empty-state i {
		font-size: 64px;
		color: #d4af37;
		margin-bottom: 20px;
		opacity: 0.3;
	}

	.empty-state h3 {
		color: #333;
		margin-bottom: 10px;
	}

	.empty-state p {
		color: #666;
		margin-bottom: 30px;
	}

	.empty-state a {
		display: inline-block;
		padding: 12px 30px;
		background: linear-gradient(135deg, #1a1f3a 0%, #2c3e5e 100%);
		color: white;
		text-decoration: none;
		border-radius: 8px;
		font-weight: 600;
		transition: all 0.3s;
	}

	.empty-state a:hover {
		transform: translateY(-2px);
		box-shadow: 0 5px 20px rgba(212, 175, 55, 0.3);
	}

	@media (max-width: 768px) {
		.transaction-header {
			flex-direction: column;
			align-items: flex-start;
			gap: 10px;
		}

		.transaction-info {
			grid-template-columns: 1fr;
		}

		.transaction-total {
			flex-direction: column;
			align-items: flex-start;
			gap: 10px;
		}
	}
</style>

<div class="page-header">
	<h1><i class="fas fa-history"></i> Riwayat Transaksi</h1>
	<p>Daftar semua pesanan Anda</p>
</div>

<div class="container">
	<?php if(!empty($transaksi)): ?>
		<?php foreach($transaksi as $t): ?>
			<div class="transaction-card">
				<div class="transaction-header">
					<div>
						<div class="transaction-id">#<?php echo isset($t->id_transaksi) ? $t->id_transaksi : '-'; ?></div>
						<div class="transaction-date">
							<i class="fas fa-calendar"></i>
							<?php 
							$tanggal = isset($t->tanggal_transaksi) ? $t->tanggal_transaksi : (isset($t->created_at) ? $t->created_at : '-');
							if($tanggal != '-') {
								echo date('d F Y H:i', strtotime($tanggal));
							} else {
								echo '-';
							}
							?>
						</div>
					</div>
					<div>
						<?php
						// Gunakan status_transaksi jika ada, jika tidak gunakan status
						$status = isset($t->status_transaksi) ? strtolower($t->status_transaksi) : (isset($t->status) ? strtolower($t->status) : 'pending');
						
						// Mapping status ke teks yang lebih user-friendly (sama seperti di detail)
						$status_mapping = array(
							'pending' => 'Menunggu Pembayaran',
							'dibayar' => 'Dibayar',
							'diproses' => 'Diproses',
							'dikirim' => 'Dikirim',
							'selesai' => 'Selesai',
							'dibatalkan' => 'Dibatalkan',
							'menunggu_pembayaran' => 'Menunggu Pembayaran',
							'menunggu_konfirmasi' => 'Menunggu Konfirmasi'
						);
						
						$status_text = isset($status_mapping[$status]) ? $status_mapping[$status] : ucfirst(str_replace('_', ' ', $status));
						$badge_class = 'badge-info';
						if($status == 'selesai' || $status == 'dikirim' || $status == 'dibayar') {
							$badge_class = 'badge-success';
						} else if($status == 'dibatalkan') {
							$badge_class = 'badge-danger';
						} else if($status == 'menunggu_pembayaran' || $status == 'pending' || $status == 'menunggu_konfirmasi') {
							$badge_class = 'badge-warning';
						}
						?>
						<span class="transaction-status <?php echo $badge_class; ?>"><?php echo $status_text; ?></span>
					</div>
				</div>

				<div class="transaction-info">
					<?php if(isset($t->alamat_pengiriman) && !empty($t->alamat_pengiriman)): ?>
					<div class="info-item">
						<div class="info-label">Alamat Pengiriman</div>
						<div class="info-value"><?php echo htmlspecialchars(substr($t->alamat_pengiriman, 0, 50)) . (strlen($t->alamat_pengiriman) > 50 ? '...' : ''); ?></div>
					</div>
					<?php endif; ?>
					<?php if(isset($t->telepon_pengiriman) && !empty($t->telepon_pengiriman)): ?>
					<div class="info-item">
						<div class="info-label">Telepon</div>
						<div class="info-value"><?php echo htmlspecialchars($t->telepon_pengiriman); ?></div>
					</div>
					<?php endif; ?>
					<?php if(isset($t->metode_pembayaran) && !empty($t->metode_pembayaran)): ?>
					<div class="info-item">
						<div class="info-label">Metode Pembayaran</div>
						<div class="info-value"><?php echo ucfirst(str_replace('_', ' ', $t->metode_pembayaran)); ?></div>
					</div>
					<?php endif; ?>
				</div>

				<div class="transaction-total">
					<div class="total-label">Total Pembayaran</div>
					<div class="total-value">
						<?php 
						// Gunakan total_harga jika ada, jika tidak gunakan total
						$total = isset($t->total_harga) && $t->total_harga > 0 ? $t->total_harga : (isset($t->total) && $t->total > 0 ? $t->total : 0);
						
						if(isset($t->total_refund) && $t->total_refund > 0) {
						    echo 'Rp ' . number_format($total - $t->total_refund, 0, ',', '.');
						    echo '<br><small style="font-size: 12px; color: #dc3545; font-weight: normal;">(Refund: Rp ' . number_format($t->total_refund, 0, ',', '.') . ')</small>';
						} else {
						    echo 'Rp ' . number_format($total, 0, ',', '.'); 
						}
						?>
					</div>
				</div>

				<div style="margin-top: 20px; text-align: right;">
					<a href="<?php echo base_url('transaksi/detail/'.(isset($t->id_transaksi) ? $t->id_transaksi : 0)); ?>" class="btn-detail">
						<i class="fas fa-eye"></i> Lihat Detail
					</a>
				</div>
			</div>
		<?php endforeach; ?>
	<?php else: ?>
		<div class="empty-state">
			<i class="fas fa-inbox"></i>
			<h3>Belum Ada Transaksi</h3>
			<p>Anda belum melakukan transaksi apapun. Mulai berbelanja sekarang!</p>
			<a href="<?php echo base_url('produk'); ?>">
				<i class="fas fa-shopping-bag"></i> Belanja Sekarang
			</a>
		</div>
	<?php endif; ?>
</div>

