<?php
header('Content-Type: text/plain');

$api_key = 'ZmPbJk1ef9e97f00a760f2a5fxnjJkDu';

$curl = curl_init();
curl_setopt_array($curl, array(
    CURLOPT_URL => "https://api.rajaongkir.com/starter/province",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTPHEADER => array("key: " . $api_key),
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
));

$response = curl_exec($curl);
$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
$err = curl_error($curl);
curl_close($curl);

echo "=== TEST RAJA ONGKIR API ===\n\n";
echo "API Key: " . substr($api_key, 0, 10) . "...\n";
echo "HTTP Code: " . $http_code . "\n";
echo "cURL Error: " . ($err ?: "None") . "\n\n";

if ($http_code == 200) {
    $data = json_decode($response, true);
    if (isset($data['rajaongkir']['results'])) {
        echo "STATUS: SUKSES!\n";
        echo "Jumlah Provinsi: " . count($data['rajaongkir']['results']) . "\n\n";
        echo "5 Provinsi Pertama:\n";
        for ($i = 0; $i < min(5, count($data['rajaongkir']['results'])); $i++) {
            echo "- " . $data['rajaongkir']['results'][$i]['province'] . "\n";
        }
    } else {
        echo "STATUS: GAGAL (response tidak valid)\n";
        echo "Response: " . substr($response, 0, 500) . "\n";
    }
} else if ($http_code == 400) {
    echo "STATUS: GAGAL - Bad Request\n";
    echo "Response: " . $response . "\n";
} else if ($http_code == 401) {
    echo "STATUS: GAGAL - API Key tidak valid\n";
} else if ($http_code == 410) {
    echo "STATUS: GAGAL - API endpoint sudah tidak tersedia (HTTP 410 Gone)\n";
    echo "Kemungkinan: API Key expired atau tidak terdaftar untuk paket Starter\n";
} else {
    echo "STATUS: GAGAL - HTTP Error " . $http_code . "\n";
    echo "Response: " . substr($response, 0, 500) . "\n";
}
