<!DOCTYPE html>
<html>
<head>
    <title>Cek ID Produk</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: white; padding: 20px; border-radius: 10px; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; border: 1px solid #ddd; text-align: left; }
        th { background: #1a1f3a; color: white; position: sticky; top: 0; }
        .yes { background: #d4edda !important; color: green; font-weight: bold; }
        .no { background: #f8d7da !important; color: red; font-weight: bold; }
        .info { background: #d1ecf1; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .success { background: #d4edda; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .error { background: #f8d7da; padding: 15px; border-radius: 5px; margin: 15px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Mapping ID Produk: Homepage vs Database</h1>
        
        <?php
        require_once('application/config/database.php');
        $conn = new mysqli($db['default']['hostname'], $db['default']['username'], $db['default']['password'], $db['default']['database']);
        
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }
        
        $now = date('Y-m-d H:i:s');
        echo "<p><strong>Waktu Sekarang:</strong> {$now}</p>";
        
        // 1. CEK PRODUK DI HOMEPAGE (Yang tampil ke customer)
        echo "<h2>1️⃣ PRODUK DI HOMEPAGE (Terbaru)</h2>";
        echo "<p>Produk-produk ini yang muncul di halaman customer:</p>";
        
        $sql_homepage = "SELECT 
            produk.id_produk, 
            produk.nama_produk, 
            produk.harga_produk,
            kategori.nama_kategori
        FROM produk
        LEFT JOIN kategori ON kategori.id_kategori = produk.id_kategori
        ORDER BY produk.id_produk DESC
        LIMIT 10";
        
        $result_homepage = $conn->query($sql_homepage);
        
        if($result_homepage && $result_homepage->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>id_produk</th><th>Nama Produk</th><th>Kategori</th><th>Harga</th></tr>";
            while($row = $result_homepage->fetch_assoc()) {
                echo "<tr>";
                echo "<td><strong>{$row['id_produk']}</strong></td>";
                echo "<td>{$row['nama_produk']}</td>";
                echo "<td>{$row['nama_kategori']}</td>";
                echo "<td>Rp " . number_format($row['harga_produk'], 0) . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
        
        // 2. CEK PRODUK YANG ADA DI PROMO
        echo "<h2>2️⃣ PRODUK YANG ADA DI PROMO_PRODUK</h2>";
        echo "<p>Produk-produk ini yang ada diskon di database:</p>";
        
        $sql_promo = "SELECT 
            pp.id_produk,
            p.nama_produk,
            pp.harga_awal,
            pp.harga_diskon,
            pr.nama_promo,
            pr.status_promo,
            pr.waktu_mulai,
            pr.waktu_berakhir
        FROM promo_produk pp
        LEFT JOIN produk p ON pp.id_produk = p.id_produk
        LEFT JOIN promo pr ON pp.id_promo = pr.id_promo
        ORDER BY pp.id_promo_produk DESC";
        
        $result_promo = $conn->query($sql_promo);
        
        if($result_promo && $result_promo->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>id_produk</th><th>Nama Produk</th><th>Promo</th><th>Status</th><th>Harga Awal</th><th>Harga Diskon</th><th>Periode</th></tr>";
            while($row = $result_promo->fetch_assoc()) {
                $class = $row['status_promo'] == 'aktif' ? 'yes' : 'no';
                echo "<tr class='{$class}'>";
                echo "<td><strong>{$row['id_produk']}</strong></td>";
                echo "<td>{$row['nama_produk']}</td>";
                echo "<td>{$row['nama_promo']}</td>";
                echo "<td>{$row['status_promo']}</td>";
                echo "<td>Rp " . number_format($row['harga_awal'], 0) . "</td>";
                echo "<td>Rp " . number_format($row['harga_diskon'], 0) . "</td>";
                echo "<td style='font-size:10px;'>{$row['waktu_mulai']}<br>s/d<br>{$row['waktu_berakhir']}</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
        
        // 3. HASIL QUERY MODEL (Yang digunakan di CodeIgniter)
        echo "<h2>3️⃣ HASIL QUERY MODEL (LEFT JOIN)</h2>";
        echo "<p>Ini hasil query PERSIS seperti yang digunakan model Mproduk:</p>";
        
        $sql_model = "SELECT 
            produk.id_produk,
            produk.nama_produk,
            produk.harga_produk,
            kategori.nama_kategori,
            promo_produk.harga_diskon,
            promo.status_promo,
            promo.waktu_mulai,
            promo.waktu_berakhir,
            promo.nama_promo
        FROM produk
        LEFT JOIN kategori ON kategori.id_kategori = produk.id_kategori
        LEFT JOIN promo_produk ON promo_produk.id_produk = produk.id_produk
        LEFT JOIN promo ON promo.id_promo = promo_produk.id_promo
        ORDER BY produk.id_produk DESC
        LIMIT 10";
        
        $result_model = $conn->query($sql_model);
        
        if($result_model && $result_model->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>id_produk</th><th>Nama Produk</th><th>Harga</th><th>harga_diskon<br>(dari JOIN)</th><th>Nama Promo</th><th>Status</th><th>Badge Harus Muncul?</th></tr>";
            
            $count_should_show = 0;
            while($row = $result_model->fetch_assoc()) {
                $should_show = false;
                $reason = "";
                
                if($row['harga_diskon'] && $row['harga_diskon'] > 0) {
                    if($row['status_promo'] == 'aktif') {
                        $waktu_mulai = strtotime($row['waktu_mulai']);
                        $waktu_berakhir = strtotime($row['waktu_berakhir']);
                        $waktu_sekarang = strtotime($now);
                        
                        if($waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang) {
                            $should_show = true;
                            $reason = "✅ YA";
                            $count_should_show++;
                        } else {
                            $reason = "❌ Waktu tidak valid";
                        }
                    } else {
                        $reason = "❌ Status: " . $row['status_promo'];
                    }
                } else {
                    $reason = "❌ NULL (tidak ada di promo)";
                }
                
                $class = $should_show ? 'yes' : 'no';
                echo "<tr class='{$class}'>";
                echo "<td><strong>{$row['id_produk']}</strong></td>";
                echo "<td>{$row['nama_produk']}</td>";
                echo "<td>Rp " . number_format($row['harga_produk'], 0) . "</td>";
                echo "<td>" . ($row['harga_diskon'] ? "Rp " . number_format($row['harga_diskon'], 0) : '<span style="color:red;">NULL</span>') . "</td>";
                echo "<td>" . ($row['nama_promo'] ?: '-') . "</td>";
                echo "<td>" . ($row['status_promo'] ?: '-') . "</td>";
                echo "<td style='font-size:16px; font-weight:bold;'>{$reason}</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            if($count_should_show > 0) {
                echo "<div class='success'>";
                echo "<h3>✅ KESIMPULAN: {$count_should_show} produk HARUS TAMPIL badge diskon!</h3>";
                echo "<p>Database sudah benar. Jika belum tampil, masalahnya di VIEW atau CACHE browser.</p>";
                echo "<p><strong>Solusi:</strong></p>";
                echo "<ol>";
                echo "<li>Hard refresh: <strong>Ctrl + F5</strong></li>";
                echo "<li>Clear browser cache</li>";
                echo "<li>Buka Incognito/Private window</li>";
                echo "<li>Cek View Source untuk melihat HTML yang dihasilkan</li>";
                echo "</ol>";
                echo "</div>";
            } else {
                echo "<div class='error'>";
                echo "<h3>❌ MASALAH DITEMUKAN!</h3>";
                echo "<p>Query LEFT JOIN TIDAK mengembalikan data promo untuk produk apapun.</p>";
                echo "<p><strong>Kemungkinan penyebab:</strong></p>";
                echo "<ol>";
                echo "<li><strong>id_produk tidak match</strong> - Produk yang tampil di homepage (tabel produk) BERBEDA dengan id_produk yang ada di tabel promo_produk</li>";
                echo "<li><strong>Promo sudah berakhir</strong> - Waktu promo sudah lewat</li>";
                echo "<li><strong>Status promo bukan 'aktif'</strong></li>";
                echo "</ol>";
                echo "</div>";
            }
        }
        
        $conn->close();
        ?>
        
        <hr>
        <p style="margin-top:30px;">
            <a href="index.php" style="background:#1a1f3a; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block; margin-right:10px;">🏠 Homepage Customer</a>
            <a href="../admin/promo" style="background:#28a745; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block;">⚙️ Admin Promo</a>
        </p>
    </div>
</body>
</html>

