<!DOCTYPE html>
<html>
<head>
    <title>Cek Promo - Debug</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: white; padding: 20px; border-radius: 10px; }
        h1 { color: #1a1f3a; }
        .success { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        .warning { color: orange; font-weight: bold; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; text-align: left; border: 1px solid #ddd; }
        th { background: #1a1f3a; color: white; }
        .aktif { background: #d4edda; }
        .tidak-aktif { background: #f8d7da; }
        .badge { display: inline-block; padding: 5px 10px; border-radius: 5px; color: white; font-size: 12px; }
        .badge-success { background: #28a745; }
        .badge-danger { background: #dc3545; }
        .badge-warning { background: #ffc107; color: #000; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Debug Promo - Status Lengkap</h1>
        
        <?php
        // Koneksi database
        $conn = new mysqli('localhost', 'root', '', 'gerabah');
        if ($conn->connect_error) {
            die("<p class='error'>❌ Koneksi database gagal: " . $conn->connect_error . "</p>");
        }
        
        $now = date('Y-m-d H:i:s');
        echo "<p><strong>Waktu Sekarang:</strong> {$now}</p>";
        echo "<hr>";
        
        // 1. Cek Promo yang Ada
        echo "<h2>📋 1. Daftar Promo</h2>";
        $sql_promo = "SELECT * FROM promo ORDER BY id_promo DESC";
        $result_promo = $conn->query($sql_promo);
        
        if ($result_promo && $result_promo->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>ID</th><th>Nama Promo</th><th>Diskon</th><th>Status</th><th>Waktu Mulai</th><th>Waktu Berakhir</th><th>Aktif Sekarang?</th></tr>";
            
            while($promo = $result_promo->fetch_assoc()) {
                $waktu_mulai = strtotime($promo['waktu_mulai']);
                $waktu_berakhir = strtotime($promo['waktu_berakhir']);
                $waktu_sekarang = strtotime($now);
                
                $is_aktif = ($promo['status_promo'] == 'aktif' && $waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang);
                $class = $is_aktif ? 'aktif' : 'tidak-aktif';
                
                echo "<tr class='{$class}'>";
                echo "<td>{$promo['id_promo']}</td>";
                echo "<td><strong>{$promo['nama_promo']}</strong></td>";
                echo "<td>{$promo['nilai_diskon']}" . ($promo['tipe_diskon'] == 'persen' ? '%' : '') . "</td>";
                echo "<td><span class='badge badge-" . ($promo['status_promo'] == 'aktif' ? 'success' : 'danger') . "'>{$promo['status_promo']}</span></td>";
                echo "<td>{$promo['waktu_mulai']}</td>";
                echo "<td>{$promo['waktu_berakhir']}</td>";
                echo "<td><strong style='color: " . ($is_aktif ? 'green' : 'red') . ";'>" . ($is_aktif ? '✓ YA' : '✗ TIDAK') . "</strong></td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p class='error'>❌ Tidak ada promo di database!</p>";
        }
        
        echo "<hr>";
        
        // 2. Cek Produk dalam Promo
        echo "<h2>🛍️ 2. Produk yang Terdaftar di Promo</h2>";
        $sql_promo_produk = "SELECT 
            pp.*,
            p.nama_produk,
            p.harga_produk,
            pr.nama_promo,
            pr.status_promo,
            pr.waktu_mulai,
            pr.waktu_berakhir
        FROM promo_produk pp
        LEFT JOIN produk p ON p.id_produk = pp.id_produk
        LEFT JOIN promo pr ON pr.id_promo = pp.id_promo
        ORDER BY pp.id_promo DESC";
        
        $result_pp = $conn->query($sql_promo_produk);
        
        if ($result_pp && $result_pp->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>Promo</th><th>Produk</th><th>Harga Awal</th><th>Harga Diskon</th><th>Status Promo</th><th>Promo Aktif?</th></tr>";
            
            while($pp = $result_pp->fetch_assoc()) {
                $waktu_mulai = strtotime($pp['waktu_mulai']);
                $waktu_berakhir = strtotime($pp['waktu_berakhir']);
                $waktu_sekarang = strtotime($now);
                
                $is_aktif = ($pp['status_promo'] == 'aktif' && $waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang);
                $class = $is_aktif ? 'aktif' : 'tidak-aktif';
                
                echo "<tr class='{$class}'>";
                echo "<td><strong>{$pp['nama_promo']}</strong></td>";
                echo "<td>{$pp['nama_produk']}</td>";
                echo "<td>Rp " . number_format($pp['harga_awal'], 0, ',', '.') . "</td>";
                echo "<td>Rp " . number_format($pp['harga_diskon'], 0, ',', '.') . "</td>";
                echo "<td><span class='badge badge-" . ($pp['status_promo'] == 'aktif' ? 'success' : 'danger') . "'>{$pp['status_promo']}</span></td>";
                echo "<td><strong style='color: " . ($is_aktif ? 'green' : 'red') . ";'>" . ($is_aktif ? '✓ AKTIF' : '✗ TIDAK AKTIF') . "</strong>";
                
                if(!$is_aktif) {
                    if($pp['status_promo'] != 'aktif') {
                        echo "<br><small>Alasan: Status promo = {$pp['status_promo']}</small>";
                    } else if($waktu_mulai > $waktu_sekarang) {
                        echo "<br><small>Alasan: Belum dimulai</small>";
                    } else if($waktu_berakhir < $waktu_sekarang) {
                        echo "<br><small>Alasan: Sudah berakhir</small>";
                    }
                }
                
                echo "</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            $count_aktif = 0;
            $result_pp->data_seek(0);
            while($pp = $result_pp->fetch_assoc()) {
                $waktu_mulai = strtotime($pp['waktu_mulai']);
                $waktu_berakhir = strtotime($pp['waktu_berakhir']);
                $waktu_sekarang = strtotime($now);
                
                if($pp['status_promo'] == 'aktif' && $waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang) {
                    $count_aktif++;
                }
            }
            
            echo "<p><strong>Total Produk dengan Promo Aktif: {$count_aktif}</strong></p>";
            
        } else {
            echo "<p class='error'>❌ TIDAK ADA PRODUK YANG TERDAFTAR DI PROMO!</p>";
            echo "<p class='warning'>⚠️ Anda perlu menambahkan produk ke promo di halaman admin.</p>";
            echo "<p>Caranya:</p>";
            echo "<ol>";
            echo "<li>Buka halaman Admin → Promo Diskon</li>";
            echo "<li>Klik tombol <strong>'+'</strong> (plus) di samping promo yang ingin ditambahkan produk</li>";
            echo "<li>Centang produk yang ingin diberi diskon</li>";
            echo "<li>Klik tombol <strong>'Simpan'</strong></li>";
            echo "</ol>";
        }
        
        $conn->close();
        ?>
        
        <hr>
        <h2>📝 Kesimpulan:</h2>
        <ul>
            <li>Baris <strong style="background: #d4edda; padding: 3px 8px;">HIJAU</strong> = Promo aktif dan produk akan tampil dengan diskon</li>
            <li>Baris <strong style="background: #f8d7da; padding: 3px 8px;">MERAH</strong> = Promo tidak aktif atau belum waktunya</li>
        </ul>
        
        <p><a href="<?php echo $_SERVER['PHP_SELF']; ?>" style="background: #1a1f3a; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block; margin-top: 10px;">🔄 Refresh</a></p>
    </div>
</body>
</html>

