<!DOCTYPE html>
<html>
<head>
    <title>Cek Database Promo</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: white; padding: 20px; border-radius: 10px; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 10px; border: 1px solid #ddd; text-align: left; }
        th { background: #1a1f3a; color: white; }
        .yes { background: #d4edda; color: green; font-weight: bold; }
        .no { background: #f8d7da; color: red; font-weight: bold; }
        .warning { background: #fff3cd; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .success { background: #d4edda; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .error { background: #f8d7da; padding: 15px; border-radius: 5px; margin: 15px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Cek Database: Produk & Promo</h1>
        
        <?php
        require_once('application/config/database.php');
        $conn = new mysqli($db['default']['hostname'], $db['default']['username'], $db['default']['password'], $db['default']['database']);
        
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }
        
        $now = date('Y-m-d H:i:s');
        echo "<p><strong>Waktu Sekarang:</strong> {$now}</p>";
        
        // 1. CEK TABEL PROMO
        echo "<h2>1️⃣ TABEL PROMO</h2>";
        $sql_promo = "SELECT * FROM promo ORDER BY id_promo DESC";
        $result_promo = $conn->query($sql_promo);
        
        if($result_promo && $result_promo->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>ID</th><th>Nama Promo</th><th>Status</th><th>Waktu Mulai</th><th>Waktu Berakhir</th><th>Tipe Diskon</th><th>Nilai Diskon</th></tr>";
            while($promo = $result_promo->fetch_assoc()) {
                $class = $promo['status_promo'] == 'aktif' ? 'yes' : 'no';
                echo "<tr class='{$class}'>";
                echo "<td>{$promo['id_promo']}</td>";
                echo "<td><strong>{$promo['nama_promo']}</strong></td>";
                echo "<td>{$promo['status_promo']}</td>";
                echo "<td>{$promo['waktu_mulai']}</td>";
                echo "<td>{$promo['waktu_berakhir']}</td>";
                echo "<td>{$promo['tipe_diskon']}</td>";
                echo "<td>{$promo['nilai_diskon']}%</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
        
        // 2. CEK TABEL PROMO_PRODUK (Junction table)
        echo "<h2>2️⃣ TABEL PROMO_PRODUK (Produk yang Ditambahkan ke Promo)</h2>";
        $sql_pp = "SELECT pp.*, p.nama_produk, p.harga_produk, pr.nama_promo, pr.status_promo 
                   FROM promo_produk pp 
                   LEFT JOIN produk p ON pp.id_produk = p.id_produk
                   LEFT JOIN promo pr ON pp.id_promo = pr.id_promo
                   ORDER BY pp.id_promo_produk DESC";
        $result_pp = $conn->query($sql_pp);
        
        if($result_pp && $result_pp->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>ID</th><th>Nama Promo</th><th>Status Promo</th><th>Nama Produk</th><th>Harga Normal</th><th>Harga Diskon</th><th>Selisih</th></tr>";
            while($pp = $result_pp->fetch_assoc()) {
                $class = $pp['status_promo'] == 'aktif' ? 'yes' : 'no';
                $selisih = $pp['harga_produk'] - $pp['harga_diskon'];
                echo "<tr class='{$class}'>";
                echo "<td>{$pp['id_promo_produk']}</td>";
                echo "<td>{$pp['nama_promo']}</td>";
                echo "<td>{$pp['status_promo']}</td>";
                echo "<td><strong>{$pp['nama_produk']}</strong></td>";
                echo "<td>Rp " . number_format($pp['harga_produk'], 0) . "</td>";
                echo "<td>Rp " . number_format($pp['harga_diskon'], 0) . "</td>";
                echo "<td style='color:green;'>- Rp " . number_format($selisih, 0) . "</td>";
                echo "</tr>";
            }
            echo "</table>";
            echo "<div class='success'><strong>✅ Total produk di promo:</strong> {$result_pp->num_rows} produk</div>";
        } else {
            echo "<div class='error'><strong>❌ TIDAK ADA PRODUK DI TABEL PROMO_PRODUK!</strong><br>Ini masalahnya! Anda harus menambahkan produk ke promo terlebih dahulu.</div>";
        }
        
        // 3. CEK QUERY YANG DIGUNAKAN MODEL
        echo "<h2>3️⃣ HASIL QUERY MODEL (Yang Digunakan di Homepage)</h2>";
        $sql_model = "SELECT produk.*, kategori.nama_kategori, 
                      promo_produk.harga_diskon, 
                      promo.status_promo, 
                      promo.waktu_mulai, 
                      promo.waktu_berakhir, 
                      promo.tipe_diskon, 
                      promo.nilai_diskon,
                      promo.nama_promo
                      FROM produk
                      LEFT JOIN kategori ON kategori.id_kategori = produk.id_kategori
                      LEFT JOIN promo_produk ON promo_produk.id_produk = produk.id_produk
                      LEFT JOIN promo ON promo.id_promo = promo_produk.id_promo
                      ORDER BY produk.id_produk DESC";
        
        $result_model = $conn->query($sql_model);
        
        if($result_model && $result_model->num_rows > 0) {
            echo "<table>";
            echo "<tr><th>Produk</th><th>Harga Normal</th><th>Harga Diskon</th><th>Nama Promo</th><th>Status Promo</th><th>Waktu Mulai</th><th>Waktu Berakhir</th><th>Badge Tampil?</th></tr>";
            
            $count_should_show = 0;
            while($row = $result_model->fetch_assoc()) {
                $should_show = false;
                $reason = "";
                
                if($row['harga_diskon'] && $row['harga_diskon'] > 0) {
                    if($row['status_promo'] == 'aktif') {
                        $waktu_mulai = strtotime($row['waktu_mulai']);
                        $waktu_berakhir = strtotime($row['waktu_berakhir']);
                        $waktu_sekarang = strtotime($now);
                        
                        if($waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang) {
                            $should_show = true;
                            $reason = "✅ YA - Semua OK";
                            $count_should_show++;
                        } else {
                            $reason = "❌ Waktu tidak valid";
                        }
                    } else {
                        $reason = "❌ Status: " . $row['status_promo'];
                    }
                } else {
                    $reason = "❌ Tidak ada diskon";
                }
                
                $class = $should_show ? 'yes' : 'no';
                echo "<tr class='{$class}'>";
                echo "<td><strong>{$row['nama_produk']}</strong></td>";
                echo "<td>Rp " . number_format($row['harga_produk'], 0) . "</td>";
                echo "<td>" . ($row['harga_diskon'] ? "Rp " . number_format($row['harga_diskon'], 0) : '<span style="color:red;">NULL</span>') . "</td>";
                echo "<td>" . ($row['nama_promo'] ?: '-') . "</td>";
                echo "<td>" . ($row['status_promo'] ?: '-') . "</td>";
                echo "<td style='font-size:10px;'>" . ($row['waktu_mulai'] ?: '-') . "</td>";
                echo "<td style='font-size:10px;'>" . ($row['waktu_berakhir'] ?: '-') . "</td>";
                echo "<td><strong>{$reason}</strong></td>";
                echo "</tr>";
            }
            echo "</table>";
            
            if($count_should_show > 0) {
                echo "<div class='success'>";
                echo "<h3>✅ HASIL: {$count_should_show} produk HARUS TAMPIL badge diskon!</h3>";
                echo "<p>Jika belum tampil di customer, masalahnya di VIEW atau HELPER.</p>";
                echo "</div>";
            } else {
                echo "<div class='error'>";
                echo "<h3>❌ HASIL: TIDAK ADA produk yang harus tampil badge!</h3>";
                echo "<p><strong>Penyebab:</strong> Produk belum ditambahkan ke promo, atau promo tidak aktif, atau waktu promo tidak valid.</p>";
                echo "</div>";
            }
        }
        
        $conn->close();
        ?>
        
        <hr>
        <h2>📋 LANGKAH SELANJUTNYA:</h2>
        <div class="warning">
            <ol style="line-height:2;">
                <li><strong>Jika tabel promo_produk KOSONG:</strong><br>
                    → Buka <a href="../admin/promo" style="color:#1a1f3a; font-weight:bold;">Admin Promo</a><br>
                    → Klik tombol <strong>+ (plus hijau)</strong> di samping promo yang aktif<br>
                    → Centang produk yang ingin diberi diskon<br>
                    → Isi harga diskon<br>
                    → Klik Simpan
                </li>
                <li><strong>Jika tabel promo_produk ADA ISI tapi badge tidak muncul:</strong><br>
                    → Masalahnya di VIEW atau HELPER<br>
                    → Saya akan perbaiki otomatis
                </li>
            </ol>
        </div>
        
        <p style="margin-top:30px;">
            <a href="index.php" style="background:#1a1f3a; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block; margin-right:10px;">🏠 Homepage Customer</a>
            <a href="../admin/promo" style="background:#28a745; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block;">⚙️ Admin Promo</a>
        </p>
    </div>
</body>
</html>

