<!DOCTYPE html>
<html>
<head>
    <title>Debug Full - Promo System</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1400px; margin: 0 auto; background: white; padding: 20px; border-radius: 10px; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 10px; border: 1px solid #ddd; text-align: left; font-size: 12px; }
        th { background: #1a1f3a; color: white; position: sticky; top: 0; }
        .yes { background: #d4edda !important; }
        .no { background: #f8d7da !important; }
        .warning { background: #fff3cd !important; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto; font-size: 11px; }
        .info { background: #d1ecf1; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .success { background: #d4edda; padding: 15px; border-radius: 5px; margin: 15px 0; }
        .error { background: #f8d7da; padding: 15px; border-radius: 5px; margin: 15px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Debug FULL System Promo</h1>
        
        <?php
        require_once('application/config/database.php');
        $conn = new mysqli($db['default']['hostname'], $db['default']['username'], $db['default']['password'], $db['default']['database']);
        
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }
        
        $now = date('Y-m-d H:i:s');
        echo "<p><strong>Waktu Sekarang:</strong> {$now}</p>";
        
        // Load helper
        require_once('application/helpers/promo_helper.php');
        
        // Query PERSIS seperti model
        $sql = "SELECT produk.*, kategori.nama_kategori, 
                promo_produk.harga_diskon, 
                promo.status_promo, 
                promo.waktu_mulai, 
                promo.waktu_berakhir, 
                promo.tipe_diskon, 
                promo.nilai_diskon,
                promo.nama_promo
                FROM produk
                LEFT JOIN kategori ON kategori.id_kategori = produk.id_kategori
                LEFT JOIN promo_produk ON promo_produk.id_produk = produk.id_produk
                LEFT JOIN promo ON promo.id_promo = promo_produk.id_promo
                ORDER BY produk.id_produk DESC
                LIMIT 10";
        
        $result = $conn->query($sql);
        
        if ($result && $result->num_rows > 0) {
            echo "<h2>📊 DATA PRODUK DARI DATABASE</h2>";
            echo "<table>";
            echo "<tr>
                <th>ID</th>
                <th>Nama Produk</th>
                <th>Harga Normal</th>
                <th>harga_diskon<br>(dari DB)</th>
                <th>status_promo</th>
                <th>waktu_mulai</th>
                <th>waktu_berakhir</th>
                <th>Helper Result</th>
                <th>Badge?</th>
            </tr>";
            
            $count_should_show = 0;
            while($row = $result->fetch_assoc()) {
                // Convert to object (seperti yang dilakukan CI)
                $produk = (object) $row;
                
                // Test helper
                $harga = $produk->harga_produk;
                $harga_info = get_harga_diskon($produk, $harga);
                $has_diskon = $harga_info['persen_diskon'] > 0;
                
                if($has_diskon) $count_should_show++;
                
                $class = $has_diskon ? 'yes' : ($row['harga_diskon'] ? 'warning' : 'no');
                
                echo "<tr class='{$class}'>";
                echo "<td><strong>{$row['id_produk']}</strong></td>";
                echo "<td>{$row['nama_produk']}</td>";
                echo "<td>Rp " . number_format($row['harga_produk'], 0) . "</td>";
                echo "<td>" . ($row['harga_diskon'] ? "Rp " . number_format($row['harga_diskon'], 0) : '<span style="color:red;">NULL</span>') . "</td>";
                echo "<td>" . ($row['status_promo'] ?: '<span style="color:red;">NULL</span>') . "</td>";
                echo "<td style='font-size:10px;'>" . ($row['waktu_mulai'] ?: '-') . "</td>";
                echo "<td style='font-size:10px;'>" . ($row['waktu_berakhir'] ?: '-') . "</td>";
                
                // Helper result
                echo "<td><pre style='margin:0; padding:5px; background:#f8f9fa; font-size:10px;'>";
                echo "persen: {$harga_info['persen_diskon']}%\n";
                echo "harga_awal: " . number_format($harga_info['harga_awal'], 0) . "\n";
                echo "harga_diskon: " . number_format($harga_info['harga_diskon'], 0) . "\n";
                echo "has_diskon: " . ($has_diskon ? 'TRUE ✓' : 'FALSE ✗');
                echo "</pre></td>";
                
                echo "<td style='font-size:16px; font-weight:bold; text-align:center;'>" . ($has_diskon ? '✅ YA' : '❌ TIDAK') . "</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            echo "<div class='" . ($count_should_show > 0 ? 'success' : 'error') . "'>";
            echo "<h3>📈 RINGKASAN:</h3>";
            echo "<p><strong>Produk dengan badge HARUS MUNCUL:</strong> <span style='font-size:24px; font-weight:bold;'>{$count_should_show}</span></p>";
            
            if($count_should_show > 0) {
                echo "<p style='color:green; font-weight:bold;'>✅ Helper mengembalikan data diskon dengan benar!</p>";
                echo "<p>Jika badge masih belum muncul di homepage, masalahnya ada di:</p>";
                echo "<ol>";
                echo "<li><strong>View tidak me-render kondisi if correctly</strong></li>";
                echo "<li><strong>Browser cache</strong> - Coba Ctrl+F5 atau Incognito</li>";
                echo "<li><strong>JavaScript error</strong> - Cek Console browser (F12)</li>";
                echo "</ol>";
            } else {
                echo "<p style='color:red; font-weight:bold;'>❌ Helper TIDAK mengembalikan diskon!</p>";
                echo "<p>Masalah ada di:</p>";
                echo "<ol>";
                echo "<li><strong>Data promo tidak di-JOIN dengan benar</strong></li>";
                echo "<li><strong>Waktu promo tidak valid</strong></li>";
                echo "<li><strong>Status promo bukan 'aktif'</strong></li>";
                echo "</ol>";
            }
            echo "</div>";
            
            // Detail debugging untuk produk pertama
            $result->data_seek(0);
            $first = $result->fetch_assoc();
            $produk_obj = (object) $first;
            
            echo "<h2>🔬 DEBUG DETAIL PRODUK: {$first['nama_produk']}</h2>";
            echo "<div class='info'>";
            echo "<h4>Data Mentah dari Database:</h4>";
            echo "<pre>";
            print_r($first);
            echo "</pre>";
            
            echo "<h4>Hasil Helper get_harga_diskon():</h4>";
            $harga_info = get_harga_diskon($produk_obj, $first['harga_produk']);
            echo "<pre>";
            print_r($harga_info);
            echo "</pre>";
            
            echo "<h4>Kondisi IF di View:</h4>";
            echo "<pre>";
            echo "\$has_diskon = \$harga_info['persen_diskon'] > 0;\n";
            echo "// Hasil: " . ($harga_info['persen_diskon'] > 0 ? 'TRUE (badge HARUS muncul)' : 'FALSE (badge TIDAK muncul)') . "\n\n";
            echo "if(\$has_diskon) {\n";
            echo "    // TAMPILKAN BADGE DISKON\n";
            echo "} else {\n";
            echo "    // TAMPILKAN HARGA NORMAL\n";
            echo "}\n";
            echo "</pre>";
            echo "</div>";
            
            // Test validasi waktu
            echo "<h2>⏰ VALIDASI WAKTU PROMO</h2>";
            if($first['status_promo']) {
                $waktu_mulai = strtotime($first['waktu_mulai']);
                $waktu_berakhir = strtotime($first['waktu_berakhir']);
                $waktu_sekarang = strtotime($now);
                
                echo "<table>";
                echo "<tr><th>Kondisi</th><th>Nilai</th><th>Status</th></tr>";
                echo "<tr><td>Waktu Mulai</td><td>{$first['waktu_mulai']}</td><td>" . date('Y-m-d H:i:s', $waktu_mulai) . "</td></tr>";
                echo "<tr><td>Waktu Berakhir</td><td>{$first['waktu_berakhir']}</td><td>" . date('Y-m-d H:i:s', $waktu_berakhir) . "</td></tr>";
                echo "<tr><td>Waktu Sekarang</td><td>{$now}</td><td>" . date('Y-m-d H:i:s', $waktu_sekarang) . "</td></tr>";
                
                $mulai_ok = $waktu_mulai <= $waktu_sekarang;
                $berakhir_ok = $waktu_berakhir >= $waktu_sekarang;
                
                echo "<tr class='" . ($mulai_ok ? 'yes' : 'no') . "'><td>waktu_mulai <= sekarang</td><td>" . ($mulai_ok ? 'TRUE' : 'FALSE') . "</td><td>" . ($mulai_ok ? '✓ Sudah mulai' : '✗ Belum mulai') . "</td></tr>";
                echo "<tr class='" . ($berakhir_ok ? 'yes' : 'no') . "'><td>waktu_berakhir >= sekarang</td><td>" . ($berakhir_ok ? 'TRUE' : 'FALSE') . "</td><td>" . ($berakhir_ok ? '✓ Belum berakhir' : '✗ Sudah berakhir') . "</td></tr>";
                
                $valid = $mulai_ok && $berakhir_ok && $first['status_promo'] == 'aktif';
                echo "<tr class='" . ($valid ? 'yes' : 'no') . "'><td><strong>PROMO VALID?</strong></td><td colspan='2'><strong>" . ($valid ? '✅ YA - SEMUA KONDISI TERPENUHI' : '❌ TIDAK - ADA KONDISI YANG TIDAK TERPENUHI') . "</strong></td></tr>";
                echo "</table>";
            } else {
                echo "<p style='color:red;'>Produk ini tidak punya data promo.</p>";
            }
            
        } else {
            echo "<p style='color:red;'>Tidak ada data produk</p>";
        }
        
        $conn->close();
        ?>
        
        <hr>
        <h2>🎯 SOLUSI BERDASARKAN HASIL DI ATAS:</h2>
        <div class="warning">
            <ol style="line-height:2;">
                <li>Jika ada produk dengan "✅ YA" tapi badge tidak muncul di homepage:<br>
                    → <strong>Clear browser cache (Ctrl+Shift+Del)</strong><br>
                    → <strong>Hard refresh (Ctrl+F5)</strong><br>
                    → <strong>Buka Incognito/Private window</strong><br>
                    → <strong>Right-click homepage > View Page Source</strong> untuk lihat HTML mentah
                </li>
                <li>Jika semua produk "❌ TIDAK":<br>
                    → Cek bagian "VALIDASI WAKTU PROMO" di atas<br>
                    → Pastikan waktu promo masih valid<br>
                    → Pastikan status_promo = 'aktif'
                </li>
            </ol>
        </div>
        
        <p style="margin-top:30px;">
            <a href="index.php" style="background:#1a1f3a; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block; margin-right:10px;">🏠 Homepage Customer</a>
            <a href="index.php?nocache=<?php echo time(); ?>" target="_blank" style="background:#007bff; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block; margin-right:10px;">🔄 Homepage (New Tab)</a>
            <a href="../admin/promo" style="background:#28a745; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block;">⚙️ Admin Promo</a>
        </p>
    </div>
</body>
</html>

