<!DOCTYPE html>
<html>
<head>
    <title>Debug Produk dengan Promo</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1400px; margin: 0 auto; background: white; padding: 20px; border-radius: 10px; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; border: 1px solid #ddd; text-align: left; font-size: 12px; }
        th { background: #1a1f3a; color: white; position: sticky; top: 0; }
        .has-promo { background: #d4edda !important; }
        .no-promo { background: #f8d7da !important; }
        .warning { background: #fff3cd !important; }
        h1 { color: #1a1f3a; }
        .info { background: #d1ecf1; padding: 15px; border-radius: 5px; margin: 15px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Debug Detail: Produk & Promo</h1>
        <p><strong>Waktu Sekarang:</strong> <?php echo date('Y-m-d H:i:s'); ?></p>
        
        <?php
        require_once('application/config/database.php');
        $conn = new mysqli($db['default']['hostname'], $db['default']['username'], $db['default']['password'], $db['default']['database']);
        
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }
        
        $now = date('Y-m-d H:i:s');
        
        // Query SAMA PERSIS dengan model Mproduk
        $sql = "SELECT produk.*, kategori.nama_kategori, 
            promo_produk.harga_diskon, 
            promo.status_promo, 
            promo.waktu_mulai, 
            promo.waktu_berakhir, 
            promo.tipe_diskon, 
            promo.nilai_diskon,
            promo.nama_promo
        FROM produk
        LEFT JOIN kategori ON kategori.id_kategori = produk.id_kategori
        LEFT JOIN promo_produk ON promo_produk.id_produk = produk.id_produk
        LEFT JOIN promo ON promo.id_promo = promo_produk.id_promo
        ORDER BY produk.id_produk DESC
        LIMIT 10";
        
        $result = $conn->query($sql);
        
        if ($result && $result->num_rows > 0) {
            echo "<table>";
            echo "<tr>
                <th>Produk</th>
                <th>Harga</th>
                <th>Promo</th>
                <th>harga_diskon (DB)</th>
                <th>status_promo</th>
                <th>waktu_mulai</th>
                <th>waktu_berakhir</th>
                <th>Mulai <= Now?</th>
                <th>Berakhir >= Now?</th>
                <th>Promo VALID?</th>
                <th>Harus Tampil?</th>
            </tr>";
            
            while($row = $result->fetch_assoc()) {
                // Logic SAMA dengan helper
                $has_data = !is_null($row['harga_diskon']) && $row['harga_diskon'] > 0;
                $promo_valid = false;
                $alasan = "";
                
                if($has_data) {
                    if($row['status_promo'] == 'aktif') {
                        $waktu_mulai = strtotime($row['waktu_mulai']);
                        $waktu_berakhir = strtotime($row['waktu_berakhir']);
                        $waktu_sekarang = strtotime($now);
                        
                        $mulai_ok = $waktu_mulai <= $waktu_sekarang;
                        $berakhir_ok = $waktu_berakhir >= $waktu_sekarang;
                        
                        if($mulai_ok && $berakhir_ok) {
                            $promo_valid = true;
                            $alasan = "VALID ✓";
                        } else {
                            if(!$mulai_ok) $alasan = "Belum mulai";
                            if(!$berakhir_ok) $alasan = "Sudah berakhir";
                        }
                    } else {
                        $alasan = "Status: " . $row['status_promo'];
                    }
                } else {
                    $alasan = "Tidak ada data promo";
                }
                
                $class = "";
                if($promo_valid) $class = "has-promo";
                elseif($has_data) $class = "warning";
                else $class = "no-promo";
                
                echo "<tr class='{$class}'>";
                echo "<td><strong>{$row['nama_produk']}</strong></td>";
                echo "<td>Rp " . number_format($row['harga_produk'], 0) . "</td>";
                echo "<td>" . ($row['nama_promo'] ? $row['nama_promo'] : '-') . "</td>";
                echo "<td>" . ($row['harga_diskon'] ? "Rp " . number_format($row['harga_diskon'], 0) : '<span style="color:red;">NULL</span>') . "</td>";
                echo "<td>" . ($row['status_promo'] ? $row['status_promo'] : '-') . "</td>";
                echo "<td style='font-size:10px;'>" . ($row['waktu_mulai'] ? $row['waktu_mulai'] : '-') . "</td>";
                echo "<td style='font-size:10px;'>" . ($row['waktu_berakhir'] ? $row['waktu_berakhir'] : '-') . "</td>";
                
                if($has_data && $row['status_promo'] == 'aktif') {
                    $waktu_mulai = strtotime($row['waktu_mulai']);
                    $waktu_berakhir = strtotime($row['waktu_berakhir']);
                    $waktu_sekarang = strtotime($now);
                    
                    $mulai_ok = $waktu_mulai <= $waktu_sekarang;
                    $berakhir_ok = $waktu_berakhir >= $waktu_sekarang;
                    
                    echo "<td style='color:" . ($mulai_ok ? 'green' : 'red') . "; font-weight:bold;'>" . ($mulai_ok ? 'YA ✓' : 'TIDAK ✗') . "</td>";
                    echo "<td style='color:" . ($berakhir_ok ? 'green' : 'red') . "; font-weight:bold;'>" . ($berakhir_ok ? 'YA ✓' : 'TIDAK ✗') . "</td>";
                } else {
                    echo "<td>-</td><td>-</td>";
                }
                
                echo "<td style='color:" . ($promo_valid ? 'green' : 'red') . "; font-weight:bold;'>{$alasan}</td>";
                echo "<td style='font-size:16px; font-weight:bold; color:" . ($promo_valid ? 'green' : 'red') . ";'>" . ($promo_valid ? 'YA ✓✓✓' : 'TIDAK ✗') . "</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            // Count
            $result->data_seek(0);
            $count_valid = 0;
            $count_has_data = 0;
            while($row = $result->fetch_assoc()) {
                if(!is_null($row['harga_diskon']) && $row['harga_diskon'] > 0) {
                    $count_has_data++;
                    if($row['status_promo'] == 'aktif') {
                        $waktu_mulai = strtotime($row['waktu_mulai']);
                        $waktu_berakhir = strtotime($row['waktu_berakhir']);
                        $waktu_sekarang = strtotime($now);
                        if($waktu_mulai <= $waktu_sekarang && $waktu_berakhir >= $waktu_sekarang) {
                            $count_valid++;
                        }
                    }
                }
            }
            
            echo "<div class='info'>";
            echo "<h3>📊 Ringkasan:</h3>";
            echo "<p><strong>Produk yang ada data promo:</strong> {$count_has_data}</p>";
            echo "<p><strong>Produk dengan promo VALID (harus tampil):</strong> <span style='font-size:24px; color:" . ($count_valid > 0 ? 'green' : 'red') . "; font-weight:bold;'>{$count_valid}</span></p>";
            
            if($count_valid == 0) {
                echo "<hr>";
                echo "<p style='color:red; font-weight:bold;'>❌ MASALAH: Tidak ada produk dengan promo valid!</p>";
                echo "<p><strong>Kemungkinan penyebab:</strong></p>";
                echo "<ol>";
                echo "<li>Produk belum ditambahkan ke promo (harga_diskon NULL)</li>";
                echo "<li>Status promo bukan 'aktif'</li>";
                echo "<li>Waktu promo belum dimulai atau sudah berakhir</li>";
                echo "</ol>";
                echo "<p><strong>Solusi:</strong> Buka <a href='../admin/promo' style='color:#1a1f3a; font-weight:bold;'>Admin Promo</a>, klik tombol '+' di promo yang aktif, lalu centang produk yang ingin diberi diskon.</p>";
            } else {
                echo "<hr>";
                echo "<p style='color:green; font-weight:bold;'>✅ BAGUS! {$count_valid} produk SEHARUSNYA tampil dengan badge diskon di customer.</p>";
                echo "<p>Jika belum tampil, coba:</p>";
                echo "<ol>";
                echo "<li>Hard refresh halaman customer (Ctrl+F5)</li>";
                echo "<li>Clear browser cache</li>";
                echo "<li>Cek console browser untuk error JavaScript</li>";
                echo "</ol>";
            }
            echo "</div>";
            
        } else {
            echo "<p style='color:red;'>Tidak ada produk</p>";
        }
        
        $conn->close();
        ?>
        
        <p style="margin-top:30px;">
            <a href="../customer" style="background:#1a1f3a; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block; margin-right:10px;">🏠 Lihat Customer</a>
            <a href="../admin/promo" style="background:#28a745; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block;">⚙️ Admin Promo</a>
        </p>
    </div>
</body>
</html>

