<?php
define('BASEPATH', 'dummy');
include 'application/config/rajaongkir.php';
$api_key = $config['rajaongkir_api_key'];

$endpoints = [
    'https://rajaongkir.komerce.id/api/v1/destination/city?province_id=1',
    'https://rajaongkir.komerce.id/api/v1/destination/regencies?province_id=1',
    'https://rajaongkir.komerce.id/api/v1/destination/regency?province_id=1',
    'https://rajaongkir.komerce.id/api/v1/destination/cities?province_id=1',
    'https://rajaongkir.komerce.id/api/v1/master/city?province_id=1',
    'https://rajaongkir.komerce.id/api/v1/destination/domestic-destination?search=a&limit=1', // Check structure of search result
];

$curl = curl_init();
$options = array(
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_HTTPHEADER => array('key: ' . $api_key),
);

foreach ($endpoints as $url) {
    echo "Testing: $url\n";
    $options[CURLOPT_URL] = $url;
    curl_setopt_array($curl, $options);
    $response = curl_exec($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    
    echo "HTTP Code: $http_code\n";
    if ($http_code == 200) {
        echo "Response Snippet: " . substr($response, 0, 200) . "\n";
    }
    echo "----------------------------------------\n";
}
curl_close($curl);
?>
