<!DOCTYPE html>
<html>
<head>
    <title>Test Badge Langsung</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; }
        .products-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(250px, 1fr)); gap: 30px; margin: 20px 0; }
        .product-card { background: white; border-radius: 15px; overflow: hidden; box-shadow: 0 5px 20px rgba(0,0,0,0.1); }
        .product-image { width: 100%; height: 200px; background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); display: flex; align-items: center; justify-content: center; }
        .product-info { padding: 20px; }
        .product-category { font-size: 12px; color: #d4af37; font-weight: 600; text-transform: uppercase; margin-bottom: 8px; }
        .product-name { font-size: 18px; font-weight: 600; color: #333; margin-bottom: 10px; }
        .stok-badge { font-size: 13px; font-weight: 500; color: #666; margin-bottom: 10px; }
        .info { background: #d1ecf1; padding: 15px; border-radius: 5px; margin: 15px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🧪 Test Badge Diskon LANGSUNG</h1>
        <p>Halaman ini test LANGSUNG tanpa melalui CodeIgniter</p>
        
        <?php
        // Direct database connection
        $conn = new mysqli('localhost', 'root', '', 'gerabah');
        
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }
        
        // Load helper
        require_once('application/helpers/promo_helper.php');
        
        // Query produk dengan promo
        $sql = "SELECT produk.*, kategori.nama_kategori, 
                promo_produk.harga_diskon, 
                promo.status_promo, 
                promo.waktu_mulai, 
                promo.waktu_berakhir, 
                promo.tipe_diskon, 
                promo.nilai_diskon,
                promo.nama_promo
                FROM produk
                LEFT JOIN kategori ON kategori.id_kategori = produk.id_kategori
                LEFT JOIN promo_produk ON promo_produk.id_produk = produk.id_produk
                LEFT JOIN promo ON promo.id_promo = promo_produk.id_promo
                ORDER BY produk.id_produk DESC
                LIMIT 8";
        
        $result = $conn->query($sql);
        
        if ($result && $result->num_rows > 0) {
            echo "<div class='info'>";
            echo "<h3>📊 Total Produk: {$result->num_rows}</h3>";
            echo "<p>Produk di bawah ini menggunakan EXACT SAME query dan helper seperti homepage asli.</p>";
            echo "</div>";
            
            echo "<div class='products-grid'>";
            
            while($row = $result->fetch_assoc()) {
                // Convert ke object
                $produk = (object) $row;
                
                // Get harga
                $harga = $produk->harga_produk;
                
                // Test helper
                $harga_info = get_harga_diskon($produk, $harga);
                $has_diskon = $harga_info['persen_diskon'] > 0;
                
                // Tampilkan produk card
                echo '<div class="product-card">';
                echo '<div class="product-image">';
                if(!empty($produk->gambar_produk)) {
                    $image_path = 'http://localhost/gerabah/admin/uploads/produk/'.$produk->gambar_produk;
                    echo '<img src="'.$image_path.'" style="width: 100%; height: 100%; object-fit: cover;">';
                } else {
                    echo '<i class="fas fa-image"></i>';
                }
                echo '</div>';
                echo '<div class="product-info">';
                echo '<div class="product-category">'.$produk->nama_kategori.'</div>';
                echo '<div class="product-name">'.$produk->nama_produk.'</div>';
                
                // Stok badge
                $stok = $produk->stok_produk;
                $stok_text = 'Stok: ' . $stok;
                if($stok == 0) $stok_text = 'STOK HABIS';
                elseif($stok <= 10) $stok_text = 'STOK RENDAH';
                
                echo '<div class="stok-badge">'.$stok_text.'</div>';
                
                // HARGA
                echo '<div style="margin-bottom: 10px;">';
                
                if($has_diskon) {
                    // BADGE DISKON
                    echo '<span style="background: linear-gradient(135deg, #ff424e 0%, #ff0017 100%); color: white; padding: 4px 10px; border-radius: 3px; font-size: 11px; font-weight: 700; display: inline-block; margin-bottom: 8px; box-shadow: 0 2px 5px rgba(255, 0, 23, 0.3);">';
                    echo '-'.$harga_info['persen_diskon'].'%';
                    echo '</span>';
                    
                    // Harga Diskon
                    echo '<div style="font-size: 20px; font-weight: 700; color: #ff424e; margin-bottom: 3px;">';
                    echo 'Rp'.number_format($harga_info['harga_diskon'], 0, ',', '.');
                    echo '</div>';
                    
                    // Harga Normal Dicoret
                    echo '<div style="font-size: 13px; color: #888; text-decoration: line-through;">';
                    echo 'Rp'.number_format($harga_info['harga_awal'], 0, ',', '.');
                    echo '</div>';
                    
                    // Debug info
                    echo '<div style="margin-top:10px; padding:10px; background:#d4edda; border-radius:5px; font-size:11px;">';
                    echo '<strong>✅ BADGE MUNCUL!</strong><br>';
                    echo 'has_diskon: TRUE<br>';
                    echo 'persen_diskon: '.$harga_info['persen_diskon'].'%<br>';
                    echo 'harga_diskon_db: '.($produk->harga_diskon ? 'Rp'.number_format($produk->harga_diskon, 0) : 'NULL').'<br>';
                    echo 'status_promo: '.($produk->status_promo ?: 'NULL').'<br>';
                    echo '</div>';
                } else {
                    // Harga Normal
                    echo '<div style="font-size: 24px; font-weight: 700; color: #d4af37;">';
                    echo 'Rp '.number_format($harga, 0, ',', '.');
                    echo '</div>';
                    
                    // Debug info
                    echo '<div style="margin-top:10px; padding:10px; background:#f8d7da; border-radius:5px; font-size:11px;">';
                    echo '<strong>❌ BADGE TIDAK MUNCUL</strong><br>';
                    echo 'has_diskon: FALSE<br>';
                    echo 'persen_diskon: '.$harga_info['persen_diskon'].'%<br>';
                    echo 'harga_diskon_db: '.($produk->harga_diskon ? 'Rp'.number_format($produk->harga_diskon, 0) : 'NULL').'<br>';
                    echo 'status_promo: '.($produk->status_promo ?: 'NULL').'<br>';
                    echo '</div>';
                }
                
                echo '</div>';
                echo '</div>';
                echo '</div>';
            }
            
            echo "</div>";
        } else {
            echo "<p style='color:red;'>Tidak ada produk</p>";
        }
        
        $conn->close();
        ?>
        
        <hr style="margin:40px 0;">
        <div class="info">
            <h3>📝 Catatan:</h3>
            <ul>
                <li>Jika badge <strong style="color:green;">MUNCUL DI SINI</strong> tapi <strong style="color:red;">TIDAK MUNCUL DI HOMEPAGE</strong> = masalahnya <strong>BROWSER CACHE</strong></li>
                <li>Jika badge <strong style="color:red;">TIDAK MUNCUL DI SINI</strong> = masalahnya <strong>DATABASE atau HELPER</strong></li>
            </ul>
            
            <h4>Solusi jika badge muncul di sini tapi tidak di homepage:</h4>
            <ol>
                <li><strong>Clear Browser Cache:</strong> Ctrl+Shift+Delete</li>
                <li><strong>Hard Refresh:</strong> Ctrl+F5 (Windows) atau Cmd+Shift+R (Mac)</li>
                <li><strong>Incognito Mode:</strong> Ctrl+Shift+N</li>
                <li><strong>Restart Browser</strong> sepenuhnya</li>
            </ol>
        </div>
        
        <p style="margin-top:30px;">
            <a href="index.php" style="background:#1a1f3a; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block; margin-right:10px;">🏠 Homepage Customer</a>
            <a href="debug_full.php" style="background:#007bff; color:white; padding:12px 24px; text-decoration:none; border-radius:5px; display:inline-block;">🔍 Debug Full</a>
        </p>
    </div>
</body>
</html>

